<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:n1="http://www.giif.mofnet.gov.pl/xsd/upo/2018" xmlns:n2="http://www.w3.org/2000/09/xmldsig#">

	<xsl:template match="/n2:Signature">
			<html>
			<head>
				<meta http-equiv="content-type" content="text/html; charset=utf-8"/>
				<link rel="stylesheet" type="text/css" href="upo.css"/>
			</head>
			<body>
					<xsl:call-template name="dane">
						<xsl:with-param name="path" select="/n2:Signature/n2:Object/n1:Potwierdzenie"/>
					</xsl:call-template>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="dane">
	<xsl:param name="path"/>
				<div  id="container">URZĘDOWE POŚWIADCZENIE ODBIORU <br/>DOKUMENTU ELEKTRONICZNEGO
				<div class="sekcjaA">A. NAZWA PEŁNA PODMIOTU, KTÓREMU DORĘCZONO DOKUMENT ELEKTRONICZNY
					<div class="sekcjaAB"><xsl:value-of select="$path/n1:NazwaPodmiotuPrzyjmujacego"/></div>
				</div>
				<div class="sekcjaB">
					<div class="sekcjaB1" style="font-weight: bold;">B. INFORMACJE O DOKUMENCIE</div>
					<div style="text-align: left; margin-left:30px; margin-bottom:10px;">Dokument został zarejestrowany w systemie teleinformatycznym GIIF</div>

					<div class="dane_p">
						<p class="opis">Identyfikator dokumentu:</p>
						<p class="wartosc"><xsl:value-of select="$path/n1:NumerReferencyjny"/></p>
					</div>
					<div class="dane">
						<p class="opis">Data (data i czas):</p>
						<p class="wartosc"><xsl:value-of select="$path/n1:DataWplyniecia"/></p>
					</div>
					<div class="dane">
						<p class="opis">Skrót złożonego dokumentu - identyczny z wartością użytą do podpisu dokumentu:</p>
						<p class="wartosc"><xsl:value-of select="$path/n1:SkrotDokumentu"/></p>
					</div>
					<div class="dane">
						<p class="opis">Skrót dokumentu otrzymanego przez system:</p>
						<p class="wartosc"><xsl:value-of select="$path/n1:SkrotZlozonejStruktury"/></p>
					</div>
					<div class="dane">
						<p class="opis">Dokument zweryfikowano pod względem zgodności ze strukturą logiczną:</p>
						<p class="wartosc"><xsl:value-of select="$path/n1:NazwaStrukturyLogicznej"/></p>
					</div>
					<div class="dane_p">
						<p class="opis">Numer Identyfikacji Podatkowej Instytucji Obowiązanej:</p>
						<p class="wartosc"><xsl:value-of select="$path/n1:NIPIO"/></p>
					</div>
					<div class="dane">
						<p class="opis">Data otrzymania dokumentu papierowego:</p>
						<p class="wartosc"><xsl:value-of select="$path/n1:DataWplynieciaPotwierdzenia"/></p>
					</div>
					<div class="dane">
						<p class="opis">Data i czas wystawienia dokumentu:</p>
						<p class="wartosc"><xsl:value-of select="$path/n1:DataICzasUPO"/></p>
					</div>
					<div class="czysc"/>
					<div class="footer">1/1</div>
					<div class="footer">UPO</div>
				</div>

			</div>
		
</xsl:template>
</xsl:stylesheet>

