/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.conf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import pl.gov.gugik.gesut.dak.Aplikacja;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;

public class Konfiguracja {
    private static final String PLIK_KONFIGURACJI = "app.properties";
    public static final String PROPERTY_CZY_CACHOWAC_XSD = "czyCacheowacXSD";
    public static final String PROPERTY_WERSJA = "wersja";
    private static final String PROPERTY_CZY_DEBUG = "debug";
    public static final String PROPERTY_SCHEMAT_XSD = "schematAplikacji";
    public static final String PROPERTY_SZABLON_KONTROLI = "szablonKontroli";
    public static final String PROPERTY_CZY_LOKALNY_KATALOG = "czyLokalnyKatalogTMP";
    public static final String PROPERTY_KATALOG_LOGOW = "katalogLogow";
    private static Konfiguracja instancja;
    private Properties properties = new Properties();
    private boolean czyDebug = false;
    private String wersja = "";
    private static ResourceBundle bundle;

    public Konfiguracja(String nazwaPliku) {
        InputStream inputStream = Aplikacja.class.getResourceAsStream(nazwaPliku);
        if (inputStream != null) {
            try {
                this.properties.load(inputStream);
                this.czyDebug = this.pobierzBool(PROPERTY_CZY_DEBUG);
                this.wersja = this.properties.getProperty(PROPERTY_WERSJA);
            }
            catch (IOException e) {
                ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
            }
        }
        bundle = ResourceBundle.getBundle("bundles.dak", Locale.getDefault());
    }

    public static Konfiguracja getInstancja() {
        return Konfiguracja.getInstancja(PLIK_KONFIGURACJI);
    }

    public static Konfiguracja getInstancja(String nazwaPliku) {
        instancja = new Konfiguracja(nazwaPliku);
        return instancja;
    }

    public Boolean pobierzBool(String klucz) {
        String wartosc = this.properties.getProperty(klucz);
        return Boolean.parseBoolean(wartosc);
    }

    public String pobierzString(String klucz) {
        return this.properties.getProperty(klucz);
    }

    public boolean czyDebug() {
        return this.czyDebug;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getWersja() {
        return this.wersja;
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }
}

