/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.kontrole.executory;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.log4j.Logger;
import org.joox.Match;
import pl.gov.gugik.gesut.dak.biz.kontrole.executory.KontrolaExecutor;
import pl.gov.gugik.gesut.dak.biz.utils.kontrole.ObiektHelper;
import pl.gov.gugik.gesut.dak.model.kontrole.BladKontroli;
import pl.gov.gugik.gesut.dak.model.kontrole.WynikKontroli;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.Atrybut;

public class KontrolaObligatoryjnoscWarunkowaExecutor
extends KontrolaExecutor {
    private static final Logger log = Logger.getLogger(KontrolaObligatoryjnoscWarunkowaExecutor.class);
    private static final String NIL_REASON = "nilReason";
    private List<Atrybut> atrybuty;

    @Override
    public WynikKontroli kontroluj(Match feature, String nazwaKontrolowanegoPliku) {
        WynikKontroli wynikKontroli = new WynikKontroli();
        wynikKontroli.setPozytywny(true);
        if (!this.czyObiektZawieraAtrybut(feature, this.atrybuty)) {
            wynikKontroli.setPozytywny(false);
            BladKontroli bladKontroli = this.budujBladKontroli(feature, this.atrybuty, nazwaKontrolowanegoPliku);
            wynikKontroli.setBladKontroli(bladKontroli);
        }
        return wynikKontroli;
    }

    public void ustawAtrybuty(List<Atrybut> atrybuty) {
        this.atrybuty = atrybuty;
    }

    private BladKontroli budujBladKontroli(Match feature, List<Atrybut> atrybuty, String nazwaKontrolowanegoPliku) {
        BladKontroli bladKontroli = this.generujBladKontroli(feature, nazwaKontrolowanegoPliku);
        bladKontroli.setAttr1Naz(ObiektHelper.zwrocNazweAtrybutu(atrybuty.get(0)));
        if (atrybuty.size() > 1) {
            bladKontroli.setAttr2Naz(ObiektHelper.zwrocNazweAtrybutu(atrybuty.get(1)));
        }
        if (atrybuty.size() > 2) {
            bladKontroli.setAttr3Naz(ObiektHelper.zwrocNazweAtrybutu(atrybuty.get(2)));
        }
        return bladKontroli;
    }

    private boolean czyObiektZawieraAtrybut(Match obiekt, List<Atrybut> atrybuty) {
        return atrybuty.stream().anyMatch(a -> this.czyObiektZawieraAtrybut(obiekt, (Atrybut)a));
    }

    private boolean czyObiektZawieraAtrybut(Match obiekt, Atrybut atrybut) {
        String nazwaAtrybutu = ObiektHelper.zwrocNazweAtrybutu(atrybut);
        if (ObiektHelper.czyWypelnionyNilElementNadrzedny(obiekt, atrybut)) {
            return true;
        }
        if (nazwaAtrybutu.contains(NIL_REASON)) {
            Match atrybutObiektu = obiekt.find(atrybut.getNazwaAtrybutu().split("_")[0]);
            return !Strings.isNullOrEmpty((String)atrybutObiektu.attr(NIL_REASON));
        }
        if (atrybut.getNazwaAtrybutu() != null) {
            Match match = obiekt.children(nazwaAtrybutu);
            return match != null && !Strings.isNullOrEmpty((String)match.text());
        }
        if (atrybut.getPodrzedny() != null) {
            Match match = obiekt.children(atrybut.getPodrzedny().getNazwaAtrybutu());
            return (match = match.find(nazwaAtrybutu)) != null && !Strings.isNullOrEmpty((String)match.text());
        }
        return false;
    }
}

