/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.kontrole.executory;

import java.util.List;
import org.apache.log4j.Logger;
import org.joox.Match;
import org.w3c.dom.Element;
import pl.gov.gugik.gesut.dak.biz.kontrole.executory.KontrolaExecutor;
import pl.gov.gugik.gesut.dak.biz.kontrole.walidacje.WalidacjaZbiorWartosciHelper;
import pl.gov.gugik.gesut.dak.biz.utils.kontrole.ObiektHelper;
import pl.gov.gugik.gesut.dak.model.kontrole.BladKontroli;
import pl.gov.gugik.gesut.dak.model.kontrole.WynikKontroli;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.Wartosc;

public class KontrolaWartoscWZbiorzeExecutor
extends KontrolaExecutor {
    private static final Logger log = Logger.getLogger(KontrolaWartoscWZbiorzeExecutor.class);
    private List<Wartosc> wartosci;

    @Override
    public WynikKontroli kontroluj(Match feature, String nazwaKontrolowanegoPliku) {
        String wartoscAtrybutu;
        WynikKontroli wynikKontroli = new WynikKontroli();
        Match obiektAtrybutu = ObiektHelper.pobierzWartoscAtrybutu(feature, this.getAtrybut());
        wynikKontroli.setPozytywny(true);
        if (obiektAtrybutu.isNotEmpty()) {
            for (Element element : obiektAtrybutu.get()) {
                String wartoscAtrybutu2 = element.getTextContent();
                if ((wartoscAtrybutu2 == null || wartoscAtrybutu2.isEmpty()) && element.getTagName().equalsIgnoreCase("ges:adresPRG")) {
                    wartoscAtrybutu2 = element.getAttribute("xlink:href");
                }
                if (WalidacjaZbiorWartosciHelper.sprawdzCzyWZakresie(wartoscAtrybutu2, this.wartosci, obiektAtrybutu) || ObiektHelper.czyElementNil(obiektAtrybutu)) continue;
                this.dodajBlad(feature, nazwaKontrolowanegoPliku, wynikKontroli, wartoscAtrybutu2);
            }
        } else if (ObiektHelper.zwrocNazweAtrybutu(this.getAtrybut()).contains("_nilReason")) {
            String nazwaAtrybutu = ObiektHelper.zwrocNazweAtrybutu(this.getAtrybut()).split("_")[0];
            Match obiektZNil = feature.find(nazwaAtrybutu);
            String wartoscAtrybutu3 = obiektZNil.attr("nilReason");
            if (!WalidacjaZbiorWartosciHelper.sprawdzCzyWZakresie(wartoscAtrybutu3, this.wartosci, obiektAtrybutu) && ObiektHelper.czyElementNil(obiektZNil)) {
                this.dodajBlad(feature, nazwaKontrolowanegoPliku, wynikKontroli, wartoscAtrybutu3);
            }
        } else if (ObiektHelper.zwrocNazweAtrybutu(this.getAtrybut()).contains("_srsName")) {
            Match geometria;
            String wartoscSrs;
            String nazwaAtrybutu = ObiektHelper.zwrocNazweAtrybutu(this.getAtrybut()).split("_")[0];
            Match obiekt = feature.find(nazwaAtrybutu);
            if (obiekt.isNotEmpty() && !WalidacjaZbiorWartosciHelper.sprawdzCzyWZakresie(wartoscSrs = (geometria = obiekt.child()).attr("srsName"), this.wartosci, geometria)) {
                this.dodajBlad(feature, nazwaKontrolowanegoPliku, wynikKontroli, wartoscSrs);
            }
        } else if (this.getAtrybut().getNazwaAtrybutu() != null && this.czyZbiorZawieraWartoscANY(this.wartosci) && !WalidacjaZbiorWartosciHelper.sprawdzCzyWZakresie(wartoscAtrybutu = null, this.wartosci, obiektAtrybutu)) {
            this.dodajBlad(feature, nazwaKontrolowanegoPliku, wynikKontroli, wartoscAtrybutu);
        }
        return wynikKontroli;
    }

    private void dodajBlad(Match feature, String nazwaKontrolowanegoPliku, WynikKontroli wynikKontroli, String wartoscAtrybutu) {
        wynikKontroli.setPozytywny(false);
        BladKontroli bladKontroli = this.budujBladKontroli(feature, wartoscAtrybutu, nazwaKontrolowanegoPliku);
        wynikKontroli.setBladKontroli(bladKontroli);
    }

    private BladKontroli budujBladKontroli(Match feature, String wartoscAtrybutu, String nazwaKontrolowanegoPliku) {
        BladKontroli bladKontroli = this.generujBladKontroli(feature, nazwaKontrolowanegoPliku);
        bladKontroli.setAttr1Wart(wartoscAtrybutu);
        return bladKontroli;
    }

    private boolean czyZbiorZawieraWartoscANY(List<Wartosc> wartosci) {
        return wartosci.stream().anyMatch(w -> w.getValue().equals("any"));
    }

    public List<Wartosc> getWartosci() {
        return this.wartosci;
    }

    public void setWartosci(List<Wartosc> wartosci) {
        this.wartosci = wartosci;
    }
}

