/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.kontrole.executory;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joox.Match;
import org.w3c.dom.Element;
import pl.gov.gugik.gesut.dak.biz.kontrole.executory.KontrolaExecutor;
import pl.gov.gugik.gesut.dak.biz.utils.kontrole.ObiektHelper;
import pl.gov.gugik.gesut.dak.model.kontrole.BladKontroli;
import pl.gov.gugik.gesut.dak.model.kontrole.WynikKontroli;

public class KontrolaZgodnoscZeWzorcemExecutor
extends KontrolaExecutor {
    private String wzorzec;
    private Pattern pattern;

    @Override
    public WynikKontroli kontroluj(Match feature, String nazwaKontrolowanegoPliku) {
        Match atrybut = ObiektHelper.pobierzWartoscAtrybutu(feature, this.getAtrybut());
        WynikKontroli wynikKontroli = new WynikKontroli();
        wynikKontroli.setPozytywny(true);
        if (atrybut.isNotEmpty()) {
            for (Element element : atrybut.get()) {
                String wartoscAtrybutu = element.getTextContent();
                Matcher matcher = this.pattern.matcher(wartoscAtrybutu);
                if (matcher.matches()) continue;
                BladKontroli bladKontroli = this.budujBladKontroli(feature, wartoscAtrybutu, nazwaKontrolowanegoPliku);
                wynikKontroli.setPozytywny(false);
                wynikKontroli.setBladKontroli(bladKontroli);
            }
        }
        return wynikKontroli;
    }

    private BladKontroli budujBladKontroli(Match feature, String wartoscAtrybutu, String nazwaKontrolowanegoPliku) {
        BladKontroli bladKontroli = this.generujBladKontroli(feature, nazwaKontrolowanegoPliku);
        bladKontroli.setAttr1Wart(wartoscAtrybutu);
        return bladKontroli;
    }

    public void ustawWzorzecISkompiluj(String wzorzec) {
        this.wzorzec = wzorzec;
        this.pattern = Pattern.compile(wzorzec);
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

