/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.raporty;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.BledyWeryfikacjiService;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;
import pl.gov.gugik.gesut.dak.biz.service.pliki.PlikiTymczasoweService;
import pl.gov.gugik.gesut.dak.biz.utils.raporty.pdf.PDFBuilder;
import pl.gov.gugik.gesut.dak.model.kontrole.BladKontroli;
import pl.gov.gugik.gesut.dak.model.raporty.GrupaKontroliAtrybutowych;
import pl.gov.gugik.gesut.dak.model.raporty.KontrolaAtrybutowa;
import pl.gov.gugik.gesut.dak.model.raporty.KontroleAtrybutowe;
import pl.gov.gugik.gesut.dak.model.raporty.WalidacjaZeSchematem;
import pl.gov.gugik.gesut.dak.model.raporty.Wynik;

public class RaportPdfService {
    private BledyWeryfikacjiService bledyWeryfikacjiService;
    private XMLStreamWriter writer;
    private Wynik wynik;

    public RaportPdfService(BledyWeryfikacjiService bledyWeryfikacjiService) {
        this.bledyWeryfikacjiService = bledyWeryfikacjiService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File generujPrzejsciowyPlikWynikowy() throws IOException, JAXBException, XMLStreamException {
        try (FileOutputStream fos = null;){
            File plikTymczasowy = PlikiTymczasoweService.pobierzInstancje().tworzPlikTymczasowy(".dat");
            fos = new FileOutputStream(plikTymczasowy);
            this.generujPlikPrzejsciowy(fos);
            File file = plikTymczasowy;
            return file;
        }
    }

    private void generujPlikPrzejsciowy(FileOutputStream fos) throws JAXBException, XMLStreamException, IOException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Wynik.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        this.writer = XMLOutputFactory.newFactory().createXMLStreamWriter(fos);
        this.writer.writeStartDocument();
        this.writer.writeStartElement("Wynik");
        this.writer.writeStartElement("WersjaAplikacji");
        this.writer.writeCharacters(this.wynik.getWersjaAplikacji());
        this.writer.writeEndElement();
        this.writer.writeStartElement("WynikOgolnyKontroli");
        this.writer.writeCharacters(this.wynik.getWynikOgolnyKontroli());
        this.writer.writeEndElement();
        this.writer.writeStartElement("DataWygenerowaniaRaportu");
        this.writer.writeCharacters(this.wynik.getDataWygenerowaniaRaportu());
        this.writer.writeEndElement();
        this.writer.writeStartElement("WersjaSzablonuWeryfikacji");
        this.writer.writeCharacters(this.wynik.getWersjaSzablonuWeryfikacji());
        this.writer.writeEndElement();
        this.writer.writeStartElement("NazwaPliku");
        this.writer.writeCharacters(this.wynik.getNazwaPliku());
        this.writer.writeEndElement();
        this.writer.writeStartElement("NazwaPlikuBezSciezki");
        this.writer.writeCharacters(this.wynik.getNazwaPlikuBezSciezki());
        this.writer.writeEndElement();
        marshaller.marshal((Object)this.wynik.getPodsumowanie(), this.writer);
        this.dopiszWynikWalidacji();
        this.dopiszKontroleAtrybutowe();
        this.writer.writeEndDocument();
        this.writer.close();
        fos.flush();
    }

    private void dopiszBladKontroliAtrybutowej(BladKontroli bladKontroli) throws XMLStreamException {
        if (bladKontroli == null) {
            return;
        }
        this.writer.writeStartElement("BladKontroliAtrybutowej");
        this.writer.writeStartElement("Klasa");
        this.writer.writeCharacters(bladKontroli.getKlasa());
        this.writer.writeEndElement();
        this.writer.writeStartElement("LokalnyID");
        this.writer.writeCharacters(bladKontroli.getIdLokalne());
        this.writer.writeEndElement();
        this.writer.writeStartElement("GMLID");
        this.writer.writeCharacters(bladKontroli.getGmlId());
        this.writer.writeEndElement();
        if (bladKontroli.getAttr1Wart() != null) {
            this.writer.writeStartElement("Atrybut1Wartosc");
            this.writer.writeCharacters(bladKontroli.getAttr1Wart());
            this.writer.writeEndElement();
        }
        if (bladKontroli.getAttr2Wart() != null) {
            this.writer.writeStartElement("Atrybut2Wartosc");
            this.writer.writeCharacters(bladKontroli.getAttr2Wart());
            this.writer.writeEndElement();
        }
        if (bladKontroli.getAttr3Wart() != null) {
            this.writer.writeStartElement("Atrybut3Wartosc");
            this.writer.writeCharacters(bladKontroli.getAttr3Wart());
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    private void dopiszKontroleAtrybotowa(KontrolaAtrybutowa kontrolaAtrybutowa) throws XMLStreamException {
        this.writer.writeStartElement("KontrolaAtrybutowa");
        this.writer.writeStartElement("Id");
        this.writer.writeCharacters(kontrolaAtrybutowa.getId());
        this.writer.writeEndElement();
        this.writer.writeStartElement("Nazwa");
        this.writer.writeCharacters(kontrolaAtrybutowa.getNazwa());
        this.writer.writeEndElement();
        this.writer.writeStartElement("Komunikat");
        this.writer.writeCharacters(kontrolaAtrybutowa.getKomunikat());
        this.writer.writeEndElement();
        this.writer.writeStartElement("WynikKontroli");
        this.writer.writeCharacters(kontrolaAtrybutowa.getWynikKontroli());
        this.writer.writeEndElement();
        this.writer.writeStartElement("StatusKontroli");
        this.writer.writeCharacters(kontrolaAtrybutowa.getStatusKontroli());
        this.writer.writeEndElement();
        this.writer.writeStartElement("LiczbaBledow");
        this.writer.writeCharacters(kontrolaAtrybutowa.getLiczbaBledow().toString());
        this.writer.writeEndElement();
        this.writer.writeStartElement("WyswietlanaLiczbaBledow");
        this.writer.writeCharacters(kontrolaAtrybutowa.getWyswietlanaLiczbaBledow().toString());
        this.writer.writeEndElement();
        if (kontrolaAtrybutowa.getAtrybut1Nazwa() != null) {
            this.writer.writeStartElement("Atrybut1Nazwa");
            this.writer.writeCharacters(kontrolaAtrybutowa.getAtrybut1Nazwa());
            this.writer.writeEndElement();
        }
        if (kontrolaAtrybutowa.getAtrybut2Nazwa() != null) {
            this.writer.writeStartElement("Atrybut2Nazwa");
            this.writer.writeCharacters(kontrolaAtrybutowa.getAtrybut2Nazwa());
            this.writer.writeEndElement();
        }
        if (kontrolaAtrybutowa.getAtrybut3Nazwa() != null) {
            this.writer.writeStartElement("Atrybut3Nazwa");
            this.writer.writeCharacters(kontrolaAtrybutowa.getAtrybut3Nazwa());
            this.writer.writeEndElement();
        }
        this.writer.writeStartElement("ListaBledow");
        this.bledyWeryfikacjiService.pobierzIteratorBledowKontroli(this.wynik.getNazwaPliku(), kontrolaAtrybutowa.getId(), true).forEachRemaining(bladKontroli -> {
            try {
                this.dopiszBladKontroliAtrybutowej((BladKontroli)bladKontroli);
            }
            catch (XMLStreamException e) {
                ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
            }
        });
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    private void dopiszGrupeKontroliAtrybutowych(GrupaKontroliAtrybutowych grupaKontroliAtrybutowych) throws XMLStreamException {
        this.writer.writeStartElement("GrupaKontroliAtrybutowych");
        this.writer.writeStartElement("Nazwa");
        this.writer.writeCharacters(grupaKontroliAtrybutowych.getNazwa());
        this.writer.writeEndElement();
        grupaKontroliAtrybutowych.getKontrolaAtrybutowa().forEach(kontrolaAtrybutowa -> {
            try {
                this.dopiszKontroleAtrybotowa((KontrolaAtrybutowa)kontrolaAtrybutowa);
            }
            catch (XMLStreamException e) {
                ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
            }
        });
        this.writer.writeEndElement();
    }

    private void dopiszKontroleAtrybutowe() throws XMLStreamException {
        KontroleAtrybutowe kontroleAtrybutowe = this.wynik.getKontroleAtrybutowe();
        this.writer.writeStartElement("KontroleAtrybutowe");
        this.writer.writeStartElement("StatusKontroli");
        this.writer.writeCharacters(kontroleAtrybutowe.getStatusKontroli());
        this.writer.writeEndElement();
        this.writer.writeStartElement("WynikKontroli");
        this.writer.writeCharacters(kontroleAtrybutowe.getWynikKontroli());
        this.writer.writeEndElement();
        kontroleAtrybutowe.getGrupaKontroliAtrybutowych().forEach(grupaKontroliAtrybutowych -> {
            try {
                this.dopiszGrupeKontroliAtrybutowych((GrupaKontroliAtrybutowych)grupaKontroliAtrybutowych);
            }
            catch (XMLStreamException e) {
                ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
            }
        });
        this.writer.writeEndElement();
    }

    private void dopiszBledyWalidacji() {
        this.bledyWeryfikacjiService.pobierzIteratorBledowWalidacji(this.wynik.getNazwaPliku(), true).forEachRemaining(bladWalidacji -> {
            if (bladWalidacji != null) {
                try {
                    this.writer.writeStartElement("BladKontroli");
                    this.writer.writeCharacters("Linia " + bladWalidacji.getLinia() + ": " + bladWalidacji.getKomunikat());
                    this.writer.writeEndElement();
                }
                catch (XMLStreamException e) {
                    ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
                }
            }
        });
    }

    private void dopiszWynikWalidacji() throws XMLStreamException {
        WalidacjaZeSchematem walidacjaZeSchematem = this.wynik.getWalidacjaZeSchematem();
        this.writer.writeStartElement("WalidacjaZeSchematem");
        this.writer.writeStartElement("StatusKontroli");
        this.writer.writeCharacters(walidacjaZeSchematem.getStatusKontroli());
        this.writer.writeEndElement();
        this.writer.writeStartElement("WynikKontroli");
        this.writer.writeCharacters(walidacjaZeSchematem.getWynikKontroli());
        this.writer.writeEndElement();
        if (walidacjaZeSchematem.getWynikKontroli().equals("Negatywny")) {
            this.writer.writeStartElement("WyswietlanychBledow");
            this.writer.writeCharacters(walidacjaZeSchematem.getWyswietlanychBledowWalidacji().toString());
            this.writer.writeEndElement();
            this.writer.writeStartElement("LiczbaBledow");
            this.writer.writeCharacters(walidacjaZeSchematem.getLiczbaBledowWalidacji().toString());
            this.writer.writeEndElement();
            this.writer.writeStartElement("ListaBledow");
            this.dopiszBledyWalidacji();
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    public void generujPdf(String nazwaPliku, Wynik wynik) {
        this.wynik = wynik;
        PDFBuilder pdfBuilder = new PDFBuilder(nazwaPliku);
        try {
            File plikPrzejsciowy = this.generujPrzejsciowyPlikWynikowy();
            plikPrzejsciowy.deleteOnExit();
            FileInputStream fi = new FileInputStream(plikPrzejsciowy);
            pdfBuilder.wypelnijSzablon(fi);
            plikPrzejsciowy.delete();
        }
        catch (IOException | URISyntaxException | JAXBException | XMLStreamException | TransformerException | SAXException e) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
        }
    }
}

