/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.raporty;

import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.BledyWeryfikacjiService;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.WynikKontroliService;
import pl.gov.gugik.gesut.dak.biz.service.raporty.RaportCSVService;
import pl.gov.gugik.gesut.dak.biz.service.raporty.RaportPdfService;
import pl.gov.gugik.gesut.dak.biz.utils.DateUtils;
import pl.gov.gugik.gesut.dak.model.kontrole.OgolneParametryKontroli;
import pl.gov.gugik.gesut.dak.model.raporty.Wynik;

public class RaportService {
    private OgolneParametryKontroli ogolneParametryKontroli;
    private WynikKontroliService wynikKontroliService;
    private BledyWeryfikacjiService bledyWeryfikacjiService;
    private Wynik wynik;

    public RaportService(OgolneParametryKontroli ogolneParametryKontroli, WynikKontroliService wynikKontroliService, BledyWeryfikacjiService bledyWeryfikacjiService) {
        this.ogolneParametryKontroli = ogolneParametryKontroli;
        this.wynikKontroliService = wynikKontroliService;
        this.bledyWeryfikacjiService = bledyWeryfikacjiService;
        this.wynik = wynikKontroliService.pobierzWynikiKontroli();
    }

    public Wynik generuj() {
        String dataRaportu = this.budujDateRaportu();
        if (!this.ogolneParametryKontroli.isCzyRaportCSV() && !this.ogolneParametryKontroli.isCzyRaportPDF()) {
            this.generujPdf(dataRaportu);
            this.generujCsv(dataRaportu);
        }
        if (this.ogolneParametryKontroli.isCzyRaportPDF()) {
            this.generujPdf(dataRaportu);
        }
        if (this.ogolneParametryKontroli.isCzyRaportCSV()) {
            this.generujCsv(dataRaportu);
        }
        return this.wynik;
    }

    private String budujDateRaportu() {
        return DateUtils.formatujDate(new Date(), "yyyy_MM_dd_HH_mm_ss");
    }

    private String budujSciezkePliku(String nazwaPliku) {
        return FilenameUtils.concat((String)this.ogolneParametryKontroli.getSciezkaWybranegoFolderuRaportow(), (String)nazwaPliku);
    }

    private void generujPdf(String dataRaportu) {
        String nazwaPliku = this.budujSciezkeDoPlikuRaportu(dataRaportu, ".pdf");
        RaportPdfService pdfService = new RaportPdfService(this.bledyWeryfikacjiService);
        pdfService.generujPdf(nazwaPliku, this.wynik);
    }

    private void generujCsv(String dataRaportu) {
        String nazwaPliku = this.budujSciezkeDoPlikuRaportu(dataRaportu, ".csv");
        RaportCSVService csvService = new RaportCSVService(this.bledyWeryfikacjiService);
        csvService.generujCsv(nazwaPliku, this.wynik);
    }

    private String budujSciezkeDoPlikuRaportu(String dataRaportu, String rozszerzenie) {
        String nazwaPliku = FilenameUtils.getBaseName((String)this.wynik.getNazwaPliku());
        nazwaPliku = nazwaPliku + "_" + dataRaportu + rozszerzenie;
        nazwaPliku = this.budujSciezkePliku(nazwaPliku);
        return nazwaPliku;
    }
}

