/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.utils.walidacja;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import pl.gov.gugik.gesut.dak.biz.conf.Konfiguracja;
import pl.gov.gugik.gesut.dak.biz.kontrole.KontrolaTask;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.BledyWeryfikacjiService;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.SciezkaWzglednaResourceResolver;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.handlery.DziennikHandler;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.handlery.ZawartoscHandler;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BladWalidatoraXsd;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BrakZaleznegoPlikuXSD;

public class WalidatorXsd {
    private XMLReader parser;
    private SciezkaWzglednaResourceResolver sciezkaWzglednaResourceResolver;
    private ZawartoscHandler zawartoscHandler;

    public WalidatorXsd(File plikXsd, KontrolaTask kontrolaTask) throws BladWalidatoraXsd, BrakZaleznegoPlikuXSD {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (Konfiguracja.getInstancja().pobierzBool("czyCacheowacXSD").booleanValue()) {
                this.sciezkaWzglednaResourceResolver = new SciezkaWzglednaResourceResolver();
                schemaFactory.setResourceResolver(this.sciezkaWzglednaResourceResolver);
            }
            Schema schema = schemaFactory.newSchema(plikXsd);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setSchema(schema);
            this.parser = factory.newSAXParser().getXMLReader();
            this.zawartoscHandler = new ZawartoscHandler(kontrolaTask);
            this.parser.setContentHandler(this.zawartoscHandler);
        }
        catch (ParserConfigurationException | SAXException e) {
            if (this.sciezkaWzglednaResourceResolver.isCzyWszystkiePliki()) {
                throw new BladWalidatoraXsd(e);
            }
            throw new BrakZaleznegoPlikuXSD(this.sciezkaWzglednaResourceResolver.pobierzNazweBrakujacegoPliku());
        }
    }

    public boolean sprawdzPlik(File plikXml, BledyWeryfikacjiService bledyWeryfikacjiService) throws BladWalidatoraXsd {
        DziennikHandler dziennikHandler = new DziennikHandler(bledyWeryfikacjiService, plikXml.getAbsolutePath());
        this.parser.setErrorHandler(dziennikHandler);
        this.zawartoscHandler.setLiczbaObiektow(0);
        try {
            this.parsuj(plikXml);
            return dziennikHandler.isPoprawny();
        }
        catch (IOException | SAXException e) {
            throw new BladWalidatoraXsd(e);
        }
    }

    private void parsuj(File plikXml) throws IOException, SAXException {
        try (BufferedInputStream inputStream = null;){
            inputStream = new BufferedInputStream(new FileInputStream(plikXml));
            this.parser.parse(new InputSource(new InputStreamReader(inputStream)));
            inputStream.close();
        }
    }

    public int pobierzLiczbeObiektow() {
        return this.zawartoscHandler.getLiczbaObiektow();
    }
}

