/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;
import pl.gov.gugik.gesut.dak.dao.BladWalidacjiTableHelper;
import pl.gov.gugik.gesut.dak.dao.BladWeryfikacjiTable;
import pl.gov.gugik.gesut.dak.dao.ResultSetIterator;
import pl.gov.gugik.gesut.dak.dao.wyjatki.BladSQLException;
import pl.gov.gugik.gesut.dak.model.walidacja.BladWalidacji;

public class BledyWalidacjiTable
implements BladWeryfikacjiTable<BladWalidacji> {
    private static final Logger log = Logger.getLogger(BledyWalidacjiTable.class);
    private Connection connection;
    private Statement statement;

    public BledyWalidacjiTable(Connection conn, Statement stmt) {
        this.connection = conn;
        this.statement = stmt;
    }

    public boolean czySaBledyWalidacji(String nazwaPliku) throws BladSQLException {
        String selectQuery = "select rowid, * from blad_walidacji WHERE nazwa_pliku=? LIMIT 1";
        boolean czyBledyWalidacji = false;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(selectQuery);
            preparedStatement.setString(1, nazwaPliku);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                czyBledyWalidacji = true;
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas pobierania z  bazy danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas pobierania z bazy danych", e);
        }
        return czyBledyWalidacji;
    }

    public Long pobierzLiczbeDlaPliku(String nazwaPliku) throws BladSQLException {
        String selectQuery = "select COUNT(*) from blad_walidacji WHERE nazwa_pliku=? ";
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(selectQuery);
            preparedStatement.setString(1, nazwaPliku);
            ResultSet resultSet = preparedStatement.executeQuery();
            Long iloscBledow = null;
            if (resultSet.next()) {
                iloscBledow = resultSet.getLong(1);
            }
            resultSet.close();
            preparedStatement.close();
            return iloscBledow;
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas pobierania z  bazy danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas pobierania z bazy danych", e);
        }
    }

    public ResultSetIterator<BladWalidacji> pobierzDlaPliku(String nazwaPliku, boolean max100) throws BladSQLException {
        String selectQuery = "select rowid, * from blad_walidacji WHERE nazwa_pliku=? ";
        if (max100) {
            selectQuery = selectQuery + " LIMIT 100";
        }
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(selectQuery);
            preparedStatement.setString(1, nazwaPliku);
            ResultSet resultSet = preparedStatement.executeQuery();
            return new ResultSetIterator<BladWalidacji>(resultSet){

                @Override
                protected BladWalidacji konwertujNaObiekt() {
                    try {
                        return BladWalidacji.builder().rowId(this.resultSet.getString("rowid")).nazwaPliku(this.resultSet.getString("nazwa_pliku")).linia(this.resultSet.getInt("linia")).typ(this.resultSet.getString("typ")).komunikat(this.resultSet.getString("komunikat")).build();
                    }
                    catch (SQLException e) {
                        ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
                        return null;
                    }
                }
            };
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas pobierania z  bazy danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas pobierania z bazy danych", e);
        }
    }

    @Override
    public List<BladWalidacji> findAll() throws BladSQLException {
        try {
            String selectQuery = "select rowid, * from blad_walidacji";
            ResultSet resultSet = this.statement.executeQuery(selectQuery);
            return BledyWalidacjiTable.parseResult(resultSet);
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas pobierania z  bazy danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas pobierania z bazy danych", e);
        }
    }

    @Override
    public void save(BladWalidacji blad) throws BladSQLException {
        if (blad == null) {
            return;
        }
        try {
            PreparedStatement statement = this.przygotujStatement();
            this.setValues(statement, blad);
            statement.executeBatch();
            this.connection.commit();
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas zapisu w bazie danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas zapisu w bazie danych", e);
        }
    }

    @Override
    public void save(List<BladWalidacji> bledy) throws BladSQLException {
        try {
            PreparedStatement preparedStatement = this.przygotujStatement();
            for (BladWalidacji bladwalidacji : bledy) {
                this.setValues(preparedStatement, bladwalidacji);
            }
            preparedStatement.executeBatch();
            this.connection.commit();
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas zapisu w bazie danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas zapisu w bazie danych", e);
        }
    }

    private PreparedStatement przygotujStatement() throws SQLException {
        String insertQuery = "insert into blad_walidacji ( " + BladWalidacjiTableHelper.getColumnsWithoutRowId().stream().collect(Collectors.joining(", ")) + ") VALUES (" + BladWalidacjiTableHelper.getColumnsWithoutRowId().stream().map(c -> "?").collect(Collectors.joining(", ")) + ")";
        return this.connection.prepareStatement(insertQuery);
    }

    private static List<BladWalidacji> parseResult(ResultSet resultSet) throws SQLException {
        ArrayList<BladWalidacji> bledy = new ArrayList<BladWalidacji>();
        while (resultSet.next()) {
            BladWalidacji blad = BladWalidacji.builder().rowId(resultSet.getString("rowid")).nazwaPliku(resultSet.getString("nazwa_pliku")).linia(resultSet.getInt("linia")).typ(resultSet.getString("typ")).komunikat(resultSet.getString("komunikat")).build();
            bledy.add(blad);
        }
        return bledy;
    }

    private void setValues(PreparedStatement preparedStatement, BladWalidacji blad) throws SQLException {
        preparedStatement.setString(this.getIdx("nazwa_pliku"), blad.getNazwaPliku());
        preparedStatement.setInt(this.getIdx("linia"), blad.getLinia());
        preparedStatement.setString(this.getIdx("typ"), blad.getTyp());
        preparedStatement.setString(this.getIdx("komunikat"), blad.getKomunikat());
        preparedStatement.addBatch();
    }

    private int getIdx(String columnName) {
        return BladWalidacjiTableHelper.getColumnsWithoutRowId().indexOf(columnName) + 1;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public Statement getStatement() {
        return this.statement;
    }
}

