/*
 * Decompiled with CFR 0.152.
 */
package org.joox;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXB;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.joox.Content;
import org.joox.Each;
import org.joox.FastFilter;
import org.joox.Filter;
import org.joox.JOOX;
import org.joox.Mapper;
import org.joox.Match;
import org.joox.Util;
import org.joox.selector.CSS2XPath;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Impl
implements Match {
    private final Document document;
    private final List<Element> elements;
    private final Impl previousMatch;
    private final Map<String, String> namespaces;
    public static final Pattern SIMPLE_SELECTOR = Pattern.compile("[\\w\\-]+");

    Impl(Document document, Map<String, String> namespaces) {
        this(document, namespaces, null);
    }

    Impl(Document document, Map<String, String> namespaces, Impl previousMatch) {
        this.document = document;
        this.elements = new ArrayList<Element>();
        this.previousMatch = previousMatch;
        this.namespaces = namespaces == null ? new HashMap<String, String>() : new HashMap<String, String>(namespaces);
    }

    final Impl addNodeLists(List<NodeList> lists) {
        for (NodeList list : lists) {
            this.addNodeList(list);
        }
        return this;
    }

    final Impl addNodeList(NodeList list) {
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            this.elements.add((Element)list.item(i));
        }
        return this;
    }

    final Impl addUniqueElements(Element ... e) {
        return this.addUniqueElements(Arrays.asList(e));
    }

    final Impl addUniqueElements(List<Element> e) {
        int size = e.size();
        if (size == 1) {
            Element element = e.get(0);
            this.elements.remove(element);
            this.elements.add(element);
        } else if (size > 1) {
            LinkedHashSet<Element> set = new LinkedHashSet<Element>(e);
            this.elements.removeAll(set);
            this.elements.addAll(set);
        }
        return this;
    }

    final Impl addElements(Element ... e) {
        this.elements.addAll(Arrays.asList(e));
        return this;
    }

    final Impl addElements(Collection<Element> e) {
        this.elements.addAll(e);
        return this;
    }

    @Override
    public final Iterator<Element> iterator() {
        return this.elements.iterator();
    }

    @Override
    public final Match namespace(String namespacePrefix, String namespaceURI) {
        return this.namespaces(Collections.singletonMap(namespacePrefix, namespaceURI));
    }

    @Override
    public final Match namespaces(Map<String, String> map) {
        Impl result = this.copy();
        result.namespaces.putAll(map);
        return result;
    }

    @Override
    public final String namespaceURI() {
        return this.namespaceURI(0);
    }

    @Override
    public final String namespaceURI(int index) {
        Element element = this.get(index);
        if (element != null) {
            return element.getNamespaceURI();
        }
        return null;
    }

    @Override
    public final List<String> namespaceURIs() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.elements.size(); ++i) {
            result.add(this.namespaceURI(i));
        }
        return result;
    }

    @Override
    public final List<String> namespaceURIs(int ... indexes) {
        ArrayList<String> result = new ArrayList<String>();
        for (int index : indexes) {
            result.add(this.namespaceURI(index));
        }
        return result;
    }

    @Override
    public final String namespacePrefix() {
        return this.namespacePrefix(0);
    }

    @Override
    public final String namespacePrefix(int index) {
        Element element = this.get(index);
        if (element != null) {
            return Util.getNamespace(element.getTagName());
        }
        return null;
    }

    @Override
    public final List<String> namespacePrefixes() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.elements.size(); ++i) {
            result.add(this.namespacePrefix(i));
        }
        return result;
    }

    @Override
    public final List<String> namespacePrefixes(int ... indexes) {
        ArrayList<String> result = new ArrayList<String>();
        for (int index : indexes) {
            result.add(this.namespacePrefix(index));
        }
        return result;
    }

    @Override
    public final Document document() {
        return this.document;
    }

    @Override
    public final Element get(int index) {
        int size = this.elements.size();
        if (index >= 0) {
            if (index < size) {
                return this.elements.get(index);
            }
            return null;
        }
        int calculated = size + index;
        if (calculated >= 0 && calculated < size) {
            return this.elements.get(calculated);
        }
        return null;
    }

    @Override
    public final List<Element> get(int ... indexes) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i : indexes) {
            result.add(this.get(i));
        }
        return result;
    }

    @Override
    public final List<Element> get() {
        return this.elements;
    }

    @Override
    public final int size() {
        return this.elements.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    public final Impl add(Element ... e) {
        Impl x = this.copy();
        x.addUniqueElements(e);
        return x;
    }

    @Override
    public final Impl add(Match ... e) {
        Impl x = this.copy();
        for (Match element : e) {
            x.addUniqueElements(element.get());
        }
        return x;
    }

    @Override
    public final Impl reverse() {
        ArrayList<Element> reversed = new ArrayList<Element>(this.elements);
        Collections.reverse(reversed);
        return new Impl(this.document, this.namespaces).addElements(reversed);
    }

    @Override
    public final Impl andSelf() {
        if (this.previousMatch != null) {
            this.addUniqueElements(this.previousMatch.get());
        }
        return this;
    }

    @Override
    public final Impl child() {
        return this.child(0);
    }

    @Override
    public final Impl child(String selector) {
        return this.child(JOOX.selector(selector));
    }

    @Override
    public final Impl child(Filter filter) {
        return this.children(filter).eq(0);
    }

    @Override
    public final Impl child(int index) {
        return this.children(JOOX.at(index));
    }

    @Override
    public final Impl children() {
        return this.children(JOOX.all());
    }

    @Override
    public final Impl children(int ... indexes) {
        return this.children(JOOX.at(indexes));
    }

    @Override
    public final Impl children(String selector) {
        return this.children(JOOX.selector(selector));
    }

    @Override
    public final Impl children(Filter filter) {
        int size = this.size();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            List<Element> list = JOOX.list(match.getChildNodes());
            int elementSize = list.size();
            for (int elementIndex = 0; elementIndex < elementSize; ++elementIndex) {
                Element e = list.get(elementIndex);
                if (!filter.filter(Util.context(match, matchIndex, size, e, elementIndex, elementSize))) continue;
                result.add(e);
            }
        }
        return new Impl(this.document, this.namespaces, this).addUniqueElements(result);
    }

    @Override
    public final List<Match> each() {
        ArrayList<Match> result = new ArrayList<Match>();
        for (Element element : this.elements) {
            result.add(new Impl(this.document, this.namespaces).addElements(element));
        }
        return result;
    }

    @Override
    public final Impl each(Each each) {
        int size = this.size();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            each.each(Util.context(this.get(matchIndex), matchIndex, size));
        }
        return this;
    }

    @Override
    public final Impl each(Each ... each) {
        return this.each(JOOX.chain(each));
    }

    @Override
    public final Impl each(Iterable<? extends Each> each) {
        return this.each(JOOX.chain(each));
    }

    @Override
    public final Impl filter(String selector) {
        return this.filter(JOOX.selector(selector));
    }

    @Override
    public final Impl filter(Filter filter) {
        int size = this.size();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            if (!filter.filter(Util.context(match, matchIndex, size))) continue;
            result.add(match);
        }
        return new Impl(this.document, this.namespaces).addElements(result);
    }

    @Override
    public final Impl eq(int ... indexes) {
        Impl result = new Impl(this.document, this.namespaces);
        for (Element e : this.get(indexes)) {
            if (e == null) continue;
            result.addElements(e);
        }
        return result;
    }

    @Override
    public final Impl find() {
        return this.find(JOOX.all());
    }

    @Override
    public final Impl find(String selector) {
        if ("*".equals(selector)) {
            ArrayList<NodeList> result = new ArrayList<NodeList>();
            for (Element element : this.elements) {
                result.add(element.getElementsByTagName(selector));
            }
            return new Impl(this.document, this.namespaces, this).addNodeLists(result);
        }
        if (SIMPLE_SELECTOR.matcher(selector).matches()) {
            return this.find(JOOX.tag(selector, true));
        }
        return new Impl(this.document, this.namespaces, this).addElements(this.xpath(CSS2XPath.css2xpath(selector, this.isRoot())).get());
    }

    private boolean isRoot() {
        for (Element element : this.elements) {
            if (element.getParentNode().getNodeType() != 9) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Impl find(Filter filter) {
        ArrayList<Element> result = new ArrayList<Element>();
        int size = this.size();
        boolean fast = this.isFast(filter);
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element e;
            Element match = this.get(matchIndex);
            NodeList nodes = match.getElementsByTagName("*");
            int elementSize = fast ? -1 : nodes.getLength();
            int elementIndex = 0;
            while ((e = (Element)nodes.item(elementIndex)) != null) {
                if (filter.filter(Util.context(match, matchIndex, size, e, elementIndex, elementSize))) {
                    result.add(e);
                }
                ++elementIndex;
            }
        }
        return new Impl(this.document, this.namespaces, this).addUniqueElements(result);
    }

    @Override
    public final Impl xpath(String expression) {
        return this.xpath(expression, new Object[0]);
    }

    @Override
    public final Impl xpath(String expression, Object ... variables) {
        ArrayList<Element> result = new ArrayList<Element>();
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            Util.xalanExtensionAware(xpath);
            if (variables != null && variables.length != 0) {
                xpath.setXPathVariableResolver(new VariableResolver(expression, variables));
            }
            if (!this.namespaces.isEmpty() || expression.contains(":")) {
                xpath.setNamespaceContext(new ChainedContext(xpath.getNamespaceContext()));
            }
            XPathExpression exp = xpath.compile(expression);
            for (Element element : this.get()) {
                for (Element match : JOOX.iterable((NodeList)exp.evaluate(element, XPathConstants.NODESET))) {
                    result.add(match);
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return new Impl(this.document, this.namespaces).addUniqueElements(result);
    }

    @Override
    public final Impl first() {
        if (this.size() > 0) {
            return new Impl(this.document, this.namespaces).addElements(this.get(0));
        }
        return new Impl(this.document, this.namespaces);
    }

    @Override
    public final Impl has(String selector) {
        return this.has(JOOX.selector(selector));
    }

    @Override
    public final Impl has(Filter filter) {
        ArrayList<Element> result = new ArrayList<Element>();
        int size = this.size();
        boolean fast = this.isFast(filter);
        block0: for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element e;
            Element match = this.get(matchIndex);
            NodeList nodes = match.getElementsByTagName("*");
            int elementSize = fast ? -1 : nodes.getLength();
            int elementIndex = 0;
            while ((e = (Element)nodes.item(elementIndex)) != null) {
                if (filter.filter(Util.context(match, matchIndex, size, e, elementIndex, elementSize))) {
                    result.add(match);
                    continue block0;
                }
                ++elementIndex;
            }
        }
        return new Impl(this.document, this.namespaces).addElements(result);
    }

    @Override
    public final boolean is(String selector) {
        return this.is(JOOX.selector(selector));
    }

    @Override
    public final boolean is(Filter filter) {
        int size = this.size();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            if (!filter.filter(Util.context(match, matchIndex, size))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Impl last() {
        int size = this.size();
        if (size > 0) {
            return new Impl(this.document, this.namespaces).addElements(this.get(size - 1));
        }
        return new Impl(this.document, this.namespaces);
    }

    @Override
    public final <E> List<E> map(Mapper<E> map) {
        int size = this.size();
        ArrayList<E> result = new ArrayList<E>();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            result.add(map.map(Util.context(this.get(matchIndex), matchIndex, size)));
        }
        return result;
    }

    @Override
    public final Impl next() {
        return this.next(JOOX.all());
    }

    @Override
    public final Impl next(String selector) {
        return this.next(JOOX.selector(selector));
    }

    @Override
    public final Impl next(Filter filter) {
        return this.next(false, JOOX.none(), filter);
    }

    @Override
    public final Impl nextAll() {
        return this.nextAll(JOOX.all());
    }

    @Override
    public final Impl nextAll(String selector) {
        return this.nextAll(JOOX.selector(selector));
    }

    @Override
    public final Impl nextAll(Filter filter) {
        return this.next(true, JOOX.none(), filter);
    }

    @Override
    public final Impl nextUntil(String until) {
        return this.nextUntil(JOOX.selector(until));
    }

    @Override
    public final Impl nextUntil(Filter until) {
        return this.nextUntil(until, (Filter)JOOX.all());
    }

    @Override
    public final Impl nextUntil(String until, String selector) {
        return this.nextUntil(JOOX.selector(until), JOOX.selector(selector));
    }

    @Override
    public final Impl nextUntil(String until, Filter filter) {
        return this.nextUntil(JOOX.selector(until), filter);
    }

    @Override
    public final Impl nextUntil(Filter until, String selector) {
        return this.nextUntil(until, JOOX.selector(selector));
    }

    @Override
    public final Impl nextUntil(Filter until, Filter filter) {
        return this.next(true, until, filter);
    }

    private final Impl next(boolean all, Filter until, Filter filter) {
        int size = this.size();
        ArrayList<Element> result = new ArrayList<Element>();
        block0: for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            Node node = match;
            int elementIndex = 1;
            while ((node = node.getNextSibling()) != null) {
                if (node.getNodeType() != 1) continue;
                Element e = (Element)node;
                if (until.filter(Util.context(match, matchIndex, size, e, elementIndex, -1))) continue block0;
                if (filter.filter(Util.context(match, matchIndex, size, e, elementIndex++, -1))) {
                    result.add(e);
                }
                if (all) continue;
                continue block0;
            }
        }
        return new Impl(this.document, this.namespaces, this).addUniqueElements(result);
    }

    @Override
    public final Impl not(String selector) {
        return this.not(JOOX.selector(selector));
    }

    @Override
    public final Impl not(Filter filter) {
        return this.filter(JOOX.not(filter));
    }

    @Override
    public final Impl parent() {
        return this.parent(JOOX.all());
    }

    @Override
    public final Impl parent(String selector) {
        return this.parent(JOOX.selector(selector));
    }

    @Override
    public final Impl parent(Filter filter) {
        return this.parents(false, JOOX.none(), filter);
    }

    @Override
    public final Impl parents() {
        return this.parents(JOOX.all());
    }

    @Override
    public final Impl parents(String selector) {
        return this.parents(JOOX.selector(selector));
    }

    @Override
    public final Impl parents(Filter filter) {
        return this.parents(true, JOOX.none(), filter);
    }

    @Override
    public final Impl parentsUntil(String until) {
        return this.parentsUntil(JOOX.selector(until), (Filter)JOOX.all());
    }

    @Override
    public final Impl parentsUntil(Filter until) {
        return this.parentsUntil(until, (Filter)JOOX.all());
    }

    @Override
    public final Impl parentsUntil(String until, String selector) {
        return this.parentsUntil(JOOX.selector(until), JOOX.selector(selector));
    }

    @Override
    public final Impl parentsUntil(String until, Filter filter) {
        return this.parentsUntil(JOOX.selector(until), filter);
    }

    @Override
    public final Impl parentsUntil(Filter until, String selector) {
        return this.parentsUntil(until, JOOX.selector(selector));
    }

    @Override
    public final Impl parentsUntil(Filter until, Filter filter) {
        return this.parents(true, until, filter);
    }

    private final Impl parents(boolean all, Filter until, Filter filter) {
        int size = this.size();
        ArrayList<Element> result = new ArrayList<Element>();
        block0: for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            Node node = match;
            int elementIndex = 1;
            while ((node = node.getParentNode()) != null) {
                if (node.getNodeType() != 1) continue;
                Element e = (Element)node;
                if (until.filter(Util.context(match, matchIndex, size, e, elementIndex, -1))) continue block0;
                if (filter.filter(Util.context(match, matchIndex, size, e, elementIndex++, -1))) {
                    result.add(e);
                }
                if (all) continue;
                continue block0;
            }
        }
        return new Impl(this.document, this.namespaces, this).addUniqueElements(result);
    }

    @Override
    public final Impl prev() {
        return this.prev(JOOX.all());
    }

    @Override
    public final Impl prev(String selector) {
        return this.prev(JOOX.selector(selector));
    }

    @Override
    public final Impl prev(Filter filter) {
        return this.prev(false, JOOX.none(), filter);
    }

    @Override
    public final Impl prevAll() {
        return this.prevAll(JOOX.all());
    }

    @Override
    public final Impl prevAll(String selector) {
        return this.prevAll(JOOX.selector(selector));
    }

    @Override
    public final Impl prevAll(Filter filter) {
        return this.prev(true, JOOX.none(), filter);
    }

    @Override
    public final Impl prevUntil(String until) {
        return this.prevUntil(JOOX.selector(until));
    }

    @Override
    public final Impl prevUntil(Filter until) {
        return this.prevUntil(until, (Filter)JOOX.all());
    }

    @Override
    public final Impl prevUntil(String until, String selector) {
        return this.prevUntil(JOOX.selector(until), JOOX.selector(selector));
    }

    @Override
    public final Impl prevUntil(String until, Filter filter) {
        return this.prevUntil(JOOX.selector(until), filter);
    }

    @Override
    public final Impl prevUntil(Filter until, String selector) {
        return this.prevUntil(until, JOOX.selector(selector));
    }

    @Override
    public final Impl prevUntil(Filter until, Filter filter) {
        return this.prev(true, until, filter);
    }

    private final Impl prev(boolean all, Filter until, Filter filter) {
        int size = this.size();
        ArrayList<Element> result = new ArrayList<Element>();
        block0: for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            Node node = match;
            int elementIndex = 1;
            while ((node = node.getPreviousSibling()) != null) {
                if (node.getNodeType() != 1) continue;
                Element e = (Element)node;
                if (until.filter(Util.context(match, matchIndex, size, e, elementIndex, -1))) continue block0;
                if (filter.filter(Util.context(match, matchIndex, size, e, elementIndex++, -1))) {
                    result.add(e);
                }
                if (all) continue;
                continue block0;
            }
        }
        Collections.reverse(result);
        return new Impl(this.document, this.namespaces, this).addUniqueElements(result);
    }

    @Override
    public final Impl siblings() {
        return this.siblings(JOOX.all());
    }

    @Override
    public final Impl siblings(String selector) {
        return this.siblings(JOOX.selector(selector));
    }

    @Override
    public final Impl siblings(Filter filter) {
        return this.prevAll(filter).add(this.nextAll(filter));
    }

    @Override
    public final Impl slice(int start) {
        return this.slice(start, Integer.MAX_VALUE);
    }

    @Override
    public final Impl slice(int start, int end) {
        int size = this.size();
        if (start < 0) {
            start = size + start;
        }
        if (end < 0) {
            end = size + end;
        }
        if ((start = Math.max(0, start)) > (end = Math.min(size, end))) {
            return new Impl(this.document, this.namespaces);
        }
        if (start == 0 && end == size) {
            return this;
        }
        return new Impl(this.document, this.namespaces).addElements(this.elements.subList(start, end));
    }

    @Override
    public final Impl matchText(String regex) {
        return this.matchText(regex, true);
    }

    @Override
    public final Impl matchText(String regex, boolean keepMatches) {
        if (keepMatches) {
            return this.filter(JOOX.matchText(regex));
        }
        return this.not(JOOX.matchText(regex));
    }

    @Override
    public final Impl matchTag(String regex) {
        return this.matchTag(regex, true);
    }

    @Override
    public final Impl matchTag(String regex, boolean keepMatches) {
        if (keepMatches) {
            return this.filter(JOOX.matchTag(regex));
        }
        return this.not(JOOX.matchTag(regex));
    }

    @Override
    public final Match matchAttr(String name, String valueRegex) {
        return this.matchAttr(name, valueRegex, true);
    }

    @Override
    public final Match matchAttr(String name, String valueRegex, boolean keepMatches) {
        if (keepMatches) {
            return this.filter(JOOX.matchAttr(name, valueRegex));
        }
        return this.not(JOOX.matchAttr(name, valueRegex));
    }

    @Override
    public final Impl leaf() {
        return this.filter(JOOX.leaf());
    }

    @Override
    public final Impl after(String content) {
        return this.after(JOOX.content(content));
    }

    @Override
    public final Impl after(Content content) {
        int size = this.size();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            result.add(match);
            Document doc = match.getOwnerDocument();
            String text = Util.nonNull(content.content(Util.context(match, matchIndex, size)));
            DocumentFragment imported = Util.createContent(doc, text);
            Node parent = match.getParentNode();
            Node next = match.getNextSibling();
            if (imported != null) {
                result.addAll(JOOX.list(imported.getChildNodes()));
                parent.insertBefore(imported, next);
                continue;
            }
            parent.insertBefore(doc.createTextNode(text), next);
        }
        this.elements.clear();
        this.elements.addAll(result);
        return this;
    }

    @Override
    public final Impl after(Match ... content) {
        return this.after(Util.elements(content));
    }

    @Override
    public final Impl after(Element ... content) {
        int size = this.size();
        ArrayList<Element> result = new ArrayList<Element>();
        List<Element> detached = Util.importOrDetach(this.document, content);
        for (int i = 0; i < size; ++i) {
            Element element = this.get(i);
            result.add(element);
            Node parent = element.getParentNode();
            Node next = element.getNextSibling();
            for (Element e : detached) {
                if (i == 0) {
                    result.add((Element)parent.insertBefore(e, next));
                    continue;
                }
                result.add((Element)parent.insertBefore(e.cloneNode(true), next));
            }
        }
        this.elements.clear();
        this.elements.addAll(result);
        return this;
    }

    @Override
    public final Impl before(String content) {
        return this.before(JOOX.content(content));
    }

    @Override
    public final Impl before(Content content) {
        int size = this.size();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            Document doc = match.getOwnerDocument();
            String text = Util.nonNull(content.content(Util.context(match, matchIndex, size)));
            DocumentFragment imported = Util.createContent(doc, text);
            Node parent = match.getParentNode();
            if (imported != null) {
                result.addAll(JOOX.list(imported.getChildNodes()));
                parent.insertBefore(imported, match);
            } else {
                parent.insertBefore(doc.createTextNode(text), match);
            }
            result.add(match);
        }
        this.elements.clear();
        this.elements.addAll(result);
        return this;
    }

    @Override
    public final Impl before(Match ... content) {
        return this.before(Util.elements(content));
    }

    @Override
    public final Impl before(Element ... content) {
        int size = this.size();
        ArrayList<Element> result = new ArrayList<Element>();
        List<Element> detached = Util.importOrDetach(this.document, content);
        for (int i = 0; i < size; ++i) {
            Element element = this.get(i);
            Node parent = element.getParentNode();
            for (Element e : detached) {
                if (i == 0) {
                    result.add((Element)parent.insertBefore(e, element));
                    continue;
                }
                result.add((Element)parent.insertBefore(e.cloneNode(true), element));
            }
            result.add(element);
        }
        this.elements.clear();
        this.elements.addAll(result);
        return this;
    }

    @Override
    public final Impl append(String content) {
        return this.append(JOOX.content(content));
    }

    @Override
    public final Impl append(Content content) {
        int size = this.size();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            String text;
            Element match = this.get(matchIndex);
            Document doc = match.getOwnerDocument();
            DocumentFragment imported = Util.createContent(doc, text = Util.nonNull(content.content(Util.context(match, matchIndex, size))));
            if (imported != null) {
                match.appendChild(imported);
                continue;
            }
            match.appendChild(doc.createTextNode(text));
        }
        return this;
    }

    @Override
    public final Impl append(Match ... content) {
        return this.append(Util.elements(content));
    }

    @Override
    public final Impl append(Element ... content) {
        int size = this.size();
        List<Element> detached = Util.importOrDetach(this.document, content);
        for (int i = 0; i < size; ++i) {
            for (Element e : detached) {
                if (i == 0) {
                    this.get(i).appendChild(e);
                    continue;
                }
                this.get(i).appendChild(e.cloneNode(true));
            }
        }
        return this;
    }

    @Override
    public final Impl prepend(String content) {
        return this.prepend(JOOX.content(content));
    }

    @Override
    public final Impl prepend(Content content) {
        int size = this.size();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            Document doc = match.getOwnerDocument();
            String text = Util.nonNull(content.content(Util.context(match, matchIndex, size)));
            DocumentFragment imported = Util.createContent(doc, text);
            Node first = match.getFirstChild();
            if (imported != null) {
                match.insertBefore(imported, first);
                continue;
            }
            match.insertBefore(doc.createTextNode(text), first);
        }
        return this;
    }

    @Override
    public final Impl prepend(Match ... content) {
        return this.prepend(Util.elements(content));
    }

    @Override
    public final Impl prepend(Element ... content) {
        int size = this.size();
        List<Element> detached = Util.importOrDetach(this.document, content);
        for (int i = 0; i < size; ++i) {
            for (Element e : detached) {
                Element element = this.get(i);
                Node first = element.getFirstChild();
                if (i == 0) {
                    element.insertBefore(e, first);
                    continue;
                }
                element.insertBefore(e.cloneNode(true), first);
            }
        }
        return this;
    }

    @Override
    public final String attr(String name) {
        if (this.size() > 0) {
            return Util.attr(this.get(0), name);
        }
        return null;
    }

    @Override
    public final <T> T attr(String name, Class<T> type) {
        return JOOX.convert(this.attr(name), type);
    }

    @Override
    public final List<String> attrs(String name) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : this.elements) {
            result.add(Util.attr(element, name));
        }
        return result;
    }

    @Override
    public final <T> List<T> attrs(String name, Class<T> type) {
        return JOOX.convert(this.attrs(name), type);
    }

    @Override
    public final Impl attr(String name, String value) {
        return this.attr(name, JOOX.content(value));
    }

    @Override
    public final Impl attr(String name, Content content) {
        int size = this.size();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            String value = content.content(Util.context(match, matchIndex, size));
            if (value == null) {
                match.removeAttribute(name);
                continue;
            }
            match.setAttribute(name, value);
        }
        return this;
    }

    @Override
    public final Impl removeAttr(String name) {
        return this.attr(name, (String)null);
    }

    @Override
    public final String content() {
        return this.content(0);
    }

    @Override
    public final String content(int index) {
        return this.content(this.get(index));
    }

    @Override
    public final List<String> contents() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : this.elements) {
            result.add(this.content(element));
        }
        return result;
    }

    @Override
    public final List<String> contents(int ... indexes) {
        ArrayList<String> result = new ArrayList<String>();
        for (int index : indexes) {
            result.add(this.content(index));
        }
        return result;
    }

    private final String content(Element element) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        if (children.getLength() == 0) {
            return "";
        }
        if (Util.textNodesOnly(children)) {
            return element.getTextContent();
        }
        String name = element.getTagName();
        return Util.toString(element).replaceAll("(?s)^<" + name + "(?:[^>]*)>(.*)</" + name + ">$", "$1");
    }

    @Override
    public final Impl content(String content) {
        return this.content(JOOX.content(content));
    }

    @Override
    public final Impl content(Object content) {
        return this.content(JOOX.content(content));
    }

    @Override
    public final Impl content(Content content) {
        int size = this.size();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            String text = content.content(Util.context(match, matchIndex, size));
            DocumentFragment imported = Util.createContent(match.getOwnerDocument(), text);
            if (imported != null) {
                match.setTextContent("");
                match.appendChild(imported);
                continue;
            }
            match.setTextContent(text);
        }
        return this;
    }

    @Override
    public final String text() {
        return this.text(0);
    }

    @Override
    public final String text(int index) {
        Element element = this.get(index);
        if (element != null) {
            return element.getTextContent();
        }
        return null;
    }

    @Override
    public final <T> T text(Class<T> type) {
        return JOOX.convert(this.text(), type);
    }

    @Override
    public final List<String> texts() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : this.elements) {
            result.add(element.getTextContent());
        }
        return result;
    }

    @Override
    public final List<String> texts(int ... indexes) {
        ArrayList<String> result = new ArrayList<String>();
        for (int index : indexes) {
            result.add(this.text(index));
        }
        return result;
    }

    @Override
    public final <T> List<T> texts(Class<T> type) {
        return JOOX.convert(this.texts(), type);
    }

    @Override
    public final Impl text(String content) {
        return this.text(JOOX.content(content));
    }

    @Override
    public final Impl text(Content content) {
        int size = this.size();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            String text = content.content(Util.context(match, matchIndex, size));
            match.setTextContent(text);
        }
        return this;
    }

    @Override
    public final String cdata() {
        return this.text();
    }

    @Override
    public final String cdata(int index) {
        return this.text(index);
    }

    @Override
    public final <T> T cdata(Class<T> type) {
        return this.text(type);
    }

    @Override
    public final List<String> cdatas() {
        return this.texts();
    }

    @Override
    public final List<String> cdatas(int ... indexes) {
        return this.texts(indexes);
    }

    @Override
    public final <T> List<T> cdatas(Class<T> type) {
        return this.texts(type);
    }

    @Override
    public final Impl cdata(String content) {
        return this.cdata(JOOX.content(content));
    }

    @Override
    public final Impl cdata(Content content) {
        int size = this.size();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            String text = content.content(Util.context(match, matchIndex, size));
            this.empty(match);
            match.appendChild(match.getOwnerDocument().createCDATASection(text));
        }
        return this;
    }

    @Override
    public final Match empty() {
        for (Element element : this.elements) {
            this.empty(element);
        }
        return this;
    }

    @Override
    public final Impl remove() {
        return this.remove(JOOX.all());
    }

    @Override
    public final Impl remove(String selector) {
        return this.remove(JOOX.selector(selector));
    }

    @Override
    public final Impl remove(Filter filter) {
        int size = this.size();
        ArrayList<Element> remove = new ArrayList<Element>();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            if (!filter.filter(Util.context(match, matchIndex, size))) continue;
            remove.add(match);
        }
        for (Element element : remove) {
            this.remove(element);
        }
        return this;
    }

    private final void remove(Element element) {
        element.getParentNode().removeChild(element);
        this.elements.remove(element);
    }

    private final void empty(Element element) {
        Node child;
        while ((child = element.getFirstChild()) != null) {
            element.removeChild(child);
        }
    }

    @Override
    public final Impl wrap(String content) {
        return this.wrap(JOOX.content(content));
    }

    @Override
    public final Impl wrap(Content content) {
        int size = this.size();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            Node parent = match.getParentNode();
            Document doc = match.getOwnerDocument();
            String text = Util.nonNull(content.content(Util.context(match, matchIndex, size)));
            Element wrapper = doc.createElement(text);
            parent.replaceChild(wrapper, match);
            wrapper.appendChild(match);
        }
        return this;
    }

    @Override
    public final Impl unwrap() {
        int size = this.size();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            Node wrapper = match.getParentNode();
            Node parent = wrapper.getParentNode();
            if (wrapper.getNodeType() == 9 || parent.getNodeType() == 9) {
                throw new RuntimeException("Cannot unwrap document element or direct children thereof");
            }
            parent.replaceChild(match, wrapper);
        }
        return this;
    }

    @Override
    public final Impl replaceWith(String content) {
        return this.replaceWith(JOOX.content(content));
    }

    @Override
    public final Impl replaceWith(Content content) {
        int size = this.size();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            Document doc = match.getOwnerDocument();
            String text = Util.nonNull(content.content(Util.context(match, matchIndex, size)));
            DocumentFragment imported = Util.createContent(doc, text);
            Node parent = match.getParentNode();
            if (imported != null) {
                result.addAll(JOOX.list(imported.getChildNodes()));
                parent.replaceChild(imported, match);
                continue;
            }
            parent.replaceChild(doc.createTextNode(text), match);
        }
        this.elements.clear();
        this.elements.addAll(result);
        return this;
    }

    @Override
    public final Impl replaceWith(Match ... content) {
        return this.replaceWith(Util.elements(content));
    }

    @Override
    public final Impl replaceWith(Element ... content) {
        int size = this.size();
        ArrayList<Element> result = new ArrayList<Element>();
        List<Element> detached = Util.importOrDetach(this.document, content);
        for (int i = 0; i < size; ++i) {
            Element element = this.get(i);
            Node parent = element.getParentNode();
            for (Element e : detached) {
                Element replacement = i == 0 ? e : (Element)e.cloneNode(true);
                parent.insertBefore(replacement, element);
                result.add(replacement);
            }
            parent.removeChild(element);
        }
        this.elements.clear();
        this.elements.addAll(result);
        return this;
    }

    @Override
    public final Match rename(String tag) {
        return this.rename(JOOX.content(tag));
    }

    @Override
    public final Match rename(Content tag) {
        int size = this.size();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int matchIndex = 0; matchIndex < size; ++matchIndex) {
            Element match = this.get(matchIndex);
            String text = Util.nonNull(tag.content(Util.context(match, matchIndex, size)));
            result.add((Element)this.document.renameNode(match, "", text));
        }
        this.elements.clear();
        this.elements.addAll(result);
        return this;
    }

    private final boolean isFast(Filter filter) {
        return filter instanceof FastFilter;
    }

    @Override
    public final Impl copy() {
        Impl copy = new Impl(this.document, this.namespaces, this.previousMatch);
        copy.elements.addAll(this.elements);
        return copy;
    }

    @Override
    public final String xpath() {
        return this.xpath(0);
    }

    @Override
    public final String xpath(int index) {
        Element element = this.get(index);
        if (element != null) {
            return Util.xpath(element);
        }
        return null;
    }

    @Override
    public final List<String> xpaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : this.elements) {
            result.add(Util.xpath(element));
        }
        return result;
    }

    @Override
    public final List<String> xpaths(int ... indexes) {
        ArrayList<String> result = new ArrayList<String>();
        for (int index : indexes) {
            result.add(this.xpath(index));
        }
        return result;
    }

    @Override
    public final String tag() {
        return this.tag(0);
    }

    @Override
    public final String tag(int index) {
        Element element = this.get(index);
        if (element != null) {
            return Util.stripNamespace(element.getTagName());
        }
        return null;
    }

    @Override
    public final List<String> tags() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : this.elements) {
            result.add(Util.stripNamespace(element.getTagName()));
        }
        return result;
    }

    @Override
    public final List<String> tags(int ... indexes) {
        ArrayList<String> result = new ArrayList<String>();
        for (int index : indexes) {
            result.add(this.tag(index));
        }
        return result;
    }

    @Override
    public final String id() {
        return this.id(0);
    }

    @Override
    public final String id(int index) {
        return this.eq(index).attr("id");
    }

    @Override
    public final <T> T id(Class<T> type) {
        return JOOX.convert(this.id(), type);
    }

    @Override
    public final List<String> ids() {
        return this.attrs("id");
    }

    @Override
    public final List<String> ids(int ... indexes) {
        ArrayList<String> result = new ArrayList<String>();
        for (int index : indexes) {
            result.add(this.id(index));
        }
        return result;
    }

    @Override
    public final <T> List<T> ids(Class<T> type) {
        return JOOX.convert(this.ids(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Match write(Writer writer) throws IOException {
        try {
            for (Element e : this) {
                writer.write(JOOX.$(e).toString());
            }
        }
        finally {
            writer.close();
        }
        return this;
    }

    @Override
    public final Match write(OutputStream stream) throws IOException {
        return this.write(new OutputStreamWriter(stream));
    }

    @Override
    public final Match write(File file) throws IOException {
        return this.write(new FileOutputStream(file));
    }

    @Override
    public final <T> List<T> unmarshal(Class<T> type) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Element element : this.elements) {
            result.add(JAXB.unmarshal((Source)new DOMSource(element), type));
        }
        return result;
    }

    @Override
    public final <T> List<T> unmarshal(Class<T> type, int ... indexes) {
        return this.eq(indexes).unmarshal(type);
    }

    @Override
    public final <T> T unmarshalOne(Class<T> type) {
        List<T> list = this.unmarshal(type);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public final <T> T unmarshalOne(Class<T> type, int index) {
        return this.eq(index).unmarshalOne(type);
    }

    @Override
    public final Impl transform(Transformer transformer) {
        Object result;
        ArrayList<DOMResult> results = new ArrayList<DOMResult>();
        ArrayList<Element> newElements = new ArrayList<Element>();
        try {
            for (Element element : this.get()) {
                result = new DOMResult();
                transformer.transform(new DOMSource(element), (Result)result);
                results.add((DOMResult)result);
            }
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < this.size(); ++i) {
            Element element;
            element = this.get(i);
            result = ((Document)((DOMResult)results.get(i)).getNode()).getDocumentElement();
            result = (Element)this.document().importNode((Node)result, true);
            element.getParentNode().replaceChild((Node)result, element);
            newElements.add((Element)result);
        }
        return new Impl(this.document, this.namespaces).addElements(newElements);
    }

    @Override
    public final Impl transform(Source transformer) {
        try {
            return this.transform(TransformerFactory.newInstance().newTransformer(transformer));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final Impl transform(InputStream transformer) {
        return this.transform(new StreamSource(transformer));
    }

    @Override
    public final Impl transform(Reader transformer) {
        return this.transform(new StreamSource(transformer));
    }

    @Override
    public final Impl transform(URL transformer) {
        try {
            return this.transform(transformer.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final Impl transform(File transformer) {
        return this.transform(new StreamSource(transformer));
    }

    @Override
    public final Impl transform(String transformer) {
        return this.transform(new StreamSource(new File(transformer)));
    }

    @Override
    public Match sort(Comparator<Element> comparator) {
        Impl result = new Impl(this.document, this.namespaces);
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements);
        Collections.sort(newElements, comparator);
        for (Element e : newElements) {
            if (e == null) continue;
            result.addElements(e);
        }
        return result;
    }

    public String toString() {
        if (this.elements.size() == 0) {
            return "[]";
        }
        if (this.elements.size() == 1) {
            return Util.toString(this.get(0));
        }
        StringBuilder sb = new StringBuilder();
        String separator = "";
        sb.append("[");
        for (Element element : this.elements) {
            sb.append(separator);
            sb.append(Util.toString(element));
            separator = ",\n";
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.document == null ? 0 : this.document.hashCode());
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Impl other = (Impl)obj;
        if (this.document == null ? other.document != null : !this.document.equals(other.document)) {
            return false;
        }
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }

    private class ChainedContext
    implements NamespaceContext {
        private final NamespaceContext chained;

        ChainedContext(NamespaceContext chained) {
            this.chained = chained;
        }

        public final Iterator getPrefixes(String namespaceURI) {
            return this.chained == null ? Collections.emptyList().iterator() : this.chained.getPrefixes(namespaceURI);
        }

        @Override
        public final String getPrefix(String namespaceURI) {
            return this.chained == null ? "" : this.chained.getPrefix(namespaceURI);
        }

        @Override
        public final String getNamespaceURI(String prefix) {
            String namespaceURI;
            String string = namespaceURI = this.chained == null ? "" : this.chained.getNamespaceURI(prefix);
            if ("".equals(namespaceURI) && Impl.this.namespaces.containsKey(prefix)) {
                namespaceURI = (String)Impl.this.namespaces.get(prefix);
            }
            return namespaceURI;
        }
    }

    private static class VariableResolver
    implements XPathVariableResolver {
        private final String expression;
        private final Object[] variables;

        VariableResolver(String expression, Object[] variables) {
            this.expression = expression;
            this.variables = variables;
        }

        @Override
        public final Object resolveVariable(QName variable) {
            int index;
            try {
                index = Integer.parseInt(variable.getLocalPart()) - 1;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Variable " + variable + " is not supported by jOOX. Only numerical variables can be used for " + this.expression);
            }
            if (index < this.variables.length) {
                return this.variables[index];
            }
            throw new IndexOutOfBoundsException("No variable defined for " + variable + " in " + this.expression);
        }
    }
}

