/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.ParametryKontroliService;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;
import pl.gov.gugik.gesut.dak.biz.service.pliki.PlikiTymczasoweService;
import pl.gov.gugik.gesut.dak.biz.utils.KomunikatyUtils;
import pl.gov.gugik.gesut.dak.kontrolery.BazowyController;
import pl.gov.gugik.gesut.dak.kontrolery.KontroleContoller;
import pl.gov.gugik.gesut.dak.model.PlikWynikowy;
import pl.gov.gugik.gesut.dak.model.kontrole.OgolneParametryKontroli;

public class Aplikacja
extends Application {
    private OgolneParametryKontroli parametryKontroli;
    private PlikWynikowy plikWynikowy = new PlikWynikowy();
    private BorderPane rootLayout;

    private static void obsluzWyjatek(Thread t, Throwable e) {
        ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
    }

    public void start(Stage primaryStage) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(Aplikacja::obsluzWyjatek);
        this.parametryKontroli = ParametryKontroliService.inicjujParametryKontroli();
        this.ustawWidokAplikacji(primaryStage);
        this.wyswietlAplikacje(primaryStage);
    }

    private void ustawWidokAplikacji(Stage primaryStage) throws IOException {
        FXMLLoader loader = new FXMLLoader();
        ResourceBundle resources = ResourceBundle.getBundle("bundles.dak", Locale.getDefault());
        loader.setResources(resources);
        loader.setLocation(Aplikacja.class.getResource("/fxml/kontrole.fxml"));
        this.rootLayout = (BorderPane)loader.load();
        this.konfigurujGlowneOkno(primaryStage);
        KontroleContoller kontroleContoller = (KontroleContoller)loader.getController();
        this.inicjujKontroler(kontroleContoller);
        kontroleContoller.setOkno((Window)primaryStage);
    }

    private void konfigurujGlowneOkno(Stage primaryStage) {
        primaryStage.getIcons().add((Object)new Image("img/sygnet.png"));
        primaryStage.setTitle("Desktopowa Aplikacja Kontrolna GESUT");
        primaryStage.setScene(new Scene((Parent)this.rootLayout));
        primaryStage.setMinWidth(1040.0);
        primaryStage.setMinHeight(720.0);
        primaryStage.setOnCloseRequest(event -> {
            event.consume();
            if (!this.parametryKontroli.isCzyKontrolaWTrakcie()) {
                PlikiTymczasoweService.pobierzInstancje().usunPlikiTymczasowe();
                primaryStage.close();
            } else {
                KomunikatyUtils.wyswietOknoInformacyjne("Weryfikacja w trakcie", "Weryfikacja w trakcie", "Nie mo\u017cna zamkn\u0105\u0107 aplikacji podczas procesu weryfikacji.");
            }
        });
    }

    private void wyswietlAplikacje(Stage primaryStage) {
        primaryStage.show();
    }

    private void inicjujKontroler(BazowyController kontroler) {
        kontroler.ustawAplikacje(this);
        kontroler.inicjujKontroler();
    }

    public void stop() throws Exception {
        System.exit(0);
    }

    public static void main(String[] args) {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        PlikiTymczasoweService.pobierzInstancje().utworzIZarejestrujKatalogTymczasowySQLite();
        Aplikacja.launch((String[])args);
    }

    public OgolneParametryKontroli getParametryKontroli() {
        return this.parametryKontroli;
    }

    public void setParametryKontroli(OgolneParametryKontroli parametryKontroli) {
        this.parametryKontroli = parametryKontroli;
    }

    public PlikWynikowy getPlikWynikowy() {
        return this.plikWynikowy;
    }

    public void setPlikWynikowy(PlikWynikowy plikWynikowy) {
        this.plikWynikowy = plikWynikowy;
    }
}

