/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.kontrole;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.concurrent.Task;
import pl.gov.gugik.gesut.dak.biz.conf.Konfiguracja;
import pl.gov.gugik.gesut.dak.biz.kontrole.WynikiKontroliHelper;
import pl.gov.gugik.gesut.dak.biz.kontrole.executory.KontrolaExecutor;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.BledyWeryfikacjiService;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.KontroleAtrybutoweService;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.WynikKontroliService;
import pl.gov.gugik.gesut.dak.biz.service.log.KontrolaLogService;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;
import pl.gov.gugik.gesut.dak.biz.service.raporty.RaportService;
import pl.gov.gugik.gesut.dak.biz.service.walidacja.WalidacjaService;
import pl.gov.gugik.gesut.dak.biz.utils.DateUtils;
import pl.gov.gugik.gesut.dak.biz.utils.KomunikatyUtils;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BladWalidatoraXsd;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BrakPlikuXsdException;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BrakZaleznegoPlikuXSD;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.PrzerwanieKontroliAtrybutowejException;
import pl.gov.gugik.gesut.dak.dao.wyjatki.BladSQLException;
import pl.gov.gugik.gesut.dak.model.PlikWynikowy;
import pl.gov.gugik.gesut.dak.model.kontrole.OgolneParametryKontroli;
import pl.gov.gugik.gesut.dak.model.kontrole.OgolnePodsumowanieKontroli;
import pl.gov.gugik.gesut.dak.model.kontrole.ParametryKontroliPliku;
import pl.gov.gugik.gesut.dak.model.raporty.Wynik;

public class KontrolaTask<Void>
extends Task<Void> {
    private static final String BUNDLE_ZAKONCZONO_PLIK = "kontrola.zakonczonoPlik";
    private static final String BUNDLE_CZAS_WERYFIKACJI_PLIKU = "kontrola.czasWeryfikacjiPliku";
    private static final String BUNDLE_PRZERWANO_PROCES_WERYFIKACJI = "kontrola.przerwanoProcesWeryfikacji";
    private static final String BUNDLE_ZAKONCZONO_PROCES_WERYFIKACJI = "kontrola.zakonczonoProcesWeryfikacji";
    private static final String BUNDLE_WERSJA_APLIKACJI = "kontrola.log.wersjaAplikacji";
    private static final String BUNDLE_SCIEZKA_SZABLONU_KONTROLI = "kontrola.log.sciezkaSzablonuKontroli";
    private static final String BUNDLE_SCIEZKA_SCHEMATU_APLIKACYJNEGO = "kontrola.log.sciezkaDoSchematuAplikacyjnego";
    private static final String BUNDLE_LISTA_KONTROLOWANYCH_PLIKOW = "kontrola.log.listaKontrolowanychPlikow";
    private static final String BUNDLE_ROZPOCZETO_GENEROWANIE_RAPORTU_DLA_PLIKU = "kontrola.log.rozpoczetoGenerowanieRaportuDlaPliku";
    private static final String BUNDLE_ZAKONCZONO_GENEROWANIE_RAPORTU_DLA_PLIKU = "kontrole.log.zakonczonoGenerowanieRaportuDlaPliku";
    private static final String BUNDLE_CZAS_GENEROWANIA_RAPORTU_DLA_PLIKU = "kontrole.log.czasGenerowaniaRaportuDlaPliku";
    private static final String BUNDLE_ANULOWANO_KONTROLE = "kontrole.anulowanoKontrole";
    private static final String BUNDLE_NEGATYWNY_WYNIK_WALIDACJI = "kontrole.negatywnyWynikWalidacjiKontroleAtrybutowePominiete";
    private static final String BUNDLE_ROZPOCZETO_KONTROLE_ATRYBUTOWE = "kontrola.rozpoczetoWykonywanieKontroliAtrybutowych";
    private static final String BUNDLE_ZAKONCZONO_KONTROLE_ATRYBUTOWE = "kontrola.zakonczonoWykonywanieKontroliAtrybutowych";
    private static final String BUNDLE_CZAS_WYKONYWANIA_KONTROLI_ATRYBUTOWYCH = "kontrola.czasWykonywaniaKontroliAtrybutowych";
    private static final String BUNDLE_ROZPOCZETO_WERYFIKACJE_PLIKU = "kontrola.rozpoczetoWeryfikacjePliku";
    private static final String BUNDLE_CZAS_WALIDACJI_PLIKU = "kontrole.log.czasWalidacjiDlaPliku";
    private static final String BUNDLE_ROZPOCZETO_WALIDACJE_PLIKU = "kontrola.rozpoczetoWalidacjePliku";
    private static final String BUNDLE_ZAKONCZONO_WALIDACJE_PLIKU = "kontrola.zakonczonoWalidacjePliku";
    private static final String BUNDLE_ROZPOCZETO_PROCES_WERYFIKACJI = "kontrola.rozpoczetoProcesWeryfikacji";
    private ResourceBundle bundle;
    private OgolneParametryKontroli ogolneParametryKontroli;
    private PlikWynikowy plikWynikowy;
    private List<KontrolaExecutor> listaKontroli = new ArrayList<KontrolaExecutor>();
    private Map<String, String> mapowanieNazwGrupKontroli = new HashMap<String, String>();
    private int numerKontrolowanegoPliki = 0;
    private BledyWeryfikacjiService bledyWeryfikacjiService;
    private Map<String, OgolnePodsumowanieKontroli> licznikKontroli = new HashMap<String, OgolnePodsumowanieKontroli>();
    private KontrolaLogService kontrolaLogService;
    private String wersjaSzablonuKontroli;

    public KontrolaTask() {
        this.updateProgress(0L, 100L);
        this.bundle = ResourceBundle.getBundle("bundles.dak", Locale.getDefault());
    }

    protected Void call() throws Exception {
        this.ustawPrzedWeryfikacja();
        for (ParametryKontroliPliku p : this.ogolneParametryKontroli.getPlikiDoKontroli()) {
            this.updateProgress(0L, 100L);
            this.wezerujLiczbeSkontrolowanychObiektow();
            this.wykonajWeryfikacjePliku(p);
            Runtime.getRuntime().gc();
            if (!this.isCancelled()) continue;
            this.obsluzPrzerwanieWeryfikacji(p);
            return null;
        }
        this.obsluzZakonczenieWeryfikacji();
        if (this.isCancelled()) {
            this.ogolneParametryKontroli.czyKontrolaWTrakcieProperty().setValue(Boolean.valueOf(false));
        }
        return null;
    }

    private void ustawPrzedWeryfikacja() throws IOException {
        this.inicjujLogPlikowy();
        this.bledyWeryfikacjiService = new BledyWeryfikacjiService();
        this.budujMapowanieGrupIUstawLicznikKontroli();
        this.dodajKomunikat(this.bundle.getString(BUNDLE_ROZPOCZETO_PROCES_WERYFIKACJI));
    }

    private void wezerujLiczbeSkontrolowanychObiektow() {
        this.ogolneParametryKontroli.setLiczbaObiektowPliku(0);
    }

    private void wykonajWeryfikacjePliku(ParametryKontroliPliku parametryPliku) throws BladWalidatoraXsd, BrakZaleznegoPlikuXSD, BrakPlikuXsdException {
        this.ustawDaneKontroli(parametryPliku);
        long czasRozpoczecia = System.currentTimeMillis();
        boolean poprawnaStruktura = this.wykonajWalidacjePliku(parametryPliku);
        this.wypiszStatystykiWalidacjiDEBUG(czasRozpoczecia, parametryPliku.getNazwaPliku());
        this.obsluzNegatywnaWalidacje(parametryPliku, poprawnaStruktura);
        if (this.isCancelled()) {
            this.ogolneParametryKontroli.czyKontrolaWTrakcieProperty().setValue(Boolean.valueOf(false));
            return;
        }
        if (poprawnaStruktura && this.ogolneParametryKontroli.czyKontroleAtrybutoweProperty().getValue().booleanValue() && this.uruchomKontroleAtrybutowe(parametryPliku)) {
            return;
        }
        this.dodajKomunikat(this.bundle.getString(BUNDLE_ZAKONCZONO_PLIK) + parametryPliku.getNazwaPliku());
        String komunikat = MessageFormat.format(this.bundle.getString(BUNDLE_CZAS_WERYFIKACJI_PLIKU), parametryPliku.getNazwaPliku(), Long.toString(System.currentTimeMillis() - czasRozpoczecia), Integer.toString(this.ogolneParametryKontroli.getLiczbaObiektowPliku()));
        this.dodajKomunikatLog(komunikat);
        WynikKontroliService wynikKontroliService = new WynikKontroliService(this.licznikKontroli, this.mapowanieNazwGrupKontroli, this.bledyWeryfikacjiService, parametryPliku.sciezkaPlikuDoKontroliProperty().getValue(), this.wersjaSzablonuKontroli, poprawnaStruktura);
        this.wygenerujRaporty(parametryPliku, wynikKontroliService);
        this.bledyWeryfikacjiService.truncate();
    }

    private void obsluzPrzerwanieWeryfikacji(ParametryKontroliPliku p) throws BladSQLException {
        WynikiKontroliHelper.anulowanoKontrolePliku(this.ogolneParametryKontroli, p.getNazwaPliku());
        this.wypiszWynikiWeryfikacji(this.bundle.getString(BUNDLE_PRZERWANO_PROCES_WERYFIKACJI), this.ogolneParametryKontroli);
        KomunikatyUtils.wyswietlPodsumowanieKontroli(this.ogolneParametryKontroli, this.bundle.getString(BUNDLE_PRZERWANO_PROCES_WERYFIKACJI));
        this.bledyWeryfikacjiService.splucz();
        this.wyzerujLicznikPliku();
        this.bledyWeryfikacjiService.close();
        this.kontrolaLogService.zamknij();
    }

    private void obsluzZakonczenieWeryfikacji() throws BladSQLException {
        this.wypiszWynikiWeryfikacji(this.bundle.getString(BUNDLE_ZAKONCZONO_PROCES_WERYFIKACJI), this.ogolneParametryKontroli);
        this.bledyWeryfikacjiService.splucz();
        this.wyzerujLicznikPliku();
        this.bledyWeryfikacjiService.close();
        this.kontrolaLogService.zamknij();
        KomunikatyUtils.wyswietlPodsumowanieKontroli(this.ogolneParametryKontroli, this.bundle.getString(BUNDLE_ZAKONCZONO_PROCES_WERYFIKACJI));
    }

    private void wypiszWynikiWeryfikacji(String tytul, OgolneParametryKontroli parametryKontroli) {
        String wyniki = parametryKontroli.getWynikiKontroli().entrySet().stream().sorted((o1, o2) -> ((String)o1.getKey()).compareToIgnoreCase((String)o2.getKey())).map(p -> (String)p.getKey() + " - " + (String)p.getValue()).collect(Collectors.joining("\n"));
        Platform.runLater(() -> this.dodajKomunikatBezDaty(DateUtils.pobierzAktualnaDataDoLogow() + " " + tytul + "\r\n\r\nWyniki weryfikacji: \n" + wyniki));
    }

    private void inicjujLogPlikowy() throws IOException {
        File katalogLogow = new File(Konfiguracja.getInstancja().pobierzString("katalogLogow"));
        if (!katalogLogow.exists()) {
            katalogLogow.mkdirs();
        }
        String sciezkaPlikuWynikowego = katalogLogow.getAbsolutePath() + File.separator + "kontrola_" + DateUtils.formatujDate(new Date(), "yyyy_MM_dd_HH_mm_ss") + ".log";
        this.plikWynikowy = new PlikWynikowy();
        this.plikWynikowy.setPlik(new File(sciezkaPlikuWynikowego));
        this.kontrolaLogService = new KontrolaLogService(this.plikWynikowy);
        this.inicjujLog();
    }

    private void inicjujLog() {
        this.kontrolaLogService.dodajWpisDoLogu(this.bundle.getString(BUNDLE_WERSJA_APLIKACJI) + Konfiguracja.getInstancja().pobierzString("wersja"));
        this.kontrolaLogService.dodajWpisDoLogu(this.bundle.getString(BUNDLE_SCIEZKA_SZABLONU_KONTROLI) + this.ogolneParametryKontroli.getSciezkaDoSzablonuKontroli());
        this.kontrolaLogService.dodajWpisDoLogu(this.bundle.getString(BUNDLE_SCIEZKA_SCHEMATU_APLIKACYJNEGO) + this.ogolneParametryKontroli.getSciezkaDoSchematuAplikacyjnego());
        this.kontrolaLogService.dodajWpisDoLogu(this.bundle.getString(BUNDLE_LISTA_KONTROLOWANYCH_PLIKOW) + this.ogolneParametryKontroli.getPlikiDoKontroli().stream().map(ParametryKontroliPliku::getSciezkaPlikuDoKontroli).collect(Collectors.joining(", ")));
        this.kontrolaLogService.dodajWpisDoLogu("---------------------------------------------------------------\r\n");
    }

    private void budujMapowanieGrupIUstawLicznikKontroli() {
        if (!this.ogolneParametryKontroli.czyKontroleAtrybutoweProperty().get()) {
            return;
        }
        this.listaKontroli.forEach(kontrolaExecutor -> {
            OgolnePodsumowanieKontroli ogolnePodsumowanieKontroli = new OgolnePodsumowanieKontroli();
            ogolnePodsumowanieKontroli.setNazwaKontroli(kontrolaExecutor.getNazwaKontroli());
            ogolnePodsumowanieKontroli.setIdKontroli(kontrolaExecutor.getKontrolaId());
            ogolnePodsumowanieKontroli.setKomunikatKontroli(kontrolaExecutor.getKomunikat());
            ogolnePodsumowanieKontroli.setIdGrupyKontroli(kontrolaExecutor.getGrupaKontroliId());
            ogolnePodsumowanieKontroli.setKrytycznosc(kontrolaExecutor.getKrytycznosc());
            this.licznikKontroli.put(kontrolaExecutor.getKontrolaId(), ogolnePodsumowanieKontroli);
            if (!this.mapowanieNazwGrupKontroli.containsKey(kontrolaExecutor.getGrupaKontroliId())) {
                this.mapowanieNazwGrupKontroli.put(kontrolaExecutor.getGrupaKontroliId(), kontrolaExecutor.getGrupaKontroli());
            }
        });
    }

    private void zerujLicznikiKontroli() {
        this.licznikKontroli.entrySet().forEach(entry -> {
            ((OgolnePodsumowanieKontroli)entry.getValue()).setObiektowBlednych(0);
            ((OgolnePodsumowanieKontroli)entry.getValue()).setObiektowOgolem(0);
            ((OgolnePodsumowanieKontroli)entry.getValue()).setObiektowPominietych(0);
        });
    }

    private void wyzerujLicznikPliku() {
        this.numerKontrolowanegoPliki = 0;
    }

    private void wygenerujRaporty(ParametryKontroliPliku parametryPliku, WynikKontroliService wynikKontroliService) {
        try {
            long czasStartuRaportu = System.currentTimeMillis();
            this.dodajKomunikat(this.bundle.getString(BUNDLE_ROZPOCZETO_GENEROWANIE_RAPORTU_DLA_PLIKU) + parametryPliku.getNazwaPliku());
            this.generujRaport(wynikKontroliService);
            this.dodajKomunikat(this.bundle.getString(BUNDLE_ZAKONCZONO_GENEROWANIE_RAPORTU_DLA_PLIKU) + parametryPliku.getNazwaPliku());
            long czas = System.currentTimeMillis() - czasStartuRaportu;
            this.dodajKomunikatLog(MessageFormat.format(this.bundle.getString(BUNDLE_CZAS_GENEROWANIA_RAPORTU_DLA_PLIKU), parametryPliku.getNazwaPliku(), Long.toString(czas)));
        }
        catch (InterruptedException ex) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(ex);
        }
    }

    private boolean uruchomKontroleAtrybutowe(ParametryKontroliPliku parametryPliku) {
        try {
            long rozpoczecieKontroli = System.currentTimeMillis();
            this.dodajKomunikatLog(this.bundle.getString(BUNDLE_ROZPOCZETO_KONTROLE_ATRYBUTOWE) + parametryPliku.getNazwaPliku());
            this.wykonajKontroleAtrybutowe(parametryPliku);
            this.dodajKomunikatLog(this.bundle.getString(BUNDLE_ZAKONCZONO_KONTROLE_ATRYBUTOWE) + parametryPliku.getNazwaPliku());
            this.dodajKomunikatLog(MessageFormat.format(this.bundle.getString(BUNDLE_CZAS_WYKONYWANIA_KONTROLI_ATRYBUTOWYCH), Long.toString(System.currentTimeMillis() - rozpoczecieKontroli), Integer.toString(this.ogolneParametryKontroli.getLiczbaObiektowPliku())));
        }
        catch (PrzerwanieKontroliAtrybutowejException e) {
            WynikiKontroliHelper.anulowanoKontrolePliku(this.ogolneParametryKontroli, parametryPliku.getNazwaPliku());
            return true;
        }
        return false;
    }

    private void obsluzNegatywnaWalidacje(ParametryKontroliPliku parametryPliku, boolean poprawnaStruktura) {
        if (!poprawnaStruktura && this.ogolneParametryKontroli.czyKontroleAtrybutoweProperty().get()) {
            this.dodajKomunikat(MessageFormat.format(this.bundle.getString(BUNDLE_NEGATYWNY_WYNIK_WALIDACJI), parametryPliku.getNazwaPliku()));
        }
    }

    private void wypiszStatystykiWalidacjiDEBUG(long czasRozpoczecia, String nazwaPliku) {
        long czas = System.currentTimeMillis() - czasRozpoczecia;
        String komunikat = this.bundle.getString(BUNDLE_CZAS_WALIDACJI_PLIKU);
        komunikat = MessageFormat.format(komunikat, nazwaPliku, Long.toString(czas), Integer.toString(this.ogolneParametryKontroli.getLiczbaObiektowPliku()));
        this.dodajKomunikatLog(komunikat);
    }

    private void ustawDaneKontroli(ParametryKontroliPliku parametryPliku) {
        this.dodajKomunikat(this.bundle.getString(BUNDLE_ROZPOCZETO_WERYFIKACJE_PLIKU) + parametryPliku.getNazwaPliku());
        this.aktualizujNumerKontrolowanegoPliku();
        this.zerujLicznikiKontroli();
    }

    private void aktualizujNumerKontrolowanegoPliku() {
        ++this.numerKontrolowanegoPliki;
        Platform.runLater(() -> this.ogolneParametryKontroli.liczbaSkontrolowanychPlikowProperty().setValue((Number)this.numerKontrolowanegoPliki));
    }

    private boolean wykonajWalidacjePliku(ParametryKontroliPliku parametryPliku) throws BrakZaleznegoPlikuXSD, BladWalidatoraXsd, BrakPlikuXsdException {
        this.dodajKomunikatLog(this.bundle.getString(BUNDLE_ROZPOCZETO_WALIDACJE_PLIKU) + parametryPliku.getNazwaPliku());
        WalidacjaService walidacjaService = new WalidacjaService();
        walidacjaService.setKontrolaTask(this);
        boolean wynik = walidacjaService.wykonajWalidacje(this.ogolneParametryKontroli, parametryPliku);
        this.dodajKomunikatLog(this.bundle.getString(BUNDLE_ZAKONCZONO_WALIDACJE_PLIKU) + parametryPliku.getNazwaPliku());
        return wynik;
    }

    private void wykonajKontroleAtrybutowe(ParametryKontroliPliku parametryPliku) throws PrzerwanieKontroliAtrybutowejException {
        KontroleAtrybutoweService kontroleAtrybutoweService = new KontroleAtrybutoweService();
        kontroleAtrybutoweService.setKontrolaTask(this);
        kontroleAtrybutoweService.wykonajKontrole(parametryPliku, this.listaKontroli);
        if (this.isCancelled()) {
            this.dodajKomunikatLog(this.bundle.getString(BUNDLE_ANULOWANO_KONTROLE));
            throw new PrzerwanieKontroliAtrybutowejException();
        }
    }

    private void generujRaport(WynikKontroliService wynikKontroliService) throws InterruptedException {
        RaportService raportService = new RaportService(this.ogolneParametryKontroli, wynikKontroliService, this.bledyWeryfikacjiService);
        Wynik wynik = raportService.generuj();
        WynikiKontroliHelper.dodajWynikKontroliPliku(this.ogolneParametryKontroli, Paths.get(wynik.getNazwaPliku(), new String[0]).getFileName().toString(), wynik.getWynikOgolnyKontroli());
    }

    public void setOgolneParametryKontroli(OgolneParametryKontroli ogolneParametryKontroli) {
        this.ogolneParametryKontroli = ogolneParametryKontroli;
    }

    public void aktualizujLiczbeObiektow(int i) {
        Platform.runLater(() -> this.ogolneParametryKontroli.liczbaSkontrolowanychObiektowProperty().setValue((Number)i));
        this.updateProgress(i, this.ogolneParametryKontroli.getLiczbaObiektowPliku());
    }

    public void ustawLiczbeObiektowWPliku(Integer liczbaObiektow) {
        this.ogolneParametryKontroli.liczbaObiektowPlikuProperty().setValue((Number)liczbaObiektow);
    }

    public void dodajKomunikatLog(String komunikat) {
        if (Konfiguracja.getInstancja().czyDebug()) {
            this.dodajKomunikatLog(DateUtils.pobierzAktualnaDataDoLogow() + " " + komunikat, false);
        }
    }

    public void dodajKomunikatLogBezDaty(String e) {
        this.dodajKomunikatLog(e, false);
    }

    public void dodajKomunikatLog(String e, boolean wyswietlUzytkownikowi) {
        this.kontrolaLogService.dodajWpisDoLogu(e);
        if (wyswietlUzytkownikowi) {
            this.dodajKomunikat(e);
        }
    }

    public void dodajKomunikat(String komunikat) {
        String aktualnaData = DateUtils.pobierzAktualnaDataDoLogow();
        komunikat = aktualnaData + " " + komunikat;
        this.dodajKomunikatBezDaty(komunikat);
    }

    public void dodajKomunikatBezDaty(String e) {
        if (Platform.isFxApplicationThread()) {
            String message = this.getMessage();
            if (!Strings.isNullOrEmpty((String)message)) {
                message = message + "\n";
            }
            this.updateMessage(message + e);
            if (Konfiguracja.getInstancja().czyDebug()) {
                this.dodajKomunikatLogBezDaty(e);
            }
        } else {
            String finalE = e;
            Platform.runLater(() -> {
                String message = this.getMessage();
                if (!Strings.isNullOrEmpty((String)message)) {
                    message = message + "\n";
                }
                this.updateMessage(message + finalE);
            });
            if (Konfiguracja.getInstancja().czyDebug()) {
                this.dodajKomunikatLogBezDaty(e);
            }
        }
    }

    public void setPlikWynikowy(PlikWynikowy plikWynikowy) {
        this.plikWynikowy = plikWynikowy;
    }

    public List<KontrolaExecutor> getListaKontroli() {
        return this.listaKontroli;
    }

    public void setListaKontroli(List<KontrolaExecutor> listaKontroli) {
        this.listaKontroli = listaKontroli;
    }

    public Map<String, OgolnePodsumowanieKontroli> getLicznikKontroli() {
        return this.licznikKontroli;
    }

    public void setLicznikKontroli(Map<String, OgolnePodsumowanieKontroli> licznikKontroli) {
        this.licznikKontroli = licznikKontroli;
    }

    public BledyWeryfikacjiService getBledyWeryfikacjiService() {
        return this.bledyWeryfikacjiService;
    }

    public void setBledyWeryfikacjiService(BledyWeryfikacjiService bledyWeryfikacjiService) {
        this.bledyWeryfikacjiService = bledyWeryfikacjiService;
    }

    public String getWersjaSzablonuKontroli() {
        return this.wersjaSzablonuKontroli;
    }

    public void setWersjaSzablonuKontroli(String wersjaSzablonuKontroli) {
        this.wersjaSzablonuKontroli = wersjaSzablonuKontroli;
    }
}

