/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.kontrole.executory;

import org.joox.Match;
import org.w3c.dom.Element;
import pl.gov.gugik.gesut.dak.biz.kontrole.executory.KontrolaExecutor;
import pl.gov.gugik.gesut.dak.biz.kontrole.walidacje.WalidacjaZakresWartosciHelper;
import pl.gov.gugik.gesut.dak.biz.kontrole.walidacje.dto.ZakresWartosciDTO;
import pl.gov.gugik.gesut.dak.biz.utils.kontrole.ObiektHelper;
import pl.gov.gugik.gesut.dak.model.kontrole.AtrybutyBledu;
import pl.gov.gugik.gesut.dak.model.kontrole.BladKontroli;
import pl.gov.gugik.gesut.dak.model.kontrole.WynikKontroli;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.ZakresWartosci;

public class KontrolaDlugoscCiagowZnakowExecutor
extends KontrolaExecutor {
    private ZakresWartosciDTO zakresWartosciDTO;

    @Override
    public WynikKontroli kontroluj(Match feature, String nazwaKontrolowanegoPliku) {
        WynikKontroli wynikKontroli = new WynikKontroli();
        Match obiektAtrybutu = ObiektHelper.pobierzWartoscAtrybutu(feature, this.getAtrybut());
        wynikKontroli.setPozytywny(true);
        if (!obiektAtrybutu.isEmpty()) {
            for (Element element : obiektAtrybutu.get()) {
                String wartoscAtrybutu = element.getTextContent();
                AtrybutyBledu wynik = this.czyOdpowiedniaDlugosc(this.getNazwaAtrybutu(), wartoscAtrybutu, this.zakresWartosciDTO);
                if (!wynik.isBlad()) continue;
                wynikKontroli.setPozytywny(false);
                BladKontroli bladKontroli = this.budujBladKontroli(feature, nazwaKontrolowanegoPliku, wynik);
                wynikKontroli.setBladKontroli(bladKontroli);
            }
        }
        return wynikKontroli;
    }

    public void ustawZakres(ZakresWartosci zakresWartosci) {
        this.zakresWartosciDTO = WalidacjaZakresWartosciHelper.utworzDTO(zakresWartosci);
    }

    private BladKontroli budujBladKontroli(Match feature, String nazwaKontrolowanegoPliku, AtrybutyBledu atrybutyBledu) {
        BladKontroli bladKontroli = this.generujBladKontroli(feature, nazwaKontrolowanegoPliku);
        bladKontroli.setAttr1Naz(atrybutyBledu.getAttr1Naz());
        bladKontroli.setAttr1Wart(atrybutyBledu.getAttr1Wart());
        return bladKontroli;
    }

    private AtrybutyBledu czyOdpowiedniaDlugosc(String nazwaAtrybutu, String wartoscAtrybutu, ZakresWartosciDTO zakresWartosciDTO) {
        String dlugosc = String.valueOf(wartoscAtrybutu.length());
        String ucietaWartosc = wartoscAtrybutu;
        if (zakresWartosciDTO.getWartoscDo() != null) {
            Integer dlugoscMax = Integer.parseInt(zakresWartosciDTO.getWartoscDo());
            if (ucietaWartosc.length() > dlugoscMax) {
                ucietaWartosc = ucietaWartosc.substring(0, dlugoscMax + 1) + "...";
            }
        }
        return WalidacjaZakresWartosciHelper.sprawdzCzyWZakresie(dlugosc, zakresWartosciDTO) ? new AtrybutyBledu() : new AtrybutyBledu(nazwaAtrybutu, ucietaWartosc);
    }
}

