/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.kontrole.executory;

import com.google.common.base.Strings;
import org.joox.Match;
import org.w3c.dom.Element;
import pl.gov.gugik.gesut.dak.biz.kontrole.executory.KontrolaExecutor;
import pl.gov.gugik.gesut.dak.biz.kontrole.walidacje.WalidacjaZakresWartosciHelper;
import pl.gov.gugik.gesut.dak.biz.kontrole.walidacje.dto.ZakresWartosciDTO;
import pl.gov.gugik.gesut.dak.biz.utils.kontrole.ObiektHelper;
import pl.gov.gugik.gesut.dak.model.kontrole.BladKontroli;
import pl.gov.gugik.gesut.dak.model.kontrole.WynikKontroli;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.ZakresWartosci;

public class KontrolaWartosciWZakresieExecutor
extends KontrolaExecutor {
    private ZakresWartosciDTO zakresWartosciDTO;

    @Override
    public WynikKontroli kontroluj(Match feature, String nazwaKontrolowanegoPliku) {
        WynikKontroli wynikKontroli = new WynikKontroli();
        Match obiektAtrybutu = ObiektHelper.pobierzWartoscAtrybutu(feature, this.getAtrybut());
        wynikKontroli.setPozytywny(true);
        if (!obiektAtrybutu.isEmpty()) {
            for (Element element : obiektAtrybutu.get()) {
                String wartoscAtrybutu = element.getTextContent();
                if (Strings.isNullOrEmpty((String)wartoscAtrybutu) || WalidacjaZakresWartosciHelper.sprawdzCzyWZakresie(wartoscAtrybutu, this.zakresWartosciDTO)) continue;
                wynikKontroli.setPozytywny(false);
                BladKontroli bladKontroli = this.budujBladKontroli(feature, wartoscAtrybutu, nazwaKontrolowanegoPliku);
                wynikKontroli.setBladKontroli(bladKontroli);
            }
        }
        return wynikKontroli;
    }

    public void ustawWartosci(ZakresWartosci zakres) {
        this.zakresWartosciDTO = WalidacjaZakresWartosciHelper.utworzDTO(zakres);
    }

    private BladKontroli budujBladKontroli(Match feature, String wartoscAtrybutu, String nazwaKontrolowanegoPliku) {
        BladKontroli bladKontroli = this.generujBladKontroli(feature, nazwaKontrolowanegoPliku);
        bladKontroli.setAttr1Wart(wartoscAtrybutu);
        return bladKontroli;
    }
}

