/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.kontrole.fabryki;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.gov.gugik.gesut.dak.biz.kontrole.executory.KontrolaExecutor;
import pl.gov.gugik.gesut.dak.biz.kontrole.fabryki.FabrykaKontroli;
import pl.gov.gugik.gesut.dak.biz.kontrole.fabryki.KontrolaDlugoscCiagowZnakowFactory;
import pl.gov.gugik.gesut.dak.biz.kontrole.fabryki.KontrolaLicznoscWZakresieFactory;
import pl.gov.gugik.gesut.dak.biz.kontrole.fabryki.KontrolaObligatoryjnoscWarunkowaFactory;
import pl.gov.gugik.gesut.dak.biz.kontrole.fabryki.KontrolaPorownanieAtrybutowFactory;
import pl.gov.gugik.gesut.dak.biz.kontrole.fabryki.KontrolaWartoscWZakresieFactory;
import pl.gov.gugik.gesut.dak.biz.kontrole.fabryki.KontrolaWartoscWZbiorzeFactory;
import pl.gov.gugik.gesut.dak.biz.kontrole.fabryki.KontrolaZgodnoscZeWzorcemFactory;
import pl.gov.gugik.gesut.dak.biz.utils.kontrole.ObiektHelper;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.GrupaKontroliAtrybutowych;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.Klasy;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.Kontrola;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.kontrole.kontrolaDlugoscCiaguZnakow.KontrolaDlugoscCiaguZnakow;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.kontrole.kontrolaLicznosciWZakresie.KontrolaLicznoscWZakresie;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.kontrole.kontrolaObligatoryjnoscWarunkowa.KontrolaObligatoryjnoscWarunkowa;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.kontrole.kontrolaPorownanieAtrybutow.KontrolaPorownanieAtrybutow;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.kontrole.kontrolaWartosciWZakresie.KontrolaWartoscWZakresie;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.kontrole.kontrolaWartosciWZbiorze.KontrolaWartoscWZbiorze;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.kontrole.kontrolaZgodnoscZeWzorcem.KontrolaZgodnoscZeWzorcem;

public class KontrolaFactory {
    private Map<String, List<String>> grupyKlas = new HashMap<String, List<String>>();

    public List<KontrolaExecutor> budujListeKontroli(GrupaKontroliAtrybutowych grupaKontroliAtrybutowych) {
        ArrayList<KontrolaExecutor> lista = new ArrayList<KontrolaExecutor>();
        if (grupaKontroliAtrybutowych.getKontrola() == null) {
            return lista;
        }
        grupaKontroliAtrybutowych.getKontrola().forEach(kontrola -> {
            KontrolaExecutor kontrolaExecutor = this.budujKontrole((Kontrola)kontrola, grupaKontroliAtrybutowych);
            if (kontrolaExecutor != null) {
                lista.add(kontrolaExecutor);
            }
        });
        return lista;
    }

    public Map<String, List<String>> getGrupyKlas() {
        return this.grupyKlas;
    }

    public void setGrupyKlas(Map<String, List<String>> grupyKlas) {
        this.grupyKlas = grupyKlas;
    }

    private List<String> budujListeKlas(Klasy klasy) {
        ArrayList<String> lista = new ArrayList<String>();
        if (klasy.getGrupa() != null) {
            lista.addAll(this.pobierzKlasyZGrupy(klasy.getGrupa()));
        }
        if (klasy.getKlasa() != null) {
            lista.addAll(klasy.getKlasa());
        }
        return lista;
    }

    private List<String> pobierzKlasyZGrupy(List<String> grupy) {
        ArrayList<String> lista = new ArrayList<String>();
        grupy.forEach(grupa -> {
            if (this.grupyKlas.containsKey(grupa)) {
                lista.addAll((Collection)this.grupyKlas.get(grupa));
            } else {
                System.err.println("Brak zdefiniowanej grupy: " + grupa);
            }
        });
        return lista;
    }

    private FabrykaKontroli pobierzFabrykeKontroli(Kontrola kontrola) {
        if (kontrola instanceof KontrolaWartoscWZbiorze) {
            return new KontrolaWartoscWZbiorzeFactory();
        }
        if (kontrola instanceof KontrolaZgodnoscZeWzorcem) {
            return new KontrolaZgodnoscZeWzorcemFactory();
        }
        if (kontrola instanceof KontrolaWartoscWZakresie) {
            return new KontrolaWartoscWZakresieFactory();
        }
        if (kontrola instanceof KontrolaDlugoscCiaguZnakow) {
            return new KontrolaDlugoscCiagowZnakowFactory();
        }
        if (kontrola instanceof KontrolaLicznoscWZakresie) {
            return new KontrolaLicznoscWZakresieFactory();
        }
        if (kontrola instanceof KontrolaPorownanieAtrybutow) {
            return new KontrolaPorownanieAtrybutowFactory();
        }
        if (kontrola instanceof KontrolaObligatoryjnoscWarunkowa) {
            return new KontrolaObligatoryjnoscWarunkowaFactory();
        }
        return null;
    }

    private KontrolaExecutor budujKontrole(Kontrola kontrola, GrupaKontroliAtrybutowych grupaKontroliAtrybutowych) {
        FabrykaKontroli fabrykaKontroli = this.pobierzFabrykeKontroli(kontrola);
        if (fabrykaKontroli == null) {
            System.err.println("Nieobs\u0142ugiwany typ kontroli: " + kontrola.getClass().getSimpleName());
            return null;
        }
        KontrolaExecutor kontrolaExecutor = fabrykaKontroli.budujKontrole(kontrola);
        kontrolaExecutor.setGrupaKontroli(grupaKontroliAtrybutowych.getName());
        kontrolaExecutor.setGrupaKontroliId(grupaKontroliAtrybutowych.getId());
        kontrolaExecutor.setKlasy(this.budujListeKlas(kontrola.getKlasy()));
        kontrolaExecutor.setAtrybut(kontrola.getAtrybut());
        kontrolaExecutor.setNazwaAtrybutu(ObiektHelper.pobierzNazweAtrybutu(kontrola.getAtrybut()));
        kontrolaExecutor.setAtrybutyDoRaportu(kontrola.getAtrybutyDoRaportu());
        kontrolaExecutor.setKontrolaId(kontrola.getId());
        kontrolaExecutor.setNazwaKontroli(kontrola.getNazwa());
        kontrolaExecutor.setKomunikat(kontrola.getKomunikat());
        kontrolaExecutor.setKrytycznosc(kontrola.getKrytycznosc());
        kontrolaExecutor.setWarunkiWejsciowe(kontrola.getWarunkiWejsciowe());
        return kontrolaExecutor;
    }
}

