/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.kontrole;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;
import pl.gov.gugik.gesut.dak.biz.utils.KomunikatyUtils;
import pl.gov.gugik.gesut.dak.dao.BledyWeryfikacjiDAO;
import pl.gov.gugik.gesut.dak.dao.wyjatki.BladSQLException;
import pl.gov.gugik.gesut.dak.model.kontrole.BladKontroli;
import pl.gov.gugik.gesut.dak.model.walidacja.BladWalidacji;

public class BledyWeryfikacjiService {
    private static final int DLUGOSC_KOLEJKI = 1000;
    private BledyWeryfikacjiDAO bledyWeryfikacjiDAO;
    private List<BladKontroli> listaBledowKontroliDoZapisu = new ArrayList<BladKontroli>();
    private List<BladWalidacji> listaBledowWalidacjiDoZapisu = new ArrayList<BladWalidacji>();

    public boolean czySaBledyWalidacji(String nazwaPliku) {
        try {
            return this.bledyWeryfikacjiDAO.czySaBledyWalidacji(nazwaPliku);
        }
        catch (BladSQLException e) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
            return true;
        }
    }

    public int pobierzLiczbeBledowKontroli(String plik, String idKontroli) {
        try {
            return this.bledyWeryfikacjiDAO.pobierzLiczbeBledowKontroli(plik, idKontroli);
        }
        catch (BladSQLException e) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
            return 0;
        }
    }

    public Iterator<BladKontroli> pobierzIteratorBledowKontroli(String plik, String idKontroli, Boolean max10) {
        try {
            return this.bledyWeryfikacjiDAO.pobierzIteratorBledowKontroli(plik, idKontroli, max10);
        }
        catch (BladSQLException e) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
            return null;
        }
    }

    public Long pobierzLiczbeBledowWalidacji(String nazwaPliku) {
        try {
            return this.bledyWeryfikacjiDAO.pobierzLiczbeBledowWalidacji(nazwaPliku);
        }
        catch (BladSQLException e) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
            return null;
        }
    }

    public Iterator<BladWalidacji> pobierzIteratorBledowWalidacji(String nazwaPliku, boolean max100) {
        try {
            return this.bledyWeryfikacjiDAO.pobierzIteratorBledowWalidacji(nazwaPliku, max100);
        }
        catch (BladSQLException e) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
            return null;
        }
    }

    public void splucz() throws BladSQLException {
        this.bledyWeryfikacjiDAO.zapiszBledyWalidacji(this.listaBledowWalidacjiDoZapisu);
        this.bledyWeryfikacjiDAO.zapiszBledyKontroli(this.listaBledowKontroliDoZapisu);
        this.listaBledowKontroliDoZapisu.clear();
        this.listaBledowWalidacjiDoZapisu.clear();
    }

    public BledyWeryfikacjiService() {
        try {
            this.bledyWeryfikacjiDAO = new BledyWeryfikacjiDAO();
        }
        catch (BladSQLException e) {
            KomunikatyUtils.budujAlertBledu("B\u0142\u0105d tworzenia serwisu", e.getMessage()).showAndWait();
        }
    }

    public void zapiszBledyKontroli(BladKontroli bladKontroli) throws BladSQLException {
        this.listaBledowKontroliDoZapisu.add(bladKontroli);
        if (this.listaBledowKontroliDoZapisu.size() == 1000) {
            this.bledyWeryfikacjiDAO.zapiszBledyKontroli(this.listaBledowKontroliDoZapisu);
            this.listaBledowKontroliDoZapisu.clear();
        }
    }

    public void zapiszBledyWalidacji(BladWalidacji bladWalidacji) throws BladSQLException {
        this.listaBledowWalidacjiDoZapisu.add(bladWalidacji);
        if (this.listaBledowWalidacjiDoZapisu.size() == 1000) {
            this.bledyWeryfikacjiDAO.zapiszBledyWalidacji(this.listaBledowWalidacjiDoZapisu);
            this.listaBledowWalidacjiDoZapisu.clear();
        }
    }

    public void close() throws BladSQLException {
        this.bledyWeryfikacjiDAO.zapiszBledyWalidacji(this.listaBledowWalidacjiDoZapisu);
        this.bledyWeryfikacjiDAO.zapiszBledyKontroli(this.listaBledowKontroliDoZapisu);
        this.listaBledowKontroliDoZapisu.clear();
        this.listaBledowWalidacjiDoZapisu.clear();
        this.bledyWeryfikacjiDAO.close();
    }

    public List<String> pobierzNazwyAtrybutowKontroli(String idKontroli) throws BladSQLException {
        return this.bledyWeryfikacjiDAO.pobierzNazwyAtrybutowKontroli(idKontroli);
    }

    public void truncate() {
        try {
            this.bledyWeryfikacjiDAO.truncate();
        }
        catch (SQLException e) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
        }
    }
}

