/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.kontrole;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import pl.gov.gugik.gesut.dak.biz.conf.Konfiguracja;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.BledyWeryfikacjiService;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;
import pl.gov.gugik.gesut.dak.biz.utils.DateUtils;
import pl.gov.gugik.gesut.dak.dao.wyjatki.BladSQLException;
import pl.gov.gugik.gesut.dak.model.kontrole.OgolnePodsumowanieKontroli;
import pl.gov.gugik.gesut.dak.model.raporty.GrupaKontroliAtrybutowych;
import pl.gov.gugik.gesut.dak.model.raporty.KontrolaAtrybutowa;
import pl.gov.gugik.gesut.dak.model.raporty.KontroleAtrybutowe;
import pl.gov.gugik.gesut.dak.model.raporty.Podsumowanie;
import pl.gov.gugik.gesut.dak.model.raporty.WalidacjaZeSchematem;
import pl.gov.gugik.gesut.dak.model.raporty.Wynik;
import pl.gov.gugik.gesut.dak.model.raporty.ZestawienieLiczboweKontroli;

public class WynikKontroliService {
    private static final Logger log = Logger.getLogger(WynikKontroliService.class);
    public static final String WYNIK_NEGATYWNY = "Negatywny";
    public static final String WYNIK_POZYTYWNY = "Pozytywny";
    public static final String WYNIK_WYMAGA_INTERPRETACJI_ADMINISTRATORA = "Wymaga interpretacji administratora Systemu Zarz\u0105dzania K-GESUT";
    public static final String STATUS_KONTROLI_NIE_PRZEPROWADZONO = "Nie przeprowadzono kontroli";
    public static final String STATUS_KONTROLI_PRZEPROWADZONO = "Przeprowadzono kontrol\u0119";
    public static final String STATUS_KONTROLI_NIE_WYKONANO = "Nie wykonano";
    public static final String WYNIK_KONTROLI_POZYTYWNY = "Wynik pozytywny";
    public static final String WYNIK_KONTROLI_NEGATYWNY = "Wynik negatywny";
    public static final String WYNIK_KONTROLI_BLAD_KRYTYCZNY = "B\u0142\u0105d krytyczny";
    public static final String WYNIK_KONTROLI_WYMAGA_INTERPRETACJI = "Wynik wymaga interpretacji";
    public static final String WYNIK_KONTROLI_WYMAGA_INTERPRETACJI_ADMINISTRATORA = "Wynik wymaga interpretacji administratora Systemu Zarz\u0105dzania K-GESUT";
    private Map<String, OgolnePodsumowanieKontroli> podsumowanie;
    private Map<String, String> mapowanieNazwGrupKontroli;
    private BledyWeryfikacjiService bledyWeryfikacjiService;
    private String kontrolowanyPlik;
    private String wersjaSzablonuKontroli;
    private ZestawienieLiczboweKontroli zestawienieLiczboweKontroli = new ZestawienieLiczboweKontroli();
    private boolean poprawnaStruktura = false;
    private Wynik wynik;
    private boolean statusWalidacji = true;
    private boolean statusKontroli = true;

    public WynikKontroliService(Map<String, OgolnePodsumowanieKontroli> podsumowanie, Map<String, String> mapowanieNazwGrupKontroli, BledyWeryfikacjiService bledyWeryfikacjiService, String kontrolowanyPlik, String wersjaSzablonuKontroli, boolean poprawnaStruktura) {
        this.podsumowanie = podsumowanie;
        this.mapowanieNazwGrupKontroli = mapowanieNazwGrupKontroli;
        this.bledyWeryfikacjiService = bledyWeryfikacjiService;
        this.kontrolowanyPlik = kontrolowanyPlik;
        this.wersjaSzablonuKontroli = wersjaSzablonuKontroli;
        this.poprawnaStruktura = poprawnaStruktura;
    }

    private void budujObiektWynikowy() {
        this.wynik = new Wynik();
        Podsumowanie podsumowanieRaportu = new Podsumowanie();
        podsumowanieRaportu.setZestawienieLiczboweKontroli(this.zestawienieLiczboweKontroli);
        this.wynik.setPodsumowanie(podsumowanieRaportu);
        this.wynik.setWersjaAplikacji(Konfiguracja.getInstancja().getWersja());
        this.wynik.setNazwaPliku(this.kontrolowanyPlik);
        this.wynik.setNazwaPlikuBezSciezki(new File(this.kontrolowanyPlik).getName());
        this.wynik.setDataWygenerowaniaRaportu(DateUtils.formatujDate(new Date(), "yyyy-MM-dd HH:mm:ss"));
        this.wynik.setWersjaSzablonuWeryfikacji(this.wersjaSzablonuKontroli);
        this.okreslWynikWalidacjiDlaPliku(this.kontrolowanyPlik, this.wynik, podsumowanieRaportu);
        this.okreslWynikKontroliDlaPliku(this.kontrolowanyPlik, this.wynik, podsumowanieRaportu);
        if (!this.statusKontroli || !this.statusWalidacji) {
            this.wynik.setWynikOgolnyKontroli(WYNIK_NEGATYWNY);
        } else if (this.statusKontroli && this.zestawienieLiczboweKontroli.getWymagaInterpretacji() > 0) {
            this.wynik.setWynikOgolnyKontroli(WYNIK_WYMAGA_INTERPRETACJI_ADMINISTRATORA);
        } else {
            this.wynik.setWynikOgolnyKontroli(WYNIK_POZYTYWNY);
        }
    }

    private void okreslWynikiKontroli() {
        try {
            this.bledyWeryfikacjiService.splucz();
        }
        catch (BladSQLException e) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
        }
        this.budujObiektWynikowy();
    }

    private void okreslWynikKontroliDlaGrupy(String idGrupy, GrupaKontroliAtrybutowych grupaKontroliAtrybutowych) {
        this.podsumowanie.entrySet().stream().filter(e -> ((OgolnePodsumowanieKontroli)e.getValue()).getIdGrupyKontroli().equals(idGrupy)).forEach(entry -> {
            OgolnePodsumowanieKontroli opk = (OgolnePodsumowanieKontroli)entry.getValue();
            KontrolaAtrybutowa kontrolaAtrybutowa = new KontrolaAtrybutowa();
            grupaKontroliAtrybutowych.getKontrolaAtrybutowa().add(kontrolaAtrybutowa);
            kontrolaAtrybutowa.setNazwa(opk.getNazwaKontroli());
            kontrolaAtrybutowa.setId(opk.getIdKontroli());
            int liczbaBledow = this.bledyWeryfikacjiService.pobierzLiczbeBledowKontroli(this.kontrolowanyPlik, opk.getIdKontroli());
            kontrolaAtrybutowa.setLiczbaBledow(liczbaBledow);
            if (liczbaBledow > 10) {
                kontrolaAtrybutowa.setWyswietlanaLiczbaBledow(10);
            } else {
                kontrolaAtrybutowa.setWyswietlanaLiczbaBledow(liczbaBledow);
            }
            if (opk.getObiektowBlednych() > 0) {
                this.ustawNazwyAtrybutow(kontrolaAtrybutowa);
            }
            if (opk.getObiektowOgolem() > 0) {
                kontrolaAtrybutowa.setStatusKontroli(STATUS_KONTROLI_PRZEPROWADZONO);
                this.zestawienieLiczboweKontroli.setWykonano(this.zestawienieLiczboweKontroli.getWykonano() + 1);
                if (opk.czyPozytywna() && opk.getObiektowBlednych() == 0) {
                    kontrolaAtrybutowa.setWynikKontroli(WYNIK_POZYTYWNY);
                    this.zestawienieLiczboweKontroli.setPozytywne(this.zestawienieLiczboweKontroli.getPozytywne() + 1);
                } else if (opk.czyPozytywna() && opk.getObiektowBlednych() > 0) {
                    kontrolaAtrybutowa.setWynikKontroli(WYNIK_WYMAGA_INTERPRETACJI_ADMINISTRATORA);
                    kontrolaAtrybutowa.setKomunikat(opk.getKomunikatKontroli());
                    this.zestawienieLiczboweKontroli.setWymagaInterpretacji(this.zestawienieLiczboweKontroli.getWymagaInterpretacji() + 1);
                } else {
                    kontrolaAtrybutowa.setWynikKontroli(WYNIK_NEGATYWNY);
                    this.zestawienieLiczboweKontroli.setNegatywne(this.zestawienieLiczboweKontroli.getNegatywne() + 1);
                    kontrolaAtrybutowa.setKomunikat(opk.getKomunikatKontroli());
                    this.statusKontroli = false;
                }
            } else if (opk.getObiektowZBledemKrytycznym() > 0) {
                kontrolaAtrybutowa.setStatusKontroli(STATUS_KONTROLI_NIE_PRZEPROWADZONO);
                kontrolaAtrybutowa.setWynikKontroli(WYNIK_KONTROLI_BLAD_KRYTYCZNY);
                this.zestawienieLiczboweKontroli.setBladKrytyczny(this.zestawienieLiczboweKontroli.getBladKrytyczny() + 1);
                this.statusKontroli = false;
            } else {
                kontrolaAtrybutowa.setStatusKontroli(STATUS_KONTROLI_NIE_PRZEPROWADZONO);
            }
        });
    }

    private void budujGrupyKontroli(String plik, KontroleAtrybutowe kontroleAtrybutowe) {
        this.mapowanieNazwGrupKontroli.entrySet().forEach(entry -> {
            GrupaKontroliAtrybutowych grupaKontroliAtrybutowych = new GrupaKontroliAtrybutowych();
            grupaKontroliAtrybutowych.setNazwa((String)entry.getValue());
            kontroleAtrybutowe.getGrupaKontroliAtrybutowych().add(grupaKontroliAtrybutowych);
            this.okreslWynikKontroliDlaGrupy((String)entry.getKey(), grupaKontroliAtrybutowych);
        });
    }

    private void okreslWynikKontroliDlaPliku(String plik, Wynik wynik, Podsumowanie podsumowanieRaportu) {
        podsumowanieRaportu.setKontroleAtrybutowe(STATUS_KONTROLI_NIE_WYKONANO);
        KontroleAtrybutowe kontroleAtrybutowe = new KontroleAtrybutowe();
        wynik.setKontroleAtrybutowe(kontroleAtrybutowe);
        if (!this.statusWalidacji || this.podsumowanie.size() == 0) {
            kontroleAtrybutowe.setStatusKontroli(STATUS_KONTROLI_NIE_PRZEPROWADZONO);
            return;
        }
        kontroleAtrybutowe.setStatusKontroli(STATUS_KONTROLI_PRZEPROWADZONO);
        this.budujGrupyKontroli(plik, kontroleAtrybutowe);
        this.zestawienieLiczboweKontroli.setSuma(this.zestawienieLiczboweKontroli.getWykonano() + this.zestawienieLiczboweKontroli.getBladKrytyczny());
        if (this.statusKontroli && this.zestawienieLiczboweKontroli.getWymagaInterpretacji() > 0) {
            kontroleAtrybutowe.setWynikKontroli(WYNIK_WYMAGA_INTERPRETACJI_ADMINISTRATORA);
            podsumowanieRaportu.setKontroleAtrybutowe(WYNIK_KONTROLI_WYMAGA_INTERPRETACJI_ADMINISTRATORA);
        } else if (this.statusKontroli) {
            kontroleAtrybutowe.setWynikKontroli(WYNIK_POZYTYWNY);
            podsumowanieRaportu.setKontroleAtrybutowe(WYNIK_KONTROLI_POZYTYWNY);
        } else {
            kontroleAtrybutowe.setWynikKontroli(WYNIK_NEGATYWNY);
            podsumowanieRaportu.setKontroleAtrybutowe(WYNIK_KONTROLI_NEGATYWNY);
        }
    }

    private void okreslWynikWalidacjiDlaPliku(String plik, Wynik wynik, Podsumowanie podsumowanieRaportu) {
        WalidacjaZeSchematem walidacjaZeSchematem = new WalidacjaZeSchematem();
        walidacjaZeSchematem.setStatusKontroli(STATUS_KONTROLI_PRZEPROWADZONO);
        wynik.setWalidacjaZeSchematem(walidacjaZeSchematem);
        this.statusWalidacji = !this.bledyWeryfikacjiService.czySaBledyWalidacji(plik) && this.poprawnaStruktura;
        Long liczbaBledowWalidacji = this.bledyWeryfikacjiService.pobierzLiczbeBledowWalidacji(plik);
        walidacjaZeSchematem.setLiczbaBledowWalidacji(liczbaBledowWalidacji);
        if (liczbaBledowWalidacji != null && liczbaBledowWalidacji <= 100L) {
            walidacjaZeSchematem.setWyswietlanychBledowWalidacji(liczbaBledowWalidacji);
        } else if (liczbaBledowWalidacji != null && liczbaBledowWalidacji > 100L) {
            walidacjaZeSchematem.setWyswietlanychBledowWalidacji(100L);
        }
        if (this.statusWalidacji) {
            walidacjaZeSchematem.setWynikKontroli(WYNIK_POZYTYWNY);
            podsumowanieRaportu.setWalidacjaZeSchematem(WYNIK_KONTROLI_POZYTYWNY);
        } else {
            walidacjaZeSchematem.setWynikKontroli(WYNIK_NEGATYWNY);
            podsumowanieRaportu.setWalidacjaZeSchematem(WYNIK_KONTROLI_NEGATYWNY);
            podsumowanieRaportu.setKontroleAtrybutowe(STATUS_KONTROLI_NIE_WYKONANO);
        }
    }

    public Wynik pobierzWynikiKontroli() {
        if (this.wynik == null) {
            this.okreslWynikiKontroli();
        }
        return this.wynik;
    }

    private void ustawNazwyAtrybutow(KontrolaAtrybutowa kontrolaAtrybutowa) {
        try {
            List<String> nazwyAtrybutow = this.bledyWeryfikacjiService.pobierzNazwyAtrybutowKontroli(kontrolaAtrybutowa.getId());
            kontrolaAtrybutowa.setAtrybut1Nazwa(nazwyAtrybutow.get(0));
            kontrolaAtrybutowa.setAtrybut2Nazwa(nazwyAtrybutow.get(1));
            kontrolaAtrybutowa.setAtrybut3Nazwa(nazwyAtrybutow.get(2));
        }
        catch (BladSQLException e) {
            log.error((Object)"Blad pobierania nazw atrybutow", (Throwable)e);
        }
    }

    public Wynik getWynik() {
        return this.wynik;
    }
}

