/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.raporty;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import pl.gov.gugik.gesut.dak.biz.service.handlery.ObslugaWyjatkowHandler;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.BledyWeryfikacjiService;
import pl.gov.gugik.gesut.dak.model.kontrole.BladKontroli;
import pl.gov.gugik.gesut.dak.model.raporty.Wynik;
import pl.gov.gugik.gesut.dak.model.walidacja.BladWalidacji;

public class RaportCSVService {
    private BledyWeryfikacjiService bledyWeryfikacjiService;
    private ObslugaWyjatkowHandler obslugaWyjatkowHandler;
    private static final Object[] NAGLOWEK_KONTROLI = new Object[]{"GrupaKontroli", "IdentyfikatorKontroli", "NazwaKontroli", "NazwaKlasy", "idIIP : lokalnyId", "GMLID", "Atrybut1_Nazwa", "Atrybut1_wartosc", "Atrybut2_Nazwa", "Atrybut2_wartosc", "Atrybut3_Nazwa", "Atrybut3_wartosc", "KomunikatBledu"};
    private static final Object[] NAGLOWEK_WALIDACJI = new Object[]{"GrupaKontroli", "IdentyfikatorKontroli", "NazwaKontroli", "KomunikatBledu"};

    public RaportCSVService(BledyWeryfikacjiService bledyWeryfikacjiService) {
        this(bledyWeryfikacjiService, new ObslugaWyjatkowHandler());
    }

    public RaportCSVService(BledyWeryfikacjiService bledyWeryfikacjiService, ObslugaWyjatkowHandler obslugaWyjatkowHandler) {
        this.bledyWeryfikacjiService = bledyWeryfikacjiService;
        this.obslugaWyjatkowHandler = obslugaWyjatkowHandler;
    }

    private List<String> tworzRekordCSVKontroli(BladKontroli bladKontroli) {
        ArrayList<String> rekord = new ArrayList<String>();
        rekord.add(bladKontroli.getGrupaKontroli());
        rekord.add(bladKontroli.getIdKont());
        rekord.add(bladKontroli.getNazwaKontroli());
        rekord.add(bladKontroli.getKlasa());
        rekord.add(bladKontroli.getIdLokalne());
        rekord.add(bladKontroli.getGmlId());
        rekord.add(bladKontroli.getAttr1Naz());
        rekord.add(bladKontroli.getAttr1Wart());
        rekord.add(bladKontroli.getAttr2Naz());
        rekord.add(bladKontroli.getAttr2Wart());
        rekord.add(bladKontroli.getAttr3Naz());
        rekord.add(bladKontroli.getAttr3Wart());
        rekord.add(bladKontroli.getKomunikat());
        return rekord;
    }

    private List<String> tworzRekordCSVWalidacji(BladWalidacji bladWalidacji) {
        ArrayList<String> rekord = new ArrayList<String>();
        rekord.add("Walidacja");
        rekord.add("W_01");
        rekord.add("Walidacja");
        String komunikat = "LINIA: " + bladWalidacji.getLinia() + ": " + bladWalidacji.getKomunikat();
        rekord.add(komunikat);
        return rekord;
    }

    private void dopiszBladKontroli(CSVPrinter printer, BladKontroli bladKontroli) {
        if (bladKontroli == null) {
            return;
        }
        try {
            printer.printRecord(this.tworzRekordCSVKontroli(bladKontroli));
        }
        catch (IOException e) {
            this.obslugaWyjatkowHandler.dodajWyjatek(e);
        }
    }

    private void dopiszBladWalidacji(CSVPrinter printer, BladWalidacji bladWalidacji) {
        if (bladWalidacji == null) {
            return;
        }
        try {
            printer.printRecord(this.tworzRekordCSVWalidacji(bladWalidacji));
        }
        catch (IOException e) {
            this.obslugaWyjatkowHandler.dodajWyjatek(e);
        }
    }

    public void dodajBledyKontroli(CSVPrinter printer, Wynik wynik) throws IOException {
        printer.printRecord(NAGLOWEK_KONTROLI);
        this.bledyWeryfikacjiService.pobierzIteratorBledowKontroli(wynik.getNazwaPliku(), null, false).forEachRemaining(bladKontroli -> this.dopiszBladKontroli(printer, (BladKontroli)bladKontroli));
    }

    public void dodajBledyWalidacji(CSVPrinter printer, Wynik wynik) throws IOException {
        printer.printRecord(NAGLOWEK_WALIDACJI);
        this.bledyWeryfikacjiService.pobierzIteratorBledowWalidacji(wynik.getNazwaPliku(), false).forEachRemaining(bladWalidacji -> this.dopiszBladWalidacji(printer, (BladWalidacji)bladWalidacji));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generujCsv(Wynik wynik, Writer writer) {
        CSVFormat csvFileFormat = CSVFormat.DEFAULT.withDelimiter(';');
        try {
            writer.write("\ufeff");
            CSVPrinter printer = new CSVPrinter((Appendable)writer, csvFileFormat);
            if (wynik.getWalidacjaZeSchematem().getLiczbaBledowWalidacji() > 0L) {
                this.dodajBledyWalidacji(printer, wynik);
            } else if (!wynik.getPodsumowanie().getKontroleAtrybutowe().equalsIgnoreCase("Nie wykonano")) {
                this.dodajBledyKontroli(printer, wynik);
            } else {
                printer.printRecord(NAGLOWEK_WALIDACJI);
            }
        }
        catch (IOException e) {
            this.obslugaWyjatkowHandler.dodajWyjatek(e);
        }
        finally {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                this.obslugaWyjatkowHandler.dodajWyjatek(e);
            }
        }
    }

    public void generujCsv(String nazwaPliku, Wynik wynik) {
        try {
            this.generujCsv(wynik, new OutputStreamWriter(new FileOutputStream(nazwaPliku)));
        }
        catch (FileNotFoundException e) {
            this.obslugaWyjatkowHandler.dodajWyjatek(e);
        }
    }
}

