/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.utils;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javafx.stage.Window;
import pl.gov.gugik.gesut.dak.biz.conf.Konfiguracja;
import pl.gov.gugik.gesut.dak.biz.service.pliki.WskazLokalizacjeService;
import pl.gov.gugik.gesut.dak.biz.utils.KomunikatyUtils;
import pl.gov.gugik.gesut.dak.model.kontrole.OgolneParametryKontroli;

public class WalidatorWejsciowyUtils {
    private static final String BUNDLE_BRAK_MOZLIWOSCI_ZAPISU_PLIKU_PRZEZ_SYSTEM = "kontrole.bledy.brakMozliwosciZapisuPlikuPrzezSystem";
    private static final String BUNDLE_NIE_WYBRANO_SPOSOBU_WERYFIKACJI_ZBIORU_DANYCH = "kontrole.bledy.nieWybranoSposobuWeryfikacjiZbioruDanych";
    private static final String BUNDLE_PROCES_ZOSTANIE_PRZERWANY = "kontrole.bledy.procesZostaniePrzerwany";
    private static final String BUNDLE_NIE_WSKAZANO_NIEZBEDNYCH_SCIEZEK = "kontrole.bledy.nieWskazanoNiezbednychSciezek";
    private static final String BUNDLE_LOKALIZACJA_DLA_WYGENEROWANYCH_RAPORTOW = "lokalizacjaDlaWygenerowanychRaportow";
    private static final String BUNDLE_SZABLON_KONTROLI_WERYFIKACJI = "szablonKontroliWeryfikacji";
    private static final String BUNDLE_SCHEMATY_APLIKACYJNE_XSD = "schematyAplikacyjneXsd";
    private static final String BUNDLE_NIE_WSKAZANO_CONAJMNIEJ_JEDNEGO_PLIKU = "nieWskazanoConajmniejJednegoPlikuDoWeryfikacji";

    public static Boolean walidujDaneWejsiowe(OgolneParametryKontroli parametryKontroli, Window okno) {
        StringBuilder komunikatyBledow = new StringBuilder();
        ArrayList<String> bledySciezkiPlikow = new ArrayList<String>();
        if (parametryKontroli.getPlikiDoKontroli().isEmpty()) {
            WalidatorWejsciowyUtils.dodajKomunikatBledu(komunikatyBledow, Konfiguracja.getBundle().getString(BUNDLE_NIE_WSKAZANO_CONAJMNIEJ_JEDNEGO_PLIKU));
            KomunikatyUtils.wyswietlKomunikatBledowWalidacji(komunikatyBledow.toString(), okno);
            return false;
        }
        if (parametryKontroli.getSciezkaDoSchematuAplikacyjnego() == null) {
            bledySciezkiPlikow.add(Konfiguracja.getBundle().getString(BUNDLE_SCHEMATY_APLIKACYJNE_XSD));
        }
        if (parametryKontroli.isCzyKontroleAtrybutowe() && parametryKontroli.getSciezkaDoSzablonuKontroli() == null) {
            bledySciezkiPlikow.add(Konfiguracja.getBundle().getString(BUNDLE_SZABLON_KONTROLI_WERYFIKACJI));
        }
        if (parametryKontroli.getSciezkaWybranegoFolderuRaportow() == null) {
            bledySciezkiPlikow.add(Konfiguracja.getBundle().getString(BUNDLE_LOKALIZACJA_DLA_WYGENEROWANYCH_RAPORTOW));
        }
        if (!bledySciezkiPlikow.isEmpty()) {
            WalidatorWejsciowyUtils.dodajKomunikatBledu(komunikatyBledow, Konfiguracja.getBundle().getString(BUNDLE_NIE_WSKAZANO_NIEZBEDNYCH_SCIEZEK) + bledySciezkiPlikow.stream().collect(Collectors.joining(", ")) + Konfiguracja.getBundle().getString(BUNDLE_PROCES_ZOSTANIE_PRZERWANY));
            KomunikatyUtils.wyswietlKomunikatBledowWalidacji(komunikatyBledow.toString(), okno);
            return false;
        }
        if (!parametryKontroli.czyWalidacjaProperty().getValue().booleanValue() && !parametryKontroli.czyKontroleAtrybutoweProperty().getValue().booleanValue()) {
            WalidatorWejsciowyUtils.dodajKomunikatBledu(komunikatyBledow, Konfiguracja.getBundle().getString(BUNDLE_NIE_WYBRANO_SPOSOBU_WERYFIKACJI_ZBIORU_DANYCH));
            KomunikatyUtils.wyswietlKomunikatBledowWalidacji(komunikatyBledow.toString(), okno);
            return false;
        }
        if (!Strings.isNullOrEmpty((String)parametryKontroli.getSciezkaWybranegoFolderuRaportow()) && !WskazLokalizacjeService.czyMoznaZapisacPlikWFolderze(parametryKontroli.getSciezkaWybranegoFolderuRaportow())) {
            WalidatorWejsciowyUtils.dodajKomunikatBledu(komunikatyBledow, Konfiguracja.getBundle().getString(BUNDLE_BRAK_MOZLIWOSCI_ZAPISU_PLIKU_PRZEZ_SYSTEM));
            KomunikatyUtils.wyswietlKomunikatBledowWalidacji(komunikatyBledow.toString(), okno);
            return false;
        }
        return true;
    }

    private static void dodajKomunikatBledu(StringBuilder komunikatyBledow, String komunikat) {
        komunikatyBledow.append(komunikat).append(System.lineSeparator());
    }
}

