/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.utils.parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stax.StAXSource;
import org.joox.JOOX;
import org.w3c.dom.Node;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.BladParsowaniaXMLException;
import pl.gov.gugik.gesut.dak.biz.utils.parser.procesory.TagProcesor;

public class DomStaxParser {
    private Transformer t;
    private List<TagProcesor> procesory = new ArrayList<TagProcesor>();
    private DOMResult currentDomResult = null;

    public void parsuj(String plikDoPrzetworzenia) throws FileNotFoundException, XMLStreamException, TransformerException {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        XMLStreamReader reader = factory.createXMLStreamReader(new FileInputStream(plikDoPrzetworzenia));
        TransformerFactory tf = TransformerFactory.newInstance();
        this.t = tf.newTransformer();
        while (reader.hasNext()) {
            int event = reader.next();
            if (event != 1 && event != 2) continue;
            String tagName = reader.getLocalName();
            this.currentDomResult = null;
            for (TagProcesor procesor : this.procesory) {
                if (event != procesor.getEvent() || !tagName.equals(procesor.getTagName())) continue;
                try {
                    if (this.currentDomResult == null) {
                        this.currentDomResult = this.konwertujNaDOM(reader);
                    }
                    if (procesor.isCzyPrzetwarzacWezelDOM()) {
                        procesor.przetworz(JOOX.$((Node)this.currentDomResult.getNode()).child(0), plikDoPrzetworzenia);
                        continue;
                    }
                    procesor.przetworz(null, null);
                }
                catch (TransformerException e) {
                    throw new BladParsowaniaXMLException(e.getMessage(), e);
                }
            }
            this.currentDomResult = null;
        }
    }

    private DOMResult konwertujNaDOM(XMLStreamReader reader) throws TransformerException {
        DOMResult domResult = new DOMResult();
        this.t.transform(new StAXSource(reader), domResult);
        return domResult;
    }

    public void dodajProcesor(TagProcesor tagProcesor) {
        this.procesory.add(tagProcesor);
    }

    public void usunProcesory() {
        this.procesory.clear();
    }
}

