/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.utils.walidacja.handlery;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.BledyWeryfikacjiService;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;
import pl.gov.gugik.gesut.dak.dao.wyjatki.BladSQLException;
import pl.gov.gugik.gesut.dak.model.walidacja.BladWalidacji;

public class DziennikHandler
implements ErrorHandler {
    private final BledyWeryfikacjiService bledyWeryfikacjiService;
    private String nazwaPliku;
    private boolean poprawny = true;

    public DziennikHandler(BledyWeryfikacjiService bledyWeryfikacjiService, String nazwaPliku) {
        this.bledyWeryfikacjiService = bledyWeryfikacjiService;
        this.nazwaPliku = nazwaPliku;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.dodajBladWalidacji(e.getLineNumber(), "W", e.getMessage());
        this.poprawny = false;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.dodajBladWalidacji(e.getLineNumber(), "E", e.getMessage());
        this.poprawny = false;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.dodajBladWalidacji(e.getLineNumber(), "F", e.getMessage());
        this.poprawny = false;
    }

    private void dodajBladWalidacji(int linia, String typ, String komunikat) {
        BladWalidacji bladWalidacji = BladWalidacji.builder().linia(linia).komunikat(komunikat).typ(typ).nazwaPliku(this.nazwaPliku).build();
        try {
            this.bledyWeryfikacjiService.zapiszBledyWalidacji(bladWalidacji);
        }
        catch (BladSQLException e) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
        }
    }

    public boolean isPoprawny() {
        return this.poprawny;
    }
}

