/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.dao;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import pl.gov.gugik.gesut.dak.biz.service.pliki.PlikiTymczasoweService;
import pl.gov.gugik.gesut.dak.dao.BledyKontroliTable;
import pl.gov.gugik.gesut.dak.dao.BledyWalidacjiTable;
import pl.gov.gugik.gesut.dak.dao.ResultSetIterator;
import pl.gov.gugik.gesut.dak.dao.wyjatki.BladSQLException;
import pl.gov.gugik.gesut.dak.model.kontrole.BladKontroli;
import pl.gov.gugik.gesut.dak.model.walidacja.BladWalidacji;

public class BledyWeryfikacjiDAO {
    private static final Logger log = Logger.getLogger(BledyWeryfikacjiDAO.class);
    private static final String DB_URL = "jdbc:sqlite:";
    private static final String RUN_VACUUM_QUERY = "PRAGMA auto_vacuum = FULL;";
    private static final String DROP_TABLE_QUERY = "drop table if exists %s";
    private static final String TRUNCATE_TABLE_QUERY = "delete from %s; vacuum;";
    private String dbPath;
    private Connection connection;
    private Statement statement;
    private BledyKontroliTable bledyKontroli;
    private BledyWalidacjiTable bledyWalidacji;

    public BledyWeryfikacjiDAO() throws BladSQLException {
        try {
            this.dbPath = PlikiTymczasoweService.pobierzInstancje().pobierzKatalogTymczasowy() + File.separator + "dak_" + UUID.randomUUID() + ".db";
            PlikiTymczasoweService.pobierzInstancje().zarejestrujPlikTymczasowy(new File(this.dbPath));
            this.connection = DriverManager.getConnection(DB_URL + this.dbPath);
            this.connection.setAutoCommit(false);
            this.statement = this.connection.createStatement();
            this.statement.execute(RUN_VACUUM_QUERY);
            this.bledyKontroli = new BledyKontroliTable(this.connection, this.statement);
            this.bledyWalidacji = new BledyWalidacjiTable(this.connection, this.statement);
            this.dropTableIfExists();
            this.createTable();
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas polaczenia z baza danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas polaczenia z baza danych", e);
        }
    }

    public int pobierzLiczbeBledowKontroli(String plik, String idKontroli) throws BladSQLException {
        return this.bledyKontroli.pobierzLiczbeBledowKontroli(plik, idKontroli);
    }

    public ResultSetIterator<BladKontroli> pobierzIteratorBledowKontroli(String plik, String idKontroli, boolean max10) throws BladSQLException {
        return this.bledyKontroli.pobierzIteratorBledowKontroli(plik, idKontroli, max10);
    }

    public boolean czySaBledyWalidacji(String nazwaPliku) throws BladSQLException {
        return this.bledyWalidacji.czySaBledyWalidacji(nazwaPliku);
    }

    public Long pobierzLiczbeBledowWalidacji(String nazwaPliku) throws BladSQLException {
        return this.bledyWalidacji.pobierzLiczbeDlaPliku(nazwaPliku);
    }

    public ResultSetIterator<BladWalidacji> pobierzIteratorBledowWalidacji(String nazwaPliku, boolean max100) throws BladSQLException {
        return this.bledyWalidacji.pobierzDlaPliku(nazwaPliku, max100);
    }

    public void zapiszBledyWalidacji(List<BladWalidacji> lista) throws BladSQLException {
        this.bledyWalidacji.save(lista);
    }

    public void zapiszBladWalidacji(BladWalidacji blad) throws BladSQLException {
        this.bledyWalidacji.save(blad);
    }

    public void zapiszBledyKontroli(List<BladKontroli> lista) throws BladSQLException {
        this.bledyKontroli.save(lista);
    }

    public void zapiszBladKontroli(BladKontroli blad) throws BladSQLException {
        this.bledyKontroli.save(blad);
    }

    public void truncate() throws SQLException {
        this.statement.execute(String.format(TRUNCATE_TABLE_QUERY, "blad_walidacji"));
        this.statement.execute(String.format(TRUNCATE_TABLE_QUERY, "blad_kontroli"));
        this.connection.commit();
    }

    public void close() throws BladSQLException {
        try {
            this.dropTableIfExists();
            this.statement.close();
            this.connection.close();
            new File(this.dbPath).delete();
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas czyszczenia bazy danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas czyszczenia bazy danych", e);
        }
    }

    private void createTable() throws SQLException {
        String query = "create table blad_kontroli ( " + this.bledyKontroli.getKolumnyBledowKontroliBezRowId().stream().map(c -> c + " text").collect(Collectors.joining(", ")) + ");";
        this.statement.execute(query);
        this.connection.commit();
        query = "create table blad_walidacji ( nazwa_pliku text, typ char, linia integer, komunikat text );";
        this.statement.execute(query);
        this.connection.commit();
    }

    private void dropTableIfExists() throws SQLException {
        this.statement.execute(String.format(DROP_TABLE_QUERY, "blad_kontroli"));
        this.connection.commit();
        this.statement.execute(String.format(DROP_TABLE_QUERY, "blad_walidacji"));
        this.connection.commit();
    }

    public List<String> pobierzNazwyAtrybutowKontroli(String idKontroli) throws BladSQLException {
        try {
            String query = "select atr1_naz, atr2_naz, atr3_naz from blad_kontroli where id_kont =?  limit 1;";
            PreparedStatement preparedStatement = this.connection.prepareStatement(query);
            preparedStatement.setString(1, idKontroli);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<String> result = new ArrayList<String>();
            result.add(resultSet.getString(1));
            result.add(resultSet.getString(2));
            result.add(resultSet.getString(3));
            resultSet.close();
            return result;
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas wyszukiwania: ", (Throwable)e);
            throw new BladSQLException("Blad podczas wyszukiwania", e);
        }
    }
}

