/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.kontrolery;

import java.nio.file.Paths;
import java.util.List;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javafx.stage.Window;
import pl.gov.gugik.gesut.dak.Aplikacja;
import pl.gov.gugik.gesut.dak.biz.conf.Konfiguracja;
import pl.gov.gugik.gesut.dak.biz.service.pliki.WskazLokalizacjeService;
import pl.gov.gugik.gesut.dak.biz.utils.KomunikatyUtils;
import pl.gov.gugik.gesut.dak.enumy.RodzajPlikuEnum;
import pl.gov.gugik.gesut.dak.model.kontrole.ParametryKontroliPliku;

public abstract class BazowyController {
    private static final String BUNDLE_NIEPOPRAWNE_DANE_WEJSCIOWE = "kontrole.bledy.niepoprawneDaneWejsciowe";
    private static final String BUNDLE_PRZEKROCZONO_LIMIT_PLIKOW = "kontrole.bledy.przekroczonoLimitPlikow";
    protected Aplikacja aplikacja;
    protected Window okno;
    protected ResourceBundle bundle = Konfiguracja.getBundle();

    public void ustawAplikacje(Aplikacja aplikacja) {
        this.aplikacja = aplikacja;
    }

    public void setOkno(Window okno) {
        this.okno = okno;
    }

    public abstract void inicjujKontroler();

    public void wyswietlWyborPlikowDoKontroli() {
        this.wybierzPlikiDoKontroli(this.aplikacja.getParametryKontroli().sciezkaDoOstatniegoFolderuPlikowDoKontroliProperty().getValue());
    }

    public void wyswietlWyborSzablonuKontroli() {
        this.wybierzPlik(RodzajPlikuEnum.SZABLON_KONTROLI, this.aplikacja.getParametryKontroli().sciezkaDoSzablonuKontroliProperty().getValue());
    }

    public void wyswietlWyborSchematuAplikacyjnego() {
        this.wybierzPlik(RodzajPlikuEnum.SCHEMAT_APLIKACYJNY, this.aplikacja.getParametryKontroli().sciezkaDoSchematuAplikacyjnegoProperty().getValue());
    }

    private ParametryKontroliPliku stworzPlikDoKontroli(String sciezka) {
        ParametryKontroliPliku parametryPliku = new ParametryKontroliPliku();
        parametryPliku.sciezkaPlikuDoKontroliProperty().setValue(sciezka);
        return parametryPliku;
    }

    private void wybierzPlikiDoKontroli(String sciezkaPoczatkowa) {
        List<String> sciezki = WskazLokalizacjeService.pobierzSciezkiPlikowGml(this.okno, sciezkaPoczatkowa);
        if (sciezki != null && sciezki.size() > 15) {
            this.zapiszWPreferencjach(RodzajPlikuEnum.FOLDER_PLIOW_DO_KONTROLI, Paths.get(sciezki.get(0), new String[0]).getParent().toString());
            this.aplikacja.getParametryKontroli().getPlikiDoKontroli().clear();
            this.aplikacja.getParametryKontroli().komunikatPlikuDoKontroliProperty().set((Object)this.zwrocKomunikatPlikowDoKontroli());
            KomunikatyUtils.budujIWyswietlAlertBleduWalidacji(this.bundle.getString(BUNDLE_NIEPOPRAWNE_DANE_WEJSCIOWE), this.bundle.getString(BUNDLE_PRZEKROCZONO_LIMIT_PLIKOW));
        } else if (sciezki != null) {
            this.aplikacja.getParametryKontroli().getPlikiDoKontroli().clear();
            sciezki.forEach(s -> this.aplikacja.getParametryKontroli().getPlikiDoKontroli().add(this.stworzPlikDoKontroli((String)s)));
            this.aplikacja.getParametryKontroli().komunikatPlikuDoKontroliProperty().set((Object)this.zwrocKomunikatPlikowDoKontroli());
            this.zapiszWPreferencjach(RodzajPlikuEnum.FOLDER_PLIOW_DO_KONTROLI, Paths.get(sciezki.get(0), new String[0]).getParent().toString());
        }
    }

    protected void wybierzPlik(RodzajPlikuEnum rodzajpliku, String sciezkaPoczatkowa) {
        String sciezka = WskazLokalizacjeService.pobierzSciezkePliku(this.okno, rodzajpliku, sciezkaPoczatkowa);
        if (sciezka != null) {
            switch (rodzajpliku) {
                case SZABLON_KONTROLI: {
                    this.aplikacja.getParametryKontroli().sciezkaDoSzablonuKontroliProperty().setValue(sciezka);
                    this.zapiszWPreferencjach(RodzajPlikuEnum.SZABLON_KONTROLI, sciezka);
                    break;
                }
                case SCHEMAT_APLIKACYJNY: {
                    this.aplikacja.getParametryKontroli().sciezkaDoSchematuAplikacyjnegoProperty().setValue(sciezka);
                    this.zapiszWPreferencjach(RodzajPlikuEnum.SCHEMAT_APLIKACYJNY, sciezka);
                }
            }
        }
    }

    private void zapiszWPreferencjach(RodzajPlikuEnum rodzajPliku, String sciezka) {
        Preferences preferencje = Preferences.userNodeForPackage(Aplikacja.class);
        preferencje.put(rodzajPliku.getWartosc(), sciezka);
        if (rodzajPliku == RodzajPlikuEnum.FOLDER_PLIOW_DO_KONTROLI) {
            this.aplikacja.getParametryKontroli().sciezkaDoOstatniegoFolderuPlikowDoKontroliProperty().set((Object)sciezka);
        }
    }

    protected void pobierzSciezkeFolderu(RodzajPlikuEnum rodzajpliku, String sciezkaPoczatkowa) {
        String sciezka = WskazLokalizacjeService.pobierzSciezkeFolderu(this.okno, rodzajpliku, sciezkaPoczatkowa);
        if (sciezka != null) {
            this.aplikacja.getParametryKontroli().sciezkaDoOstatniegoFolderuRaportowProperty().setValue(sciezka);
            this.aplikacja.getParametryKontroli().sciezkaWybranegoFolderuRaportowProperty().setValue(sciezka);
            this.zapiszWPreferencjach(RodzajPlikuEnum.FOLDER_DO_RAPORTU, sciezka);
        }
    }

    private String zwrocKomunikatPlikowDoKontroli() {
        return !this.aplikacja.getParametryKontroli().getPlikiDoKontroli().isEmpty() ? KomunikatyUtils.zwrocPosortowanaListePlikow(this.aplikacja.getParametryKontroli().getPlikiDoKontroli()) : null;
    }
}

