/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.kontrolery.komponenty;

import java.io.IOException;
import java.net.URISyntaxException;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.apache.log4j.Logger;

public class AlertDialog {
    private static final Logger log = Logger.getLogger(AlertDialog.class);
    private static final String INFO_ICON = "/com/sun/javafx/scene/control/skin/modena/dialog-information.png";
    private static final String ERROR_ICON = "/com/sun/javafx/scene/control/skin/modena/dialog-error.png";
    @FXML
    private ImageView imageView;
    @FXML
    private Label headerText;
    @FXML
    private Label contentText;
    private Stage stage;

    public AlertDialog(Type typ, String title, String header, String content, String icon) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/alert_dialog.fxml"));
            loader.setController((Object)this);
            AnchorPane panel = (AnchorPane)loader.load();
            this.stage = new Stage();
            Image image = new Image(icon);
            this.stage.getIcons().add((Object)image);
            Scene scene = new Scene((Parent)panel);
            this.stage.setScene(scene);
            this.stage.initModality(Modality.APPLICATION_MODAL);
            this.setGraphic(typ);
            this.initialize(title, header, content, typ);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public void showAndWait() {
        this.stage.showAndWait();
    }

    private void initialize(String title, String header, String content, Type typ) {
        this.stage.setTitle(title);
        this.headerText.setText(header);
        this.contentText.setText(content);
        this.stage.setResizable(false);
        this.setGraphic(typ);
    }

    private void setGraphic(Type typ) {
        try {
            this.imageView.setImage(new Image(this.getClass().getResource(typ.getPath()).toURI().toString()));
        }
        catch (URISyntaxException e) {
            log.error((Object)"Blad ustawiania grafiki", (Throwable)e);
        }
    }

    public void close() {
        this.stage.close();
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public static enum Type {
        INFO("/com/sun/javafx/scene/control/skin/modena/dialog-information.png"),
        ERROR("/com/sun/javafx/scene/control/skin/modena/dialog-error.png");

        private String path;

        private Type(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

