/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.InnerClass;
import com.sun.org.apache.bcel.internal.classfile.InnerClasses;
import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.Class2HTML;
import com.sun.org.apache.bcel.internal.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

final class AttributeHTML
implements Constants {
    private String class_name;
    private PrintWriter file;
    private int attr_count = 0;
    private ConstantHTML constant_html;
    private ConstantPool constant_pool;

    AttributeHTML(String string, String string2, ConstantPool constantPool, ConstantHTML constantHTML) throws IOException {
        this.class_name = string2;
        this.constant_pool = constantPool;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_attributes.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
    }

    private final String codeLink(int n, int n2) {
        return "<A HREF=\"" + this.class_name + "_code.html#code" + n2 + "@" + n + "\" TARGET=Code>" + n + "</A>";
    }

    final void close() {
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    final void writeAttribute(Attribute attribute, String string) throws IOException {
        this.writeAttribute(attribute, string, 0);
    }

    final void writeAttribute(Attribute attribute, String string, int n) throws IOException {
        byte by = attribute.getTag();
        if (by == -1) {
            return;
        }
        ++this.attr_count;
        if (this.attr_count % 2 == 0) {
            this.file.print("<TR BGCOLOR=\"#C0C0C0\"><TD>");
        } else {
            this.file.print("<TR BGCOLOR=\"#A0A0A0\"><TD>");
        }
        this.file.println("<H4><A NAME=\"" + string + "\">" + this.attr_count + " " + ATTRIBUTE_NAMES[by] + "</A></H4>");
        switch (by) {
            case 2: {
                Code code = (Code)attribute;
                this.file.print("<UL><LI>Maximum stack size = " + code.getMaxStack() + "</LI>\n<LI>Number of local variables = " + code.getMaxLocals() + "</LI>\n<LI><A HREF=\"" + this.class_name + "_code.html#method" + n + "\" TARGET=Code>Byte code</A></LI></UL>\n");
                CodeException[] codeExceptionArray = code.getExceptionTable();
                int n2 = codeExceptionArray.length;
                if (n2 <= 0) break;
                this.file.print("<P><B>Exceptions handled</B><UL>");
                for (int i = 0; i < n2; ++i) {
                    int n3 = codeExceptionArray[i].getCatchType();
                    this.file.print("<LI>");
                    if (n3 != 0) {
                        this.file.print(this.constant_html.referenceConstant(n3));
                    } else {
                        this.file.print("Any Exception");
                    }
                    this.file.print("<BR>(Ranging from lines " + this.codeLink(codeExceptionArray[i].getStartPC(), n) + " to " + this.codeLink(codeExceptionArray[i].getEndPC(), n) + ", handled at line " + this.codeLink(codeExceptionArray[i].getHandlerPC(), n) + ")</LI>");
                }
                this.file.print("</UL>");
                break;
            }
            case 1: {
                int n4 = ((ConstantValue)attribute).getConstantValueIndex();
                this.file.print("<UL><LI><A HREF=\"" + this.class_name + "_cp.html#cp" + n4 + "\" TARGET=\"ConstantPool\">Constant value index(" + n4 + ")</A></UL>\n");
                break;
            }
            case 0: {
                int n5 = ((SourceFile)attribute).getSourceFileIndex();
                this.file.print("<UL><LI><A HREF=\"" + this.class_name + "_cp.html#cp" + n5 + "\" TARGET=\"ConstantPool\">Source file index(" + n5 + ")</A></UL>\n");
                break;
            }
            case 3: {
                int[] nArray = ((ExceptionTable)attribute).getExceptionIndexTable();
                this.file.print("<UL>");
                for (int i = 0; i < nArray.length; ++i) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_cp.html#cp" + nArray[i] + "\" TARGET=\"ConstantPool\">Exception class index(" + nArray[i] + ")</A>\n");
                }
                this.file.print("</UL>\n");
                break;
            }
            case 4: {
                LineNumber[] lineNumberArray = ((LineNumberTable)attribute).getLineNumberTable();
                this.file.print("<P>");
                for (int i = 0; i < lineNumberArray.length; ++i) {
                    this.file.print("(" + lineNumberArray[i].getStartPC() + ",&nbsp;" + lineNumberArray[i].getLineNumber() + ")");
                    if (i >= lineNumberArray.length - 1) continue;
                    this.file.print(", ");
                }
                break;
            }
            case 5: {
                LocalVariable[] localVariableArray = ((LocalVariableTable)attribute).getLocalVariableTable();
                this.file.print("<UL>");
                for (int i = 0; i < localVariableArray.length; ++i) {
                    int n6 = localVariableArray[i].getSignatureIndex();
                    String string2 = ((ConstantUtf8)this.constant_pool.getConstant(n6, (byte)1)).getBytes();
                    string2 = Utility.signatureToString(string2, false);
                    int n7 = localVariableArray[i].getStartPC();
                    int n8 = n7 + localVariableArray[i].getLength();
                    this.file.println("<LI>" + Class2HTML.referenceType(string2) + "&nbsp;<B>" + localVariableArray[i].getName() + "</B> in slot %" + localVariableArray[i].getIndex() + "<BR>Valid from lines <A HREF=\"" + this.class_name + "_code.html#code" + n + "@" + n7 + "\" TARGET=Code>" + n7 + "</A> to <A HREF=\"" + this.class_name + "_code.html#code" + n + "@" + n8 + "\" TARGET=Code>" + n8 + "</A></LI>");
                }
                this.file.print("</UL>\n");
                break;
            }
            case 6: {
                InnerClass[] innerClassArray = ((InnerClasses)attribute).getInnerClasses();
                this.file.print("<UL>");
                for (int i = 0; i < innerClassArray.length; ++i) {
                    int n9 = innerClassArray[i].getInnerNameIndex();
                    String string3 = n9 > 0 ? ((ConstantUtf8)this.constant_pool.getConstant(n9, (byte)1)).getBytes() : "&lt;anonymous&gt;";
                    String string4 = Utility.accessToString(innerClassArray[i].getInnerAccessFlags());
                    this.file.print("<LI><FONT COLOR=\"#FF0000\">" + string4 + "</FONT> " + this.constant_html.referenceConstant(innerClassArray[i].getInnerClassIndex()) + " in&nbsp;class " + this.constant_html.referenceConstant(innerClassArray[i].getOuterClassIndex()) + " named " + string3 + "</LI>\n");
                }
                this.file.print("</UL>\n");
                break;
            }
            default: {
                this.file.print("<P>" + attribute.toString());
            }
        }
        this.file.println("</TD></TR>");
        this.file.flush();
    }
}

