/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import com.sun.xml.internal.org.jvnet.mimepull.CleanUpExecutorFactory;
import com.sun.xml.internal.org.jvnet.mimepull.DataFile;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEParsingException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

final class WeakDataFile
extends WeakReference<DataFile> {
    private static final Logger LOGGER = Logger.getLogger(WeakDataFile.class.getName());
    private static ReferenceQueue<DataFile> refQueue = new ReferenceQueue();
    private static List<WeakDataFile> refList = new ArrayList<WeakDataFile>();
    private final File file;
    private final RandomAccessFile raf;
    private static boolean hasCleanUpExecutor = false;

    WeakDataFile(DataFile dataFile, File file) {
        super(dataFile, refQueue);
        refList.add(this);
        this.file = file;
        try {
            this.raf = new RandomAccessFile(file, "rw");
        }
        catch (IOException iOException) {
            throw new MIMEParsingException(iOException);
        }
        if (!hasCleanUpExecutor) {
            WeakDataFile.drainRefQueueBounded();
        }
    }

    synchronized void read(long l, byte[] byArray, int n, int n2) {
        try {
            this.raf.seek(l);
            this.raf.readFully(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new MIMEParsingException(iOException);
        }
    }

    synchronized long writeTo(long l, byte[] byArray, int n, int n2) {
        try {
            this.raf.seek(l);
            this.raf.write(byArray, n, n2);
            return this.raf.getFilePointer();
        }
        catch (IOException iOException) {
            throw new MIMEParsingException(iOException);
        }
    }

    void close() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Deleting file = {0}", this.file.getName());
        }
        refList.remove(this);
        try {
            this.raf.close();
            boolean bl = this.file.delete();
            if (!bl && LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "File {0} was not deleted", this.file.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            throw new MIMEParsingException(iOException);
        }
    }

    void renameTo(File file) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Moving file={0} to={1}", new Object[]{this.file, file});
        }
        refList.remove(this);
        try {
            this.raf.close();
            boolean bl = this.file.renameTo(file);
            if (!bl && LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "File {0} was not moved to {1}", new Object[]{this.file.getAbsolutePath(), file.getAbsolutePath()});
            }
        }
        catch (IOException iOException) {
            throw new MIMEParsingException(iOException);
        }
    }

    static void drainRefQueueBounded() {
        WeakDataFile weakDataFile;
        while ((weakDataFile = (WeakDataFile)refQueue.poll()) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Cleaning file = {0} from reference queue.", weakDataFile.file);
            }
            weakDataFile.close();
        }
    }

    static {
        CleanUpExecutorFactory cleanUpExecutorFactory = CleanUpExecutorFactory.newInstance();
        if (cleanUpExecutorFactory != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Initializing clean up executor for MIMEPULL: {0}", cleanUpExecutorFactory.getClass().getName());
            }
            Executor executor = cleanUpExecutorFactory.getExecutor();
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                WeakDataFile weakDataFile = (WeakDataFile)refQueue.remove();
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.log(Level.FINE, "Cleaning file = {0} from reference queue.", weakDataFile.file);
                                }
                                weakDataFile.close();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            });
            hasCleanUpExecutor = true;
        }
    }
}

