<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output method="xml"
                indent="yes"/>
    <xsl:variable name="liczbaLiterDoSpacji"
                  select="3"/>
    <xsl:attribute-set name="headerCellStyle">
        <xsl:attribute name="border">solid 0.3mm black</xsl:attribute>
        <xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
        <xsl:attribute name="text-align">center</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="font-size">10pt</xsl:attribute>
        <xsl:attribute name="display-align">after</xsl:attribute>
        <xsl:attribute name="padding-before">2pt</xsl:attribute>
        <xsl:attribute name="padding-after">2pt</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="cellStyle">
        <xsl:attribute name="padding">0.1cm</xsl:attribute>
        <xsl:attribute name="border">solid 0.1mm black</xsl:attribute>
        <xsl:attribute name="font-size">8pt</xsl:attribute>
    </xsl:attribute-set>
    <xsl:template match="/Wynik">
        <fo:root font-family="Arial, Times New Roman, Tahoma, Courier"
                 font-size="10pt">
            <fo:layout-master-set>
                <fo:simple-page-master master-name="A4_title"
                                       font-family="sans-serif"
                                       page-height="29.7cm"
                                       page-width="21cm"
                                       margin-top="2cm"
                                       margin-bottom="2cm"
                                       margin-left="2cm"
                                       margin-right="2cm">
                    <fo:region-body region-name="xsl-region-body"
                                    margin-bottom=".5in"
                                    margin-top=".50in"/>
                    <fo:region-before region-name="xsl-region-before"
                                      extent="5in"/>
                </fo:simple-page-master>
                <fo:simple-page-master master-name="A4"
                                       page-height="29.7cm"
                                       font-family="sans-serif"
                                       page-width="21cm"
                                       margin-top="2cm"
                                       margin-bottom="2cm"
                                       margin-left="2cm"
                                       margin-right="2cm">
                    <fo:region-body region-name="xsl-region-body"
                                    margin-bottom=".5in"
                                    margin-top=".50in"/>
                    <fo:region-before region-name="xsl-region-before"
                                      extent="5in"/>
                    <fo:region-after region-name="xsl-region-after"
                                     extent=".5in"/>
                </fo:simple-page-master>
                <fo:simple-page-master master-name="A4_poziomo"
                                       page-height="21cm"
                                       font-family="sans-serif"
                                       page-width="29.7cm"
                                       margin-top="2cm"
                                       margin-bottom="2cm"
                                       margin-left="2cm"
                                       margin-right="2cm">
                    <fo:region-body region-name="xsl-region-body"
                                    margin-bottom=".5in"
                                    margin-top=".50in"/>
                    <fo:region-before region-name="xsl-region-before"
                                      extent="5in"/>
                    <fo:region-after region-name="xsl-region-after"
                                     extent=".5in"/>
                </fo:simple-page-master>
                <fo:page-sequence-master master-name="Main">
                    <fo:single-page-master-reference master-reference="A4_title"/>
                    <fo:repeatable-page-master-reference master-reference="A4"/>
                </fo:page-sequence-master>
            </fo:layout-master-set>
            <fo:page-sequence master-reference="Main"
                              id="main">
                <fo:static-content flow-name="xsl-region-before">
                    <fo:block text-align="start"
                              color="grey"
                              font-size="9pt"
                              line-height="1em + 4pt">Desktopowa Aplikacja Kontrolna GESUT wersja&#160;<xsl:value-of
                            select="WersjaAplikacji"/>
                    </fo:block>
                </fo:static-content>
                <fo:static-content flow-name="xsl-region-after">
                    <fo:block text-align="end"
                              color="grey"
                              font-size="9pt"
                              line-height="1em + 4pt">strona&#160;<fo:page-number/>&#160;z
                        <fo:page-number-citation-last ref-id="main"/>
                    </fo:block>
                </fo:static-content>
                <fo:flow flow-name="xsl-region-body">
                    <fo:block text-align="center"
                              font-size="10pt"
                              margin-top="3cm">
                        <fo:block font-size="18pt"
                                  font-weight="bold">Raport z kontroli danych
                        </fo:block>
                        <fo:block font-size="14pt">Wynik kontroli:&#160;<xsl:value-of select="WynikOgolnyKontroli"/>
                        </fo:block>
                        <fo:block>Data wygenerowania raportu:&#160;<xsl:value-of select="DataWygenerowaniaRaportu"/>
                        </fo:block>
                        <xsl:if test="WersjaSzablonuWeryfikacji!=''">
                            <fo:block>Wersja szablonu weryfikacji:&#160;<xsl:value-of
                                    select="WersjaSzablonuWeryfikacji"/>
                            </fo:block>
                        </xsl:if>
                        <fo:block>Pełna nazwa pliku:&#160;<xsl:value-of select="NazwaPlikuBezSciezki"/>
                        </fo:block>
                    </fo:block>
                    <fo:block break-after="page"
                              space-before.optimum="4cm">
                        <fo:block font-weight="bold"
                                  font-size="14pt">Podsumowanie
                        </fo:block>
                        <fo:block margin-left="1cm">
                            <fo:block font-weight="bold">Lista kontroli:</fo:block>
                            <fo:block>
                                <fo:table table-layout="fixed"
                                          border-collapse="separate">
                                    <fo:table-column column-width="50%"/>
                                    <fo:table-column column-width="50%"/>
                                    <fo:table-body>
                                        <fo:table-row>
                                            <fo:table-cell>
                                                <fo:block>Walidacja ze schematem xsd:</fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell>
                                                <fo:block>
                                                    <xsl:value-of select="Podsumowanie/WalidacjaZeSchematem"/>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell>
                                                <fo:block>Kontrole atrybutowe:</fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell>
                                                <fo:block>
                                                    <xsl:value-of select="Podsumowanie/KontroleAtrybutowe"/>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </fo:block>
                        </fo:block>
                        <fo:block space-before.optimum="5cm">
                            <fo:block font-weight="bold">Zestawienie liczbowe kontroli elementarnych:</fo:block>
                            <fo:block font-size="10pt">
                                <fo:table table-layout="fixed"
                                          border-collapse="separate">
                                    <fo:table-column column-width="1.5cm"/>
                                    <fo:table-column column-width="8.5cm"/>
                                    <fo:table-column column-width="5cm"/>
                                    <fo:table-body>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="2">
                                                <fo:block>Wykonano</fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell text-align="right">
                                                <fo:block>
                                                    <xsl:value-of
                                                            select="Podsumowanie/ZestawienieLiczboweKontroli/Wykonano"/>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell>
                                                <fo:block/>
                                            </fo:table-cell>
                                            <fo:table-cell>
                                                <fo:block text-align="center">Pozytywny</fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell text-align="right">
                                                <fo:block>
                                                    <xsl:value-of
                                                            select="Podsumowanie/ZestawienieLiczboweKontroli/Pozytywne"/>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell>
                                                <fo:block/>
                                            </fo:table-cell>
                                            <fo:table-cell>
                                                <fo:block text-align="center">Negatywny</fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell>
                                                <fo:block text-align="right">
                                                    <xsl:value-of
                                                            select="Podsumowanie/ZestawienieLiczboweKontroli/Negatywne"/>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell>
                                                <fo:block/>
                                            </fo:table-cell>
                                            <fo:table-cell>
                                                <fo:block text-align="center">Wynik wymaga interpretacji administratora
                                                    Systemu Zarządzania K-GESUT
                                                </fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell display-align="after">
                                                <fo:block text-align="right">
                                                    <xsl:value-of
                                                            select="Podsumowanie/ZestawienieLiczboweKontroli/WymagaInterpretacji"/>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="2">
                                                <fo:block>Nie można było wykonać z powodu błędu krytycznego</fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell>
                                                <fo:block text-align="right">
                                                    <xsl:value-of
                                                            select="Podsumowanie/ZestawienieLiczboweKontroli/BladKrytyczny"/>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                        <fo:table-row>
                                            <fo:table-cell number-columns-spanned="2">
                                                <fo:block>Suma</fo:block>
                                            </fo:table-cell>
                                            <fo:table-cell>
                                                <fo:block text-align="right">
                                                    <xsl:value-of
                                                            select="Podsumowanie/ZestawienieLiczboweKontroli/Suma"/>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </fo:table-body>
                                </fo:table>
                            </fo:block>
                        </fo:block>
                    </fo:block>
                    <fo:block>
                        <fo:block font-size="16pt"
                                  font-weight="bold"
                                  space-after.optimum="0.5cm"
                                  page-break-after="avoid">Walidacja ze schematem XSD
                        </fo:block>
                        <fo:table table-layout="fixed"
                                  width="100%"
                                  border-collapse="separate"
                                  page-break-after="avoid">
                            <fo:table-column column-width="50%"/>
                            <fo:table-column column-width="50%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>Status kontroli:</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>
                                            <xsl:value-of select="WalidacjaZeSchematem/StatusKontroli"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <xsl:if test="WalidacjaZeSchematem/WynikKontroli!=''">
                                    <fo:table-row>
                                        <fo:table-cell>
                                            <fo:block>Wynik kontroli:</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block>
                                                <xsl:value-of select="WalidacjaZeSchematem/WynikKontroli"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:if>
                            </fo:table-body>
                        </fo:table>
                        <xsl:if test="WalidacjaZeSchematem/ListaBledow/BladKontroli">
                            <fo:block space-before.minimum="2pt" space-after.minimum="4pt">
                                Lista błędów (zawiera&#160;<xsl:value-of
                                    select="WalidacjaZeSchematem/WyswietlanychBledow"/>&#160;błędów z&#160;<xsl:value-of
                                    select="WalidacjaZeSchematem/LiczbaBledow"/>):
                            </fo:block>
                            <xsl:for-each select="WalidacjaZeSchematem/ListaBledow/BladKontroli">
                                <fo:block wrap-option="wrap" font-size="8pt" space-after.minimum="2pt">
                                    -
                                    <xsl:call-template name="process-string">
                                        <xsl:with-param name="string-subset"
                                                        select="text()"/>
                                        <xsl:with-param name="n"
                                                        select="10"/>
                                    </xsl:call-template>
                                </fo:block>
                            </xsl:for-each>
                        </xsl:if>
                        <fo:block font-size="16pt"
                                  font-weight="bold"
                                  page-break-after="avoid"
                                  space-before.optimum="1cm">Kontrole atrybutowe
                        </fo:block>
                        <fo:table table-layout="fixed"
                                  width="100%"
                                  border-collapse="separate"
                                  page-break-after="avoid"
                                  page-break-inside="avoid">
                            <fo:table-column column-width="50%"/>
                            <fo:table-column column-width="50%"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell>
                                        <fo:block>Status kontroli:</fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell>
                                        <fo:block>
                                            <xsl:value-of select="KontroleAtrybutowe/StatusKontroli"/>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <xsl:if test="KontroleAtrybutowe/WynikKontroli!=''">
                                    <fo:table-row>
                                        <fo:table-cell>
                                            <fo:block>Wynik kontroli:</fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell>
                                            <fo:block>
                                                <xsl:value-of select="KontroleAtrybutowe/WynikKontroli"/>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:if>
                            </fo:table-body>
                        </fo:table>
                        <xsl:apply-templates select="KontroleAtrybutowe/GrupaKontroliAtrybutowych"/>
                    </fo:block>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <xsl:template match="KontroleAtrybutowe/GrupaKontroliAtrybutowych">
        <fo:block page-break-after="avoid"
                  space-before.minimum="1cm"
                  font-weight="bold"
                  font-size="14pt">Kontrole&#160;<xsl:value-of select="Nazwa"/>
        </fo:block>
        <xsl:apply-templates select="KontrolaAtrybutowa"/>
    </xsl:template>
    <xsl:template match="KontroleAtrybutowe/GrupaKontroliAtrybutowych/KontrolaAtrybutowa">
        <fo:block page-break-after="avoid"
                  space-before.minimum="0.5cm"
                  font-weight="bold"
                  font-size="12pt">Kontrola&#160;<xsl:value-of select="Id"/>:&#160;<xsl:value-of select="Nazwa"/>
        </fo:block>
        <fo:block space-before.minimum="0.2cm"
                  page-break-after="avoid"
                  margin-left="1cm">Status kontroli:&#160;<xsl:value-of select="StatusKontroli"/>
        </fo:block>
        <xsl:if test="WynikKontroli!=''">
            <fo:block page-break-after="avoid"
                      margin-left="1cm">Wynik kontroli:&#160;<xsl:value-of select="WynikKontroli"/>
            </fo:block>
        </xsl:if>
        <xsl:if test="Komunikat!=''">
            <fo:block page-break-after="avoid"
                      margin-left="1cm">Szczegóły kontroli:
            </fo:block>
            <fo:block page-break-after="avoid"
                      margin-left="1cm"
                      space-after.minimum="0.1cm">
                <xsl:value-of select="Komunikat"/>
            </fo:block>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="ListaBledow/BladKontroliAtrybutowej">
                <fo:table table-layout="fixed"
                          width="100%"
                          border-collapse="separate">
                    <fo:table-header>
                        <fo:table-row page-break-inside="avoid">
                            <fo:table-cell xsl:use-attribute-sets="headerCellStyle">
                                <fo:block>Klasa</fo:block>
                            </fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="headerCellStyle">
                                <fo:block>idIIP : lokalnyId</fo:block>
                            </fo:table-cell>
                            <fo:table-cell xsl:use-attribute-sets="headerCellStyle">
                                <fo:block>GMLID</fo:block>
                            </fo:table-cell>
                            <xsl:if test="Atrybut1Nazwa">
                                <fo:table-cell xsl:use-attribute-sets="headerCellStyle">
                                    <fo:block>
                                        <xsl:call-template name="process-string">
                                            <xsl:with-param name="string-subset"
                                                            select="Atrybut1Nazwa"/>
                                            <xsl:with-param name="n"
                                                            select="10"/>
                                        </xsl:call-template>
                                    </fo:block>
                                </fo:table-cell>
                            </xsl:if>
                            <xsl:if test="Atrybut2Nazwa">
                                <fo:table-cell xsl:use-attribute-sets="headerCellStyle">
                                    <fo:block>
                                        <xsl:call-template name="process-string">
                                            <xsl:with-param name="string-subset"
                                                            select="Atrybut2Nazwa"/>
                                            <xsl:with-param name="n"
                                                            select="10"/>
                                        </xsl:call-template>
                                    </fo:block>
                                </fo:table-cell>
                            </xsl:if>
                            <xsl:if test="Atrybut3Nazwa">
                                <fo:table-cell xsl:use-attribute-sets="headerCellStyle">
                                    <fo:block>
                                        <xsl:call-template name="process-string">
                                            <xsl:with-param name="string-subset"
                                                            select="Atrybut3Nazwa"/>
                                            <xsl:with-param name="n"
                                                            select="10"/>
                                        </xsl:call-template>
                                    </fo:block>
                                </fo:table-cell>
                            </xsl:if>
                        </fo:table-row>
                    </fo:table-header>
                    <fo:table-body>
                        <xsl:for-each select="ListaBledow/BladKontroliAtrybutowej">
                            <fo:table-row page-break-inside="avoid">
                                <fo:table-cell xsl:use-attribute-sets="cellStyle">
                                    <fo:block>
                                        <xsl:call-template name="process-string">
                                            <xsl:with-param name="string-subset"
                                                            select="Klasa"/>
                                            <xsl:with-param name="n"
                                                            select="$liczbaLiterDoSpacji"/>
                                        </xsl:call-template>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="cellStyle">
                                    <fo:block>
                                        <xsl:call-template name="process-string">
                                            <xsl:with-param name="string-subset"
                                                            select="LokalnyID"/>
                                            <xsl:with-param name="n"
                                                            select="$liczbaLiterDoSpacji"/>
                                        </xsl:call-template>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="cellStyle">
                                    <fo:block>
                                        <xsl:call-template name="process-string">
                                            <xsl:with-param name="string-subset"
                                                            select="GMLID"/>
                                            <xsl:with-param name="n"
                                                            select="$liczbaLiterDoSpacji"/>
                                        </xsl:call-template>
                                    </fo:block>
                                </fo:table-cell>
                                <xsl:if test="../../Atrybut1Nazwa">
                                    <fo:table-cell xsl:use-attribute-sets="cellStyle">
                                        <fo:block>
                                            <xsl:call-template name="process-string">
                                                <xsl:with-param name="string-subset"
                                                                select="Atrybut1Wartosc"/>
                                                <xsl:with-param name="n"
                                                                select="$liczbaLiterDoSpacji"/>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </xsl:if>
                                <xsl:if test="../../Atrybut2Nazwa">
                                    <fo:table-cell xsl:use-attribute-sets="cellStyle">
                                        <fo:block>
                                            <xsl:call-template name="process-string">
                                                <xsl:with-param name="string-subset"
                                                                select="Atrybut2Wartosc"/>
                                                <xsl:with-param name="n"
                                                                select="$liczbaLiterDoSpacji"/>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </xsl:if>
                                <xsl:if test="../../Atrybut3Nazwa">
                                    <fo:table-cell xsl:use-attribute-sets="cellStyle">
                                        <fo:block>
                                            <xsl:call-template name="process-string">
                                                <xsl:with-param name="string-subset"
                                                                select="Atrybut3Wartosc"/>
                                                <xsl:with-param name="n"
                                                                select="$liczbaLiterDoSpacji"/>
                                            </xsl:call-template>
                                        </fo:block>
                                    </fo:table-cell>
                                </xsl:if>
                            </fo:table-row>
                        </xsl:for-each>
                    </fo:table-body>
                </fo:table>
                <fo:block font-size="8pt" space-before.minimum="3pt">Tabela zawiera&#160;<xsl:value-of
                        select="WyswietlanaLiczbaBledow"/> błędów z&#160;<xsl:value-of
                        select="LiczbaBledow"/>
                </fo:block>
            </xsl:when>
            <xsl:otherwise>
                <fo:block/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="process-string">
        <xsl:param name="string-subset"/>
        <xsl:param name="n"/>
        <xsl:value-of select="substring($string-subset, 1, $n)"/>
        <xsl:text>&#x200b;</xsl:text>
        <xsl:variable name="strlen"
                      select="string-length(substring($string-subset, $n + 1, string-length($string-subset)))"/>
        <xsl:if test="$strlen
		        > $n">
            <xsl:call-template name="process-string">
                <xsl:with-param name="string-subset"
                                select="substring($string-subset, $n + 1, string-length($string-subset))"/>
                <xsl:with-param name="n"
                                select="$n"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="not($strlen
		        > $n)">
            <xsl:value-of select="substring($string-subset, $n + 1, string-length($string-subset))"/>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>