# -*- coding: utf-8 -*-
"""
/***************************************************************************
 mlppoz
                                 A QGIS plugin
 Mapa Leśna PPOŻ
                              -------------------
        begin                : 2017-03-11
        git sha              : $Format:%H$
        copyright            : (C) 2017 by todo
        email                : todo@mlppoz.ppoz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from io import BytesIO

import qgis
import zipfile
from datetime import datetime
from .resources import *
import requests
import os.path
from qgis.PyQt.QtGui import QIcon
from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5 import QtWidgets
from qgis._core import  Qgis
import socket
from .mlppoz_dialog import mlppozDialog
from PyQt5.QtCore import QObject

# Initialize Qt resources from file resources.py
# Import the code for the dialog
class mlppoz(QObject):
    """QGIS Plugin Implementation."""

    
    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        self.iface = iface
        if(self.is_connected('qgis.zilp.lasy.gov.pl')):
            self.updateTowers()
            self.updateStyles()
            self.updateParkiNarodowe()
            self.updateDoc()
        else:
            self.iface.messageBar().pushMessage('Brak połaczenia z serwerem qgis!', Qgis.Info)
        super(mlppoz, self).__init__()
        # Save reference to the QGIS interface


        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        QtCore.QSettings().setValue('/svg/searchPathsForSVG',"")
        locale = QtCore.QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'mlppoz_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QtCore.QTranslator()
            self.translator.load(locale_path)

            if QtCore.qVersion() > '4.3.3':
                QtCore.QCoreApplication.installTranslator(self.translator)

    def is_connected(self,hostname):
        try:
            sock = socket.create_connection((hostname, 80))
            if sock is not None:
                print('Clossing socket')
                sock.close()
            return True
        except:
            pass
        return False
    def updateData(self,path,url,updateUrl,msg):
        if requests.get(url).status_code == 200:
            with open(path + 'update_log.txt', 'r') as logfile:
                data = logfile.read()
            uploadDateStr = requests.get(updateUrl)
            newuploadDate = datetime.strptime(uploadDateStr.text, '%Y-%m-%d')
            print(data)
            print(uploadDateStr.text)
            LastUpdate = datetime.strptime(data, '%Y-%m-%d')
            print(newuploadDate)
            print(LastUpdate)
            if newuploadDate > LastUpdate:
                r = requests.get(url)
                z = zipfile.ZipFile(BytesIO(r.content))
                z.extractall(path)
                with open(path + 'update_log.txt', 'w') as logfile:
                    logfile.write(uploadDateStr.text)
                self.iface.messageBar().pushMessage(msg, Qgis.Info)
                logfile.close()
                z.close()
            else:
                print('brak aktualizacji')

    def updateDoc(self):
        url = 'http://qgis.zilp.lasy.gov.pl/qgis/repository/miscFile/PGL_LP_ML_PPOZ_Instrukcja_obslugi.zip'
        path_to_doc = os.path.join(os.path.join(QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str("/python/plugins/mlppoz/doc/")))
        newUpdateUrl = url+str('.uploadDate')
        msg = 'Instrukcja użytkownika została zaktualizowana'
        self.updateData(path_to_doc, url, newUpdateUrl, msg)
    def updateParkiNarodowe(self):
        path_to_layer=os.path.join(os.path.join(QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str("/python/plugins/mlppoz/ParkiNarodowe/")))
        url = 'http://qgis.zilp.lasy.gov.pl/qgis/repository/miscFile/PPOZ_PN.zip'
        newUpdateUrl = 'http://qgis.zilp.lasy.gov.pl/qgis/repository/miscFile/PPOZ_PN.zip.uploadDate'
        msg = 'Warstwy PN zostały zaktualizowane'
        self.updateData(path_to_layer, url, newUpdateUrl, msg)
    def updateTowers(self):
        path_to_towers=os.path.join(os.path.join(QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str("/python/plugins/mlppoz/towers/")))
        url='http://qgis.zilp.lasy.gov.pl/qgis/repository/miscFile/Dostrzegalnie.zip'
        newUpdateUrl = 'http://qgis.zilp.lasy.gov.pl/qgis/repository/miscFile/Dostrzegalnie.zip.uploadDate'
        msg = 'Warstwy dostrzegalni zostały zaktualizowane'
        self.updateData(path_to_towers,url,newUpdateUrl,msg)

    def updateStyles(self):
        path_to_styles = os.path.join(os.path.join(
                QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str(
                    "/python/plugins/mlppoz/qml/")))
        url = 'http://qgis.zilp.lasy.gov.pl/qgis/repository/miscFile/Styles_PN_PPOZ.zip'
        newUpdateUrl = 'http://qgis.zilp.lasy.gov.pl/qgis/repository/miscFile/Styles_PN_PPOZ.zip.uploadDate'
        msg = 'Style zostały zaktualizowane'
        self.updateData(path_to_styles, url, newUpdateUrl, msg)



    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        # Initialize dialog in a dock
        self.dialog = mlppozDialog(self.iface)

        self.dock = QtWidgets.QDockWidget('Mapa Leśna PPOŻ', self.iface.mainWindow())
        self.dock.setObjectName('mlppoz')
        self.dock.setWidget(self.dialog)

        self.iface.addDockWidget(QtCore.Qt.RightDockWidgetArea,
                                 self.dock)

        #self.trigger.connect(self.showhidePlugin)
        # create action that will start plugin configuration
    
        self.action = QtWidgets.QAction(QIcon(":/mlppoz/icon.png"), u'&Mapa Leśna PPOŻ', self.iface.mainWindow())
        self.action.triggered.connect(self.showhidePlugin)
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu('&Mapa Leśna PPOŻ', self.action)

    def showhidePlugin(self):
        dock = self.iface.mainWindow().findChild(QtWidgets.QDockWidget, 'mlppoz')
        visible = dock.isVisible()
        dock.setVisible(not visible)


    def unload(self):
        # remove the plugin menu item and icon
        self.iface.removePluginMenu('&Mapa Leśna PPOŻ', self.action)
        self.iface.removeToolBarIcon(self.action)

        # Close dialog
        self.dialog.unload()
        self.dialog.close()
        self.dialog = None

        # Remove dock widget
        self.iface.removeDockWidget(self.dock)
        self.dock.deleteLater()
        self.dock = None