# -*- coding: utf-8 -*-
"""
/***************************************************************************
 mlppozDialog
                                 A QGIS plugin
 Mapa Leśna PPOŻ
                             -------------------
        begin                : 2017-03-11
        git sha              : $Format:%H$
        copyright            : (C) 2017 by todo
        email                : todo@mlppoz.ppoz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import configparser
import glob
import math
import os
from PyQt5 import Qt
from PyQt5 import QtCore
from PyQt5 import uic
from PyQt5 import QtWidgets
from PyQt5.Qt import *
from qgis._core import QgsProject, QgsRectangle
from qgis.core import *
from qgis.gui import *
from qgis.gui import QgisInterface
from qgis.PyQt.QtCore import QSettings

import qgis.utils

from .utils_general import layerExists, getFieldIndexFromLayer, getUniqueForestryPrefixes, createPrjFile, \
    getPpozFeatures, getParkiFeatures,createPpozMemLayer, createSimplePointMemLayer, createSimpleLineMemLayer, createSimplePolyMemLayer, \
    createPpozMemFireLayer, copyQmlStyle, updateFeatureInLayer, isFloat, locatePointInPolyLayer, degMinSec, \
    transformGeometry, pointAlongLine, createPnMemLayer, getParkiOddzWydzFeatures
from .utils_gui import loadList2Combo, clearCombo, showHideLayerInLegend


FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'mlppoz_dialog_base.ui'))

# gui messages
NO_FOLDER_SELECTED = "Brak katalogu z danymi.\nProszę wskazać prawidłowy katalog"
NO_PROJ_SELECTED = "Brak pliku projektu.\nProszę wskazać prawidłowy plik"
FOLDER_SELECT = "Wybierz folder z danymi LMN"
PROJECT_SELECT = "Wybierz plik projektu QGIS"
NO_WYDZPOL = "Brak warstwy wydz_pol w wybranym katalogu"
NO_WYDZPOL_IN_PROJECT = "Brak warstwy wydz_pol w załadowanym projekcie"
NO_ADRLES = "Brak pola adr_les w warstwie wydz_pol"
NO_ADDRESSES = "Brak numerów nadleśnictw w warstwie wydz_pol"
NO_NZWOB = "Brak pola nzw_ob w warstwie ppoz_dost_pkt"
NO_NADL = "Brak pola nadl w warstwie ppoz_dost_pkt"
NO_PPOZ = "Brak obiektów ppoż spełniających kryteria na podstawie danych z warstwy wydz_pol"
FOLDER_LOAD_IN_PROGRESS = "Trwa ładowanie warstw do mapy..."
FOLDER_LOAD_SUCESSFULL = "Warstwy załadowane do mapy"
PPOZ_MEM_LAYER = "Dostrzegalnie"
PN_MEM_LAYER = "Parki Narodowe"
PN_MEM_LAYER_WYDZ = "Parki Narodowe - wydzielenia"
PN_MEM_LAYER_ODDZ = "Parki Narodowe - oddziały"
PN_MEM_LAYER_DROGI = "Parki Narodowe - dojazdy pożarowe"
PPOZ_MEM_POINT1_LAYER = "Dostrzegalnia 1"
PPOZ_MEM_POINT2_LAYER = "Dostrzegalnia 2"
PPOZ_MEM_POINT3_LAYER = "Dostrzegalnia 3"
PPOZ_MEM_LINE1_LAYER = "Linia kierunkowa 1"
PPOZ_MEM_LINE2_LAYER = "Linia kierunkowa 2"
PPOZ_MEM_LINE3_LAYER = "Linia kierunkowa 3"
PPOZ_MEM_POLY1_LAYER = "Wydzielenie z pożarem"
PPOZ_MEM_FIRE_LAYER = "Pożar"
CALC_ON_ONE_POINT = "Wyliczenie punktu na podstawie pomiaru z 1ej dostrzegalni"
CALC_ON_TWO_POINTS = "Wyliczenie punktu na podstawie pomiaru z 2óch dostrzegalni"
CALC_ON_THREE_POINTS = "Wyliczenie punktu na podstawie pomiaru z 3ech dostrzegalni"
CALC_ON_EMPTY = "Brak wyboru sposobu wyliczenia punktu na podstawie pomiarów z dostrzegalni"
CALC_ON_ONE_POINT_NO_DIST = "Odległość nie jest liczbą!"
CALC_FIRE_CALCULATED = "Znaleziono punkt"
CALC_FIRE_CALCULATED_OUTSIDE = "Znaleziono punkt poza wydzieleniem"
CALC_FIRE_CALCULATED_NO_ADRLES = "Brak"
CALC_FIRE_CALCULATED_NOCROSS = "Brak przecięcia linii"
CALC_FIRE_CALCULATED_NOCROSS2 = "Brak wystarczającej ilości przecięć linii"
CALC_POINT_WGS84 = "SZ:{}º {}\' {}\" N  DŁ:{}º {}\' {}\" E"
CALC_ZOOM_SCALE_TO_FIRE = 8500

class mlppozDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, iface, parent=None):
        """Constructor."""
        super(mlppozDialog, self).__init__(parent)
        self.setupUi(self)
        self.iface = iface
        # wersja wtyczki
        self.lblVersion.setText("Wersja: " + self.getPluginVersion())

        # dodaj do ścieżek przeszukiwania SVG Qgis'a ścieżkę SVG wtyczki
        path_tosvg=os.path.join(os.path.join(QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str("/python/plugins/mlppoz/svgcatalog")))


        self.addSvgPath(path_tosvg)

        # tryb wyliczania punktu
        # 1 - azymut + długość z 1ej dostrzegalni
        # 2 - azymuty z 2óch dostrzegalni przecinają się
        # 3 - azymuty z 3ech dostrzegalni tworzą trójkąt i wyliczamy centroid
        self.calcType = -1
        self.sendCalcType2Status()


        # tryb załadowania warstw
        self.loadingType = 1

        # lista nazwa ppoż/id obiektu
        self.ppozDict = []

        # wybrane dostrzegalnie
        self.tower1 = None
        self.tower2 = None
        self.tower3 = None

        # events
        #{object}.{signal}.connect({slot})
        self.btnLoadLayers.clicked.connect(self.loadLayers)
        self.btnSelectDir.clicked.connect(self.selectDir)
        self.btnCalc.clicked.connect(self.calcPoint)
        self.btnHelp.clicked.connect(self.showHelp)
        self.qrbtFolder.clicked.connect(self.selectLoadingType)
        self.qrbtProject.clicked.connect(self.selectLoadingType)
        self.btnClear.clicked.connect(self.clearCalc)

        self.cmbPpozList1.currentIndexChanged.connect(self.ppozList1Index)
        self.cmbPpozList2.currentIndexChanged.connect(self.ppozList2Index)
        self.cmbPpozList3.currentIndexChanged.connect(self.ppozList3Index)
        self.iface.actionOpenProject().triggered.connect(self.readProjectFromMenu)
        recentFileAction = self.iface.projectMenu().actions()[5]
        recentFileAction.setVisible(False)
        QSettings().remove('UI/recentProjects')
        #warstwy memo i user

        self.memoLayers = []
        self.userLayers = []
        self.wydzPol = None
        self.WydzPolId = -1
        self.ppozMem = None
        self.parkiMem = None

        self.path = None
        self.projName = None

        # template kolejności/widoczności warstw
        self.userLayersTemplate = [
            {'name': 'syt_pol', 'title': 'Inne elementy powierzchniowe - 1', 'index': 1, 'visible': True},
            {'name': 'oddz_pol', 'title': 'Lasy PGL LP – oddziały', 'index': 2, 'visible': True},
            {'name': 'Parki Narodowe - oddziały', 'title': 'Parki Narodowe - oddziały', 'index': 3, 'visible': True},
            {'name': 'uzyt_pol', 'title': 'Inne elementy powierzchniowe - 2', 'index': 4, 'visible': True},
            {'name': 'wydz_pol', 'title': 'Wydzielenia', 'index': 5, 'visible': True},
            {'name': 'Parki Narodowe - wydzielenia', 'title': 'Parki Narodowe - wydzielenia', 'index': 6, 'visible': True},
			 {'name': 'kl_pal_dst_pol', 'title': 'Klasy palności drzewostanów ', 'index': 7, 'visible': True},
            {'name': 'pnsw_pol', 'title': 'Powierzchnie nie stanowiące wydzieleń ', 'index': 8, 'visible': True},
            {'name': 'ciek_lin', 'title': 'Wody', 'index': 9, 'visible': True},
            {'name': 'kom_lin', 'title': 'Drogi i koleje', 'index': 10, 'visible': True},
            {'name': 'komp_lin', 'title': 'Dojazdy pożarowe', 'index': 11, 'visible': True},
            {'name': 'Parki Narodowe - dojazdy pożarowe', 'title': 'Parki Narodowe - dojazdy pożarowe', 'index': 12, 'visible': True},
            {'name': 'uzbr_lin', 'title': 'Uzbrojenie terenu', 'index': 13, 'visible': True},
            {'name': 'les_pol', 'title': 'Granice leśnictwa', 'index': 14, 'visible': True},
            {'name': 'nadl_pol', 'title': 'Granice nadleśnictwa', 'index': 15, 'visible': True},
            {'name': 'Parki Narodowe', 'title': 'Parki Narodowe', 'index': 16, 'visible': True},
            {'name': 'oprz_pol', 'title': 'Obszary kulturowe i przyrodnicze', 'index': 17, 'visible': False},
            {'name': 'oprz_pkt', 'title': 'Obiekty przyrodnicze', 'index': 18, 'visible': True},
            {'name': 'tur_pkt', 'title': 'Obiekty turystyczne', 'index': 19, 'visible': True},
            {'name': 'bud_pol', 'title': 'Budynek', 'index': 20, 'visible': True},
            {'name': 'inz_pkt', 'title': 'Obiekty sytuacyjne', 'index': 21, 'visible': True},
            {'name': 'ppoz_pkt', 'title': 'Punkty przeciwpożarowe i obiekty sytuacyjne', 'index': 22, 'visible': True},
            {'name': 'ow_pkt', 'title': 'Opisy wydzieleń', 'index': 23, 'visible': True},
            {'name': 'od_pkt', 'title': 'Opisy oddziałów', 'index': 24, 'visible': True}]

    def unload(self):

        #usuń poprzednio załadowane warstwy memo i user
        self.iface.actionOpenProject().triggered.disconnect(self.readProjectFromMenu)
        self.deleteMemoLayers()
        self.deleteUserLayers()
        self.calcType = -1
        self.sendCalcType2Status()
        self.wydzPol = None
        self.WydzPolId = -1
        self.ppozMem = None

    def selectLoadingType(self):
        if self.qrbtFolder.isChecked():
            self.loadingType = 1
            self.dirPath.setText(str(self.path))
            self.repaint()

        if self.qrbtProject.isChecked():
            self.loadingType = 2
            self.dirPath.setText(str(self.projName))
            self.repaint()

    def readProjectFromMenu(self):
        self.readProjekt()
    
    def readProjectFromPlugin(self, projFile):
        if projFile is None or os.path.exists(str(projFile)) == False:
            self.textEditStatus.setText(NO_PROJ_SELECTED)
            return

        # załaduj projekt
        self.iface.addProject(projFile)

        # dodatkowa logika
        self.readProjekt()

    def clearCalc(self):
        self.cmbPpozList1.setCurrentIndex(0)
        self.textEditStatus.setText(CALC_ON_EMPTY)
        #if hasattr(self,'pl1Mem'):
        updateFeatureInLayer(self.pl1Mem, None, -1)
        #if hasattr(self,'fireMem'):
        updateFeatureInLayer(self.fireMem, None, -1)
        self.updatePointDetails(None, None)

    def readProjekt(self):



        # usunięcie "starych" warstw memo z projektu
        try:
            oldMemoList = [olayer for olayer in QgsProject.instance().mapLayers().values() if olayer.dataProvider().name() == "memory" ]
            for layer in oldMemoList:
                if layer.name() in [PPOZ_MEM_LAYER, PPOZ_MEM_POINT1_LAYER, PPOZ_MEM_POINT2_LAYER, PPOZ_MEM_POINT3_LAYER,
                                    PPOZ_MEM_LINE1_LAYER, PPOZ_MEM_LINE2_LAYER, PPOZ_MEM_LINE3_LAYER, PPOZ_MEM_POLY1_LAYER,
                                    PPOZ_MEM_FIRE_LAYER,PN_MEM_LAYER,PN_MEM_LAYER_WYDZ,PN_MEM_LAYER_ODDZ,PN_MEM_LAYER_DROGI]:
                    # usuń takie warstwy
                    QgsProject.instance().removeMapLayer(layer)
        finally:
            pass

        # sprawdzenie czy w projekcie istnieje wydz_pol z polem adr_les - szukamy pierwszego, spełniającego kryteria przypadku
        bWydzPolExists = False
        bAdrLesExists = False
        wydzPolList = [olayer for olayer in QgsProject.instance().mapLayers().values() if olayer.dataProvider().name() == "ogr" ]
        
        
        for layer in wydzPolList:
            try:
                shpFile = QtCore.QFileInfo(layer.dataProvider().dataSourceUri().split('|')[0])
               
                if shpFile.baseName() == "wydz_pol":
                    bWydzPolExists = True

                    if getFieldIndexFromLayer("adr_les", layer) >= 0:
                        bAdrLesExists = True
                        self.wydzPol = layer
                        self.WydzPolId = layer.id()
                        break
            except:
                pass

        if bWydzPolExists == False:
            self.textEditStatus.setText(NO_WYDZPOL_IN_PROJECT)
            return

        if bAdrLesExists == False:
            self.textEditStatus.setText(NO_ADRLES)
            return

        # pobranie prefiksów adresów leśnych
        forestryPrefixes = getUniqueForestryPrefixes(self.wydzPol.getFeatures())

        if len(forestryPrefixes) < 1:
            self.textEditStatus.setText(NO_ADDRESSES)
            return

        # pobranie z warstwy ppoz listy obiektów pasujących listy 'nadl'
        ppozLayer = qgis.core.QgsVectorLayer(os.path.join(QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str("/python/plugins/mlppoz/towers"), "ppoz_dost_pkt.shp"), "ppoz_dost_pkt", "ogr")

        # sprawdzenie czy jest pole nzw_ob
        nzwObIndex = getFieldIndexFromLayer("nzw_ob", ppozLayer)
        if nzwObIndex < 0:
            self.textEditStatus.setText(NO_NZWOB)
            return

        # sprawdzenie czy jest pole nadl
        nadlIndex = getFieldIndexFromLayer("nadl", ppozLayer)
        if nadlIndex < 0:
            self.textEditStatus.setText(NO_NADL)
            return

        # pobranie listy obiektów z ppoz
        ppozFeatures = getPpozFeatures(ppozLayer, forestryPrefixes)
        if len(ppozFeatures) < 1:
            self.textEditStatus.setText(NO_PPOZ)
            return

        # usuń poprzednio załadowane warstwy memo i user
        self.deleteMemoLayers()
        self.deleteUserLayers()

        #self.wydzPol = None
        self.ppozMem = None
        self.parkiMem = None

        # wyzeruj kontrolki wtyczki
        self.resetPlugin()

        # utwórz odfiltrowaną warstwę pppoż jako warstwę memory
        self.ppozMem = createPpozMemLayer(ppozLayer, ppozFeatures, PPOZ_MEM_LAYER)

        # zbuduj listę numer obiektu/nazwa -> na potrzeby list dostrzegalni - posortowane alfabetycznie
        self.ppozDict = sorted([(i.id(), i.attributes()[nzwObIndex]) for i in self.ppozMem.getFeatures()], key=lambda x: x[1])

        # utworzenie warstw "do rysowania"
        self.pt1Mem = createSimplePointMemLayer(PPOZ_MEM_POINT1_LAYER, 'red')
        self.pt2Mem = createSimplePointMemLayer(PPOZ_MEM_POINT2_LAYER, 'green')
        self.pt3Mem = createSimplePointMemLayer(PPOZ_MEM_POINT3_LAYER, 'blue')
        self.ln1Mem = createSimpleLineMemLayer(PPOZ_MEM_LINE1_LAYER, 'red')
        self.ln2Mem = createSimpleLineMemLayer(PPOZ_MEM_LINE2_LAYER, 'green')
        self.ln3Mem = createSimpleLineMemLayer(PPOZ_MEM_LINE3_LAYER, 'blue')
        self.pl1Mem = createSimplePolyMemLayer(PPOZ_MEM_POLY1_LAYER)
        self.fireMem = createPpozMemFireLayer(PPOZ_MEM_FIRE_LAYER, 'pink')
        self.memoLayers = [self.pl1Mem, self.ln1Mem, self.ln2Mem, self.ln3Mem, self.ppozMem, self.pt1Mem, self.pt2Mem, self.pt3Mem, self.fireMem]
        self.memoLayers.reverse()



        #nadlIndex = getFieldIndexFromLayer("nadl", pnLayer)
        if nadlIndex < 0:
            self.textEditStatus.setText(NO_NADL)
            return





        # dodanie warstw memo
        QgsProject.instance().addMapLayers(self.memoLayers)
        registry = QgsProject.instance()

        root = registry.layerTreeRoot()
        #root.insertLayer(17, self.parkiMem)



        # i ukrycie w legendzie
        self.hideMemoLayersInLegend()

        # załadowanie list/kontrolek w gui
        loadList2Combo(self.cmbPpozList1, True, self.ppozDict, [])
        self.sendCalcType2Status()

        # odświeżenie mapy i wtyczki (zoom ?)
        self.forceMapRecalculate()

        self.textEditStatus.setText(FOLDER_LOAD_SUCESSFULL)
        self.repaint()
        #QgsProject.instance().legendLayersAdded.connect(self.layersToTopHandler)



    def getPluginVersion(self):
        cfg = configparser.ConfigParser()
        cfg.read(os.path.join(QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str("/python/plugins/mlppoz"), 'metadata.txt'))
        version = cfg.get('general', 'version')
        return str(version)

    def addSvgPath(self, pathToAdd):
        settings = QtCore.QSettings()
        search_paths_str = settings.value('/svg/searchPathsForSVG')
        if not search_paths_str:
            search_paths = []
        else:
            search_paths = search_paths_str
        if pathToAdd not in search_paths:
            search_paths.append(pathToAdd)
            settings.setValue("/svg/searchPathsForSVG", '|'.join(search_paths))



    def preventVisibilityChanges(self, layerTreeNode, checkstate):
        try:
            # warstwa zawsze widoczna mimo próby zmian widoczności z GUI
            root = QgsProject.instance().layerTreeRoot()
            root.setLayerVisible(self.ppozMem, True) 
            for memoLayer in self.memoLayers:
                root.setLayerVisible(memoLayer, True)
        except:
            return False

    def ppozList1Index(self, idx):
        if self.cmbPpozList1.itemData(idx) == -1:
            # czyść listy 2 i 3
            clearCombo(self.cmbPpozList2)
            clearCombo(self.cmbPpozList3)
            # brak trybu wyliczania punktu
            self.spinBoxAzim1.setValue(0.0)

            self.lineEditLen1.setText("")
            updateFeatureInLayer(self.ln1Mem, None, -1)
            self.spinBoxAzim2.setValue(0)
            updateFeatureInLayer(self.ln2Mem, None, -1)
            self.spinBoxAzim3.setValue(0)
            updateFeatureInLayer(self.ln3Mem, None, -1)
            self.calcType = -1
        else:
            # załaduj listę 2
            loadList2Combo(self.cmbPpozList2, True, self.ppozDict, [self.cmbPpozList1.itemData(idx)])
            # wyczyść listę 3
            clearCombo(self.cmbPpozList3)
            # tryb wyliczania z 1ego punktu
            self.calcType = 1

        # uaktualnij wybrany tryb wyliczenia
        self.sendCalcType2Status()
        # uaktualnij wybraną dostrzegalnię na mapie
        self.tower1 = self.reloadMemPointLayer(self.pt1Mem, self.cmbPpozList1.itemData(idx))
        # uaktualnij pozostałe dostrzegalnie
        self.tower2 = self.reloadMemPointLayer(self.pt2Mem, self.cmbPpozList2.itemData(self.cmbPpozList2.currentIndex()))
        self.tower3 = self.reloadMemPointLayer(self.pt3Mem, self.cmbPpozList3.itemData(self.cmbPpozList3.currentIndex()))
       

    def ppozList2Index(self, idx):
        if self.cmbPpozList2.itemData(idx) == -1:
            # czyść listę 3
            clearCombo(self.cmbPpozList3)
            # tryb wyliczania z 1ego punktu
            self.spinBoxAzim2.setValue(0)
            updateFeatureInLayer(self.ln2Mem, None, -1)
            self.spinBoxAzim3.setValue(0)
            updateFeatureInLayer(self.ln3Mem, None, -1)
            self.calcType = 1
        else:
            # załaduj listę 3
            loadList2Combo(self.cmbPpozList3, True, self.ppozDict, [self.cmbPpozList1.itemData(self.cmbPpozList1.currentIndex()), self.cmbPpozList2.itemData(idx)])
            # tryb wyliczania z 2óch punktów
            self.lineEditLen1.setText("")
            self.calcType = 2

        # uaktualnij wybrany tryb wyliczenia
        self.sendCalcType2Status()
        # uaktualnij wybraną dostrzegalnię na mapie
        self.tower2 = self.reloadMemPointLayer(self.pt2Mem, self.cmbPpozList2.itemData(idx))
        # uaktualnij pozostałe dostrzegalnie
        self.tower3 = self.reloadMemPointLayer(self.pt3Mem, self.cmbPpozList3.itemData(self.cmbPpozList3.currentIndex()))

    def ppozList3Index(self, idx):
        if self.cmbPpozList3.itemData(idx) == -1:
            # tryb wyliczania z 2óch punktów
            self.spinBoxAzim3.setValue(0)
            updateFeatureInLayer(self.ln3Mem, None, -1)
            self.calcType = 2
        else:
            # tryb wyliczania z 3óch punktów
            self.lineEditLen1.setText("")
            self.calcType = 3

        self.sendCalcType2Status()
        self.tower3 = self.reloadMemPointLayer(self.pt3Mem, self.cmbPpozList3.itemData(idx))

    def showHelp(self):
        os.startfile(os.path.join(QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str("/python/plugins/mlppoz/doc"), "PGL_LP_ML_PPOZ_Instrukcja_obslugi.pdf"))

    def selectDir(self):
        settings = QtCore.QSettings()

        if self.loadingType == 1:
            #sprawdz czy jest zapisany ostatni wczytywany katalog
            if not settings.value( "/mlppoz/LastCatalog" ) is None:
                self.path = QtWidgets.QFileDialog.getExistingDirectory( self, FOLDER_SELECT,settings.value( "/mlppoz/LastCatalog" ))
            else:
                self.path = QtWidgets.QFileDialog.getExistingDirectory( self, FOLDER_SELECT)

            if self.path is None:
                return

            if self.path:
                self.dirPath.setText( self.path )
                settings.setValue( "/mlppoz/LastCatalog", os.path.split(self.path)[0] )

        elif self.loadingType == 2:
            # sprawdz czy jest zapisany ostatni wczytywany katalog
            if not settings.value("/mlppoz/LastProject") is None:
                self.projName,_filter = QtWidgets.QFileDialog.getOpenFileName(self, PROJECT_SELECT, settings.value( "/mlppoz/LastProject" ), 'Pliki QGIS (*.qgs *.QGS *.qgz *.QGZ)')
            else:
                self.projName,_filter = QtWidgets.QFileDialog.getOpenFileName(self, PROJECT_SELECT, u"", 'Pliki QGIS (*.qgs *.QGS *.qgz *.QGZ)')

            if self.projName is None:
                return

            if self.projName:
                self.dirPath.setText(str(self.projName))
                settings.setValue("/mlppoz/LastProject", os.path.dirname(str(self.projName)))

    def loadLayers(self):
        try:

            self.textEditStatus.setText(FOLDER_LOAD_IN_PROGRESS)
            self.grpBoxData.setEnabled(False)
            self.grpBoxMeasure.setEnabled(False)
            self.grpBoxFire.setEnabled(False)
            self.repaint()
            QApplication.setOverrideCursor(Qt.WaitCursor)

            if self.loadingType == 1:
                self.loadLayers2()
            elif self.loadingType == 2:
                self.readProjectFromPlugin(self.projName)

        finally:
            self.grpBoxData.setEnabled(True)
            self.grpBoxMeasure.setEnabled(True)
            self.grpBoxFire.setEnabled(True)
            self.repaint()
            QApplication.restoreOverrideCursor()


    def resetPlugin(self):
        # wyzeruj kontrolki wtyczki
        clearCombo(self.cmbPpozList1)
        clearCombo(self.cmbPpozList2)
        clearCombo(self.cmbPpozList3)
        self.spinBoxAzim1.setValue(0)
        self.spinBoxAzim2.setValue(0)
        self.spinBoxAzim3.setValue(0)
        self.lineEditLen1.setText("")
        self.calcType = -1
        self.sendCalcType2Status()
        self.updatePointDetails(None, None)


    def loadLayers2(self):
        print("loadlayers2")
        try:
            oldMemoList = [olayer for olayer in QgsProject.instance().mapLayers().values() if
                           olayer.dataProvider().name() == "memory"]
            for layer in oldMemoList:
                if layer.name() in [PPOZ_MEM_LAYER, PPOZ_MEM_POINT1_LAYER, PPOZ_MEM_POINT2_LAYER, PPOZ_MEM_POINT3_LAYER,
                                    PPOZ_MEM_LINE1_LAYER, PPOZ_MEM_LINE2_LAYER, PPOZ_MEM_LINE3_LAYER,
                                    PPOZ_MEM_POLY1_LAYER,
                                    PPOZ_MEM_FIRE_LAYER, PN_MEM_LAYER,PN_MEM_LAYER_WYDZ,PN_MEM_LAYER_ODDZ,PN_MEM_LAYER_DROGI]:
                    # usuń takie warstwy
                    QgsProject.instance().removeMapLayer(layer)
            self.iface.mapCanvas().refresh();
        finally:
            pass
        baseDir = self.dirPath.text()
        if baseDir is None or len(baseDir)<1:
            self.textEditStatus.setText(NO_FOLDER_SELECTED)
            return

        # sprawdzenie czy w katalogu jest plik wydz_pol
        if layerExists(str(baseDir), "wydz_pol") == False:
            self.textEditStatus.setText(NO_WYDZPOL)
            return

        # skopiowanie plików prj
        createPrjFile(str(baseDir))

        # sprawdzenie czy wydz_pol ma pole adr_les
        wydzPolLayer = qgis.core.QgsVectorLayer(os.path.join(str(baseDir), "wydz_pol.shp"), "wydz_pol" ,"ogr")
        if getFieldIndexFromLayer("adr_les", wydzPolLayer) < 0:
            self.textEditStatus.setText(NO_ADRLES)
            return
        
        # pobranie unikalnych wartości nadleśnictwa
        forestryPrefixes = getUniqueForestryPrefixes(wydzPolLayer.getFeatures())
        if len(forestryPrefixes) < 1:

            self.textEditStatus.setText(NO_ADDRESSES)
            return

        # pobranie z warstwy ppoz listy obiektów pasujących listy 'nadl'
        ppozLayer = qgis.core.QgsVectorLayer(os.path.join(
            QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str("/python/plugins/mlppoz/towers"), "ppoz_dost_pkt.shp"), "ppoz_dost_pkt" ,"ogr")


        # sprawdzenie czy jest pole nzw_ob
        nzwObIndex = getFieldIndexFromLayer("nzw_ob", ppozLayer)
        if nzwObIndex < 0:
            self.textEditStatus.setText(NO_NZWOB)
            return
        
        # sprawdzenie czy jest pole nadl
        nadlIndex = getFieldIndexFromLayer("nadl", ppozLayer)
        if nadlIndex < 0:
            self.textEditStatus.setText(NO_NADL)
            return

        # pobranie listy obiektów z ppoz
        ppozFeatures = getPpozFeatures(ppozLayer, forestryPrefixes)
        if len(ppozFeatures) < 1:
            self.textEditStatus.setText(NO_PPOZ)
            return
        self.pnLayer = qgis.core.QgsVectorLayer(os.path.join(
            QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str(
                "/python/plugins/mlppoz/ParkiNarodowe"), "Parki Narodowe.shp"), "Parki Narodowe", "ogr")
        self.pnLayer.setProviderEncoding(u'System')
        self.pnLayer.dataProvider().setEncoding(u'System')
        self.pn_wydz_Layer = qgis.core.QgsVectorLayer(os.path.join(
            QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str(
                "/python/plugins/mlppoz/ParkiNarodowe"), "PN_WYDZ.shp"), PN_MEM_LAYER_WYDZ, "ogr")
        self.pn_oddz_Layer = qgis.core.QgsVectorLayer(os.path.join(
            QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str(
                "/python/plugins/mlppoz/ParkiNarodowe"), "PN_ODDZ.shp"), PN_MEM_LAYER_ODDZ, "ogr")

        self.pn_drogi_Layer = qgis.core.QgsVectorLayer(os.path.join(
            QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str(
                "/python/plugins/mlppoz/ParkiNarodowe"), "PN_DROGI_PPOZ.shp"), PN_MEM_LAYER_DROGI, "ogr")
        # usuń poprzednio załadowane warstwy memo i user
        self.deleteMemoLayers()
        self.deleteUserLayers()
        self.wydzPol = None
        self.WydzPolId = -1
        self.ppozMem = None
        self.parkiMem = None
        self.parki_wydz_Mem = None
        self.parki_oddz_Mem = None
        self.parki_drogi_Mem = None

        # wyzeruj kontrolki wtyczki
        self.resetPlugin()

        # utwórz odfiltrowaną warstwę pppoż jako warstwę memory
        self.ppozMem = createPpozMemLayer(ppozLayer, ppozFeatures, PPOZ_MEM_LAYER)

        # zbuduj listę numer obiektu/nazwa -> na potrzeby list dostrzegalni - posortowane alfabetycznie
        self.ppozDict = sorted([(i.id(), i.attributes()[nzwObIndex]) for i in self.ppozMem.getFeatures()], key=lambda x: x[1])

        # wkopiowanie do baseDir plików qml
        qmlCatalog = QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str("/python/plugins/mlppoz/qml")
        copyQmlStyle(str( baseDir), str( qmlCatalog))

        # utworzenie warstw "do rysowania"
        self.pt1Mem = createSimplePointMemLayer(PPOZ_MEM_POINT1_LAYER, 'red')
        self.pt2Mem = createSimplePointMemLayer(PPOZ_MEM_POINT2_LAYER, 'green')
        self.pt3Mem = createSimplePointMemLayer(PPOZ_MEM_POINT3_LAYER, 'blue')
        self.ln1Mem = createSimpleLineMemLayer(PPOZ_MEM_LINE1_LAYER, 'red')
        self.ln2Mem = createSimpleLineMemLayer(PPOZ_MEM_LINE2_LAYER, 'green')
        self.ln3Mem = createSimpleLineMemLayer(PPOZ_MEM_LINE3_LAYER, 'blue')
        self.pl1Mem = createSimplePolyMemLayer(PPOZ_MEM_POLY1_LAYER)
        self.fireMem = createPpozMemFireLayer(PPOZ_MEM_FIRE_LAYER, 'pink')
        self.memoLayers = [self.pl1Mem, self.ln1Mem, self.ln2Mem, self.ln3Mem, self.ppozMem, self.pt1Mem, self.pt2Mem, self.pt3Mem, self.fireMem]
        self.memoLayers.reverse()

        ppozFeatures = getParkiFeatures(self.pnLayer, forestryPrefixes)
        self.parkiMem = createPnMemLayer(self.pnLayer, ppozFeatures, PN_MEM_LAYER)

        pnOddzFetures= getParkiOddzWydzFeatures(self.parkiMem, self.pn_oddz_Layer)
        pnWydzFetures = getParkiOddzWydzFeatures(self.parkiMem, self.pn_wydz_Layer)
        pnDrogiFetures = getParkiOddzWydzFeatures(self.parkiMem, self.pn_drogi_Layer)
        self.parkiOddzMem = createPnMemLayer(self.pn_oddz_Layer, pnOddzFetures, PN_MEM_LAYER_ODDZ)
        self.parkiWydzMem = createPnMemLayer(self.pn_wydz_Layer, pnWydzFetures, PN_MEM_LAYER_WYDZ)
        self.parkiDrogiMem = createPnMemLayer(self.pn_drogi_Layer, pnDrogiFetures, PN_MEM_LAYER_DROGI,"MultiLineString")
        # dodanie warstw memo


        # dodanie wszystkiego do mapy (z zarejestrowaniem nazw plików z wybranego folderu - tak, by potem je usunąć po kolejnym wywołaniu Wczytaj)
        self.loadUserDataToMap(str(baseDir), self.userLayersTemplate)
        # dodanie warstw memo
        #qgis.core.QgsProject.instance().addMapLayers([self.parkiMem])
        qgis.core.QgsProject.instance().addMapLayers(self.memoLayers)
        # i ukrycie w legendzie
        self.hideMemoLayersInLegend()

        # załadowanie list/kontrolek w gui
        loadList2Combo(self.cmbPpozList1, True, self.ppozDict, [])
        self.sendCalcType2Status()

        # odświeżenie mapy i wtyczki (zoom ?)
        self.forceMapRecalculate()

        self.textEditStatus.setText(FOLDER_LOAD_SUCESSFULL)
        self.repaint()

    def forceMapRecalculate(self):
        #tricky

        # wyliczenie exentu na podstawie warstw + dostrzegalnie
       
        #canvas = QgsMapCanvas(None)
        #mapRenderer = self.iface.mapCanvas()
        #extent = QgsRectangle()
        #rect = QgsRectangle(mapRenderer.fullExtent())
      
       
        #extent.setMinimal()
        #tab_layer = self.iface.mapCanvas().layers()
        #bridge = QgsLayerTreeMapCanvasBridge(QgsProject.instance().layerTreeRoot(), canvas)
        #tab_layer = bridge.mapCanvas().layers()
        #extent = QgsRectangle()
       # print("force: ",tab_layer)
        '''
        #extent.setMinimal()
        tab_layer = self.iface.mapCanvas().layers()
        '''
        '''
        for layer in tab_layer:
            
            if layer.name() not in [PPOZ_MEM_POINT1_LAYER, PPOZ_MEM_POINT2_LAYER, PPOZ_MEM_POINT3_LAYER,
                                    PPOZ_MEM_LINE1_LAYER, PPOZ_MEM_LINE2_LAYER, PPOZ_MEM_LINE3_LAYER,
                                    PPOZ_MEM_POLY1_LAYER,
                                    PPOZ_MEM_FIRE_LAYER]:
                extent.combineExtentWith(layer.extent())
        #rect.scale(1.1)
        #mapRenderer.setExtent(rect)
        
        # powiększenie całości do 110% dla lepszej widoczności
        #extent.scale(1.1)               
        ##self.iface.mapCanvas().setExtent(extent)
        #QgsProject.instance().mapLayers().values()
        #self.iface.mapCanvas().refresh()
        '''
        extent = QgsRectangle()
        extent.setMinimal()
        for layer in self.iface.mapCanvas().layers():
            if layer.name() not in [PPOZ_MEM_POINT1_LAYER, PPOZ_MEM_POINT2_LAYER, PPOZ_MEM_POINT3_LAYER,
                                    PPOZ_MEM_LINE1_LAYER, PPOZ_MEM_LINE2_LAYER, PPOZ_MEM_LINE3_LAYER,
                                    PPOZ_MEM_POLY1_LAYER,
                                    PPOZ_MEM_FIRE_LAYER, PN_MEM_LAYER, PN_MEM_LAYER_WYDZ,
                                    PN_MEM_LAYER_ODDZ, PN_MEM_LAYER_DROGI]:
                extent.combineExtentWith(layer.extent())
        # powiększenie całości do 110% dla lepszej widoczności
        extent.scale(1.1)
        self.iface.mapCanvas().setExtent(extent)
        self.iface.mapCanvas().refresh()
        
        
    def calcPoint(self):
        # wyliczenie z 1ej dostrzegalni, azymutu i odległości
        distance = self.lineEditLen1.text().replace(",",".")
        if self.calcType == 1:
            # sprawdzenie czy odległość jest numeryczna
            if isFloat(distance) == False:
                self.textEditStatus.setText(CALC_ON_ONE_POINT + " - " + CALC_ON_ONE_POINT_NO_DIST)
                return
            # oblicz punkt
            self.calcPoint1(self.tower1, float(self.spinBoxAzim1.value()), 1000*float(distance))

        # wyliczenie z 2óch dostrzegalni na podstawie azymutów
        elif self.calcType == 2:
            self.calcPoint2(self.tower1, float(self.spinBoxAzim1.value()), 1000*float(10000), self.tower2, float(self.spinBoxAzim2.value()), 1000*float(10000))

        # wyliczenie z 3ech dostrzegalni na podstawie azymutów
        elif self.calcType == 3:
            self.calcPoint3(self.tower1, float(self.spinBoxAzim1.value()), 1000*float(10000),
                            self.tower2, float(self.spinBoxAzim2.value()), 1000*float(10000),
                            self.tower3, float(self.spinBoxAzim3.value()), 1000*float(10000))

        # brak wyboru wyliczenia
        else:
            print("Exception "+CALC_ON_EMPTY)
            self.textEditStatus.setText(CALC_ON_EMPTY)
            if hasattr(self,'pl1Mem'):
                updateFeatureInLayer(self.pl1Mem, None, -1)
            if hasattr(self,'fireMem'):
                updateFeatureInLayer(self.fireMem, None, -1)
            self.updatePointDetails(None, None)

        if self.calcType > 0:
            self.zoomToSelected()

    def zoomToSelected(self):

        # mamy wydzielenie z pożarem - zoom do wydzielenia:
        if self.pl1Mem.featureCount() > 0:
            self.pl1Mem.selectAll()
            self.iface.mapCanvas().setExtent(self.pl1Mem.boundingBoxOfSelected())
            self.pl1Mem.removeSelection()
            self.iface.mapCanvas().zoomScale(CALC_ZOOM_SCALE_TO_FIRE)
            self.iface.mapCanvas().refresh()
            return True

        # mamy pożar poza wydzieleniem - zoom do punktu ?
        if self.fireMem.featureCount() > 0:
            self.fireMem.selectAll()
            self.iface.mapCanvas().setExtent(self.fireMem.boundingBoxOfSelected())
            self.fireMem.removeSelection()
            self.iface.mapCanvas().zoomScale(CALC_ZOOM_SCALE_TO_FIRE)
            self.iface.mapCanvas().refresh()
            return True

        return False

    def calcPoint3(self, pointA, angleA, distA, pointB, angleB, distB, pointC, angleC, distC):
        # wyliczenie dla 1ej dostrzegalni
        deltax = distA * math.cos(math.pi/2 - math.pi*angleA/180)
        deltay = distA * math.sin(math.pi/2 -math.pi*angleA/180)
        
        xb = pointA.x() + deltax
        yb = pointA.y() + deltay
        #line1 = QgsGeometry.fromPolyline([pointA, QgsPoint(xb, yb)])
        line1 = qgis.core.QgsGeometry.fromPolylineXY([pointA, pointAlongLine(pointA, qgis.core.QgsPointXY(xb, yb), 1000 * 50)])
        # narysuj linię do punktu
        #updateFeatureInLayer(self.ln1Mem, QgsGeometry.fromPolyline([pointA, pointAlongLine(pointA, QgsPoint(xb, yb), 1000 * 50)]), 1)
        updateFeatureInLayer(self.ln1Mem, line1, 1)

        # wyliczenie dla 2ej dostrzegalni
        deltax = distB * math.cos(math.pi/2 - math.pi*angleB/180)
        deltay = distB * math.sin(math.pi/2 -math.pi*angleB/180)

        xb = pointB.x() + deltax
        yb = pointB.y() + deltay
        #line2 = QgsGeometry.fromPolyline([pointB, QgsPoint(xb, yb)])
        line2 = qgis.core.QgsGeometry.fromPolylineXY([pointB, pointAlongLine(pointB, qgis.core.QgsPointXY(xb, yb), 1000 * 50)])
        # narysuj linię do punktu
        #updateFeatureInLayer(self.ln2Mem, QgsGeometry.fromPolyline([pointB, pointAlongLine(pointB, QgsPoint(xb, yb), 1000 * 50)]), 1)
        updateFeatureInLayer(self.ln2Mem, line2, 1)

        # wyliczenie dla 3ej dostrzegalni
        deltax = distC * math.cos(math.pi/2 - math.pi*angleC/180)
        deltay = distC * math.sin(math.pi/2 -math.pi*angleC/180)

        xb = pointC.x() + deltax
        yb = pointC.y() + deltay
        #line3 = QgsGeometry.fromPolyline([pointC, QgsPoint(xb, yb)])
        line3 = qgis.core.QgsGeometry.fromPolylineXY([pointC, pointAlongLine(pointC, qgis.core.QgsPointXY(xb, yb), 1000 * 50)])
        # narysuj linię do punktu
        #updateFeatureInLayer(self.ln3Mem, QgsGeometry.fromPolyline([pointC, pointAlongLine(pointC, QgsPoint(xb, yb), 1000 * 50)]), 1)
        updateFeatureInLayer(self.ln3Mem, line3, 1)

        # badamy przecięcie line1 i line2
        intersectionPoint12 = line1.intersection(line2)
        # brak przecięcia - nie ma po co sprawdzać dalej
        if intersectionPoint12.type() != 0:
            self.textEditStatus.setText(CALC_FIRE_CALCULATED_NOCROSS2)
            updateFeatureInLayer(self.pl1Mem, None, -1)
            updateFeatureInLayer(self.fireMem, None, -1)
            self.updatePointDetails(None, None)
            return False

        # badamy przecięcie line1 i line3
        intersectionPoint13 = line1.intersection(line3)
        # brak przecięcia - nie ma po co sprawdzać dalej
        if intersectionPoint13.type() != 0:
            self.textEditStatus.setText(CALC_FIRE_CALCULATED_NOCROSS2)
            updateFeatureInLayer(self.pl1Mem, None, -1)
            updateFeatureInLayer(self.fireMem, None, -1)
            self.updatePointDetails(None, None)
            return False

        # badamy przecięcie line2 i line3
        intersectionPoint23 = line2.intersection(line3)
        # brak przecięcia - nie ma po co sprawdzać dalej
        if intersectionPoint23.type() != 0:
            self.textEditStatus.setText(CALC_FIRE_CALCULATED_NOCROSS2)
            updateFeatureInLayer(self.pl1Mem, None, -1)
            updateFeatureInLayer(self.fireMem, None, -1)
            self.updatePointDetails(None, None)
            return False

        # wyznaczamy centroid z 3ech punktów
        intersectionPoint = qgis.core.QgsGeometry.fromPolygonXY([[intersectionPoint12.asPoint(), intersectionPoint13.asPoint(), intersectionPoint23.asPoint()]]).centroid()
        if intersectionPoint.type() == 0: #punkt
            # zlokalizuj punkt w wydz_pol
            #locatedPoly = locatePointInPolyLayer(intersectionPoint, QgsProject.instance().layerTreeRoot().findLayer(self.WydzPolId))#QgsMapLayerRegistry.instance().mapLayersByName("wydz_pol")[0]
            tempLayer = QgsProject.instance().layerTreeRoot().findLayer(self.WydzPolId)
            locatedPoly = locatePointInPolyLayer(intersectionPoint, None if tempLayer is None else tempLayer.layer())
            if locatedPoly is None:
                self.textEditStatus.setText(CALC_FIRE_CALCULATED_OUTSIDE)
                updateFeatureInLayer(self.pl1Mem, None, -1)
            else:
                self.textEditStatus.setText(CALC_FIRE_CALCULATED)
                updateFeatureInLayer(self.pl1Mem, locatedPoly.geometry(), 1)

            # narysuj punkt przecięcia
            updateFeatureInLayer(self.fireMem, intersectionPoint, 1)

            # uaktualnij info
            self.updatePointDetails(intersectionPoint.asPoint(), locatedPoly)
        else:
            #centroid nie jest punktem ?
            self.textEditStatus.setText(CALC_FIRE_CALCULATED_NOCROSS)
            updateFeatureInLayer(self.pl1Mem, None)
            updateFeatureInLayer(self.fireMem, None, -1)
            self.updatePointDetails(None, None)

        self.iface.mapCanvas().refresh()
        return True

    
    def calcPoint2(self, pointA, angleA, distA, pointB, angleB, distB):
        # wyliczenie dla 1ej dostrzegalni
        deltax = distA * math.cos(math.pi/2 - math.pi*angleA/180)
        deltay = distA * math.sin(math.pi/2 -math.pi*angleA/180)

        xb = pointA.x() + deltax
        yb = pointA.y() + deltay
        #line1 = QgsGeometry.fromPolyline([pointA, QgsPoint(xb, yb)])
        line1 = qgis.core.QgsGeometry.fromPolylineXY([pointA, pointAlongLine(pointA, qgis.core.QgsPointXY(xb, yb), 1000 * 50)])
        # narysuj linię do punktu
        updateFeatureInLayer(self.ln1Mem, line1, 1)
        #updateFeatureInLayer(self.ln1Mem, QgsGeometry.fromPolyline([pointA, pointAlongLine(pointA, QgsPoint(xb, yb), 1000 * 50)]), 1)

        # wyliczenie dla 2ej dostrzegalni
        deltax = distB * math.cos(math.pi/2 - math.pi*angleB/180)
        deltay = distB * math.sin(math.pi/2 -math.pi*angleB/180)

        xb = pointB.x() + deltax
        yb = pointB.y() + deltay
        #line2 = QgsGeometry.fromPolyline([pointB, QgsPoint(xb, yb)])
        line2 = qgis.core.QgsGeometry.fromPolylineXY([pointB, pointAlongLine(pointB, qgis.core.QgsPointXY(xb, yb), 1000 * 50)])
        # narysuj linię do punktu
        updateFeatureInLayer(self.ln2Mem, line2, 1)
        #updateFeatureInLayer(self.ln2Mem, QgsGeometry.fromPolyline([pointB, pointAlongLine(pointB, QgsPoint(xb, yb), 1000 * 50)]), 1)

        # badamy przecięcie
        intersectionPoint = line1.intersection(line2)
        if intersectionPoint.type() == 0: #punkt
            # zlokalizuj punkt w wydz_pol
            #locatedPoly = locatePointInPolyLayer(intersectionPoint, QgsProject.instance().layerTreeRoot().findLayer(self.WydzPolId)) #QgsMapLayerRegistry.instance().mapLayersByName("wydz_pol")[0]
            tempLayer = qgis.core.QgsProject.instance().layerTreeRoot().findLayer(self.WydzPolId)
            locatedPoly = locatePointInPolyLayer(intersectionPoint, None if tempLayer is None else tempLayer.layer())
            if locatedPoly is None:
                self.textEditStatus.setText(CALC_FIRE_CALCULATED_OUTSIDE)
                updateFeatureInLayer(self.pl1Mem, None, -1)
            else:
                self.textEditStatus.setText(CALC_FIRE_CALCULATED)
                updateFeatureInLayer(self.pl1Mem, locatedPoly.geometry(), 1)

            # narysuj punkt przecięcia
            updateFeatureInLayer(self.fireMem, intersectionPoint, 1)

            # uaktualnij info
            self.updatePointDetails(intersectionPoint.asPoint(), locatedPoly)

        else:
            #brak przecięcia
            self.textEditStatus.setText(CALC_FIRE_CALCULATED_NOCROSS)
            updateFeatureInLayer(self.pl1Mem, None, -1)
            updateFeatureInLayer(self.fireMem, None, -1)
            self.updatePointDetails(None, None)

        self.iface.mapCanvas().refresh()

    def calcPoint1(self, pointA, angle, dist):
        deltax = dist * math.cos(math.pi/2 - math.pi*angle/180)
        deltay = dist * math.sin(math.pi/2 -math.pi*angle/180)

        xb = pointA.x() + deltax
        yb = pointA.y() + deltay
        
        # narysuj linię do punktu
        updateFeatureInLayer(self.ln1Mem, qgis.core.QgsGeometry.fromPolylineXY([pointA, qgis.core.QgsPointXY(xb, yb)]), 1)

        # zlokalizuj punkt w wydz_pol
        #locatedPoly = locatePointInPolyLayer(QgsGeometry.fromPoint(QgsPoint(xb, yb)), QgsProject.instance().layerTreeRoot().findLayer(self.WydzPolId)) #QgsMapLayerRegistry.instance().mapLayersByName("wydz_pol")[0])
        tempLayer = qgis.core.QgsProject.instance().layerTreeRoot().findLayer(self.WydzPolId)
        locatedPoly = locatePointInPolyLayer(qgis.core.QgsGeometry.fromPointXY(qgis.core.QgsPointXY(xb, yb)), None if tempLayer is None else tempLayer.layer())
        if locatedPoly is None:
            self.textEditStatus.setText(CALC_FIRE_CALCULATED_OUTSIDE)
            updateFeatureInLayer(self.pl1Mem, None, -1)
        else:
            self.textEditStatus.setText(CALC_FIRE_CALCULATED)
            updateFeatureInLayer(self.pl1Mem, locatedPoly.geometry(), 1)

        # narysuj punkt
        updateFeatureInLayer(self.fireMem, qgis.core.QgsGeometry.fromPointXY(qgis.core.QgsPointXY(xb, yb)), 1)
        # uaktualnij info
        self.updatePointDetails(qgis.core.QgsPointXY(xb, yb), locatedPoly)
        self.iface.mapCanvas().refresh()

    def updatePointDetails(self, point, poly):
        wgs84point = None
        if point is None:
            self.lineEditCoords1992.setText(CALC_FIRE_CALCULATED_NO_ADRLES)
            self.lineEditCoords84.setText(CALC_FIRE_CALCULATED_NO_ADRLES)
        else:
            # ustaw współrzędne 1992
            self.lineEditCoords1992.setText("X:" + str(round(point.y(), 2)) + " Y:" + str(round(point.x(), 2)))
            # ustaw współrzędne wgs-84
            wgs84point = transformGeometry(qgis.core.QgsCoordinateReferenceSystem(2180), qgis.core.QgsCoordinateReferenceSystem(4326), point,QgsProject.instance())
            if wgs84point is not None:
                deg1, min1, sec1 = degMinSec(wgs84point.y())
                deg2, min2, sec2 = degMinSec(wgs84point.x())
                self.lineEditCoords84.setText(CALC_POINT_WGS84.format(deg1, min1, sec1, deg2, min2, sec2))
        # ustaw adres leśny - o ile punkt wpadł do wydzielenia
        self.lineEditAddrLes.setText(CALC_FIRE_CALCULATED_NO_ADRLES if poly is None else poly["adr_les"])

    def sendCalcType2Status(self):
        if self.calcType == 1:
            self.textEditStatus.setText(CALC_ON_ONE_POINT)
            self.spinBoxAzim1.setReadOnly(False)
            self.spinBoxAzim2.setReadOnly(True)
            self.spinBoxAzim3.setReadOnly(True)
        elif self.calcType == 2:
            self.textEditStatus.setText(CALC_ON_TWO_POINTS)
            self.spinBoxAzim1.setReadOnly(False)
            self.spinBoxAzim2.setReadOnly(False)
            self.spinBoxAzim3.setReadOnly(True)
        elif self.calcType == 3:
            self.textEditStatus.setText(CALC_ON_THREE_POINTS)
            self.spinBoxAzim1.setReadOnly(False)
            self.spinBoxAzim2.setReadOnly(False)
            self.spinBoxAzim3.setReadOnly(False)
        else:
            self.textEditStatus.setText(CALC_ON_EMPTY)
            self.spinBoxAzim1.setReadOnly(True)
            self.spinBoxAzim2.setReadOnly(True)
            self.spinBoxAzim3.setReadOnly(True)

        self.lineEditLen1.setReadOnly(False if self.calcType == 1 else True)

    def loadUserDataToMap(self, dataCatalog, userLayersTemplate):
            self.legend = QgsProject.instance().layerTreeRoot()
            # lista warstw z katalogu
            shapesList = glob.glob(os.path.join(str(dataCatalog), "*.shp"))
           
            # lista z nazwami plików
            listUserLayers = []
            listUserLayers.append(PN_MEM_LAYER)
            listUserLayers.append(PN_MEM_LAYER_WYDZ)
            listUserLayers.append(PN_MEM_LAYER_ODDZ)
            listUserLayers.append(PN_MEM_LAYER_DROGI)
            # badamy typ geometrii wczytywanej warstwy i szukamy wydz_pol
            for shp in shapesList:
                (shpdir, shpfile) = os.path.split(shp)
                shpName, shpExt = os.path.splitext(shpfile)
                listUserLayers.append(shpName)



            # sortujemy wg template'ów (kolejność wg template'u i na koniec warstwy danego typu spoza template'u) i dodajemy do mapy
            self.addUserLayers2Map(self.sortLayersByTemplate(listUserLayers, self.userLayersTemplate), dataCatalog)
            #ustaw układ okna mapy na PUWG1992
            self.coordRS = qgis.core.QgsCoordinateReferenceSystem()
            epsgRS = 'EPSG:2180'
            createCrs = self.coordRS.createFromOgcWmsCrs(epsgRS)
          
            mapCanvas = self.iface.mapCanvas()
            mapCanvas.mapSettings().setDestinationCrs(self.coordRS)
            
    def addUserLayers2Map(self, xxx_todo_changeme, dataCatalog):
        # dla warstw spoza template'u - nie dodajemy ich do mapy !!!
        '''for item in otherLayers:
            layer = QgsVectorLayer(os.path.join(unicode(dataCatalog),  item + ".shp"), item, 'ogr')
            QgsMapLayerRegistry.instance().addMapLayer(layer)
            # warstwy spoza template'u niewidoczne na starcie
            qgis.utils.iface.legendInterface().setLayerVisible(layer, False)
            self.userLayers.append(layer)'''
        (templateLayers, otherLayers) = xxx_todo_changeme
        for item in templateLayers:
            if item['name'] ==PN_MEM_LAYER:
                layer = self.parkiMem
                layer.loadNamedStyle(str(QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str(
            "/python/plugins/mlppoz/qml/Parki Narodowe.qml")))

            elif item['name'] ==PN_MEM_LAYER_WYDZ:
                layer = self.parkiWydzMem
                layer.loadNamedStyle(
                    str(QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str(
                        "/python/plugins/mlppoz/qml/PN_WYDZ.qml")))
            elif item['name'] == PN_MEM_LAYER_ODDZ:
                layer = self.parkiOddzMem
                layer.loadNamedStyle(
                    str(QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str(
                        "/python/plugins/mlppoz/qml/PN_ODDZ.qml")))
            elif item['name'] == PN_MEM_LAYER_DROGI:
                layer = self.parkiDrogiMem
                layer.loadNamedStyle(
                    str(QtCore.QFileInfo(qgis.core.QgsApplication.qgisUserDatabaseFilePath()).path() + str(
                        "/python/plugins/mlppoz/qml/PN_DROGI_PPOZ.qml")))
            else:
                layer = qgis.core.QgsVectorLayer(os.path.join(str(dataCatalog),  item['name'] + '.shp'), item['title'], 'ogr')
            QgsProject.instance().addMapLayer(layer)
            if item['name'] == 'wydz_pol':
                self.wydzPol = layer
                self.WydzPolId = layer.id()
            self.userLayers.append(layer)
    def sortLayersByTemplate(self,listToSort, templateList):
        c, d = [{'name':x['name'], 'index':x['index'], 'visible':x['visible'], 'title':x['title']} for x in templateList if x['name'] in listToSort], [x['name'] for x in templateList if x['name'] in listToSort]
        return c, list(set(listToSort) - set(d))
    def hideMemoLayersInLegend(self):
        for memoLayer in self.memoLayers:
            showHideLayerInLegend(QgsProject.instance().layerTreeRoot().findLayer(memoLayer.id()), self.iface)

    def deleteMemoLayers(self):
        self.deleteLayersFromMap(self.memoLayers)
      

    def deleteUserLayers(self):
        self.deleteLayersFromMap(self.userLayers)

    def deleteLayersFromMap(self,layersList):
        for layer in layersList:
            try:
                QgsProject.instance().removeMapLayer(layer.id())
            except:
                pass

    def reloadMemPointLayer(self, lyr,idval):
        tower = None
        if idval == -1 or idval is None:
            updateFeatureInLayer(lyr, -1, -1)
            tower = None
        
        else:
            request = qgis.core.QgsFeatureRequest()
            request.setFilterFids([idval])
            features = self.ppozMem.getFeatures(request)
            for feature in features:
                tower = feature.geometry().asPoint()
                updateFeatureInLayer(lyr, feature.geometry(), idval)
                break
        return tower