# -*- coding: utf-8 -*-

from PyQt5.QtCore import *
from PyQt5.QtGui import *
import math

from qgis._core import QgsLayerTreeLayer, QgsLayerTreeGroup, QgsProject
from qgis.core import *
import qgis.utils


__all__ = ['loadList2Combo', 'clearCombo', 'showHideLayerInLegend']

class GuiUtils:

    def __init__(self):
       pass

    @staticmethod
    def loadList2Combo(combo, addEmptyElem, keyValDict, excludeIds):
        combo.blockSignals(True)
        combo.clear()
        # dodanie pustego elementu
        if addEmptyElem==True:
            combo.addItem("-", -1)
        # dodaj kolejne pozycje z kolekcji
        for key, value in keyValDict:
            # o ile nie wystepuja w liscie wykluczenia
            if key not in excludeIds:
                combo.addItem(value, key)
        combo.blockSignals(False)

    @staticmethod
    def clearCombo(combo):
        combo.blockSignals(True)
        combo.clear()
        combo.blockSignals(False)

    # based on code from https://github.com/gacarrillor/InvisibleLayersAndGroups 
    @staticmethod
    def showHideLayerInLegend(node, iface, bHide=True):
        print('showHideLayerInLegend')
        if type( node ) in ( QgsLayerTreeLayer, QgsLayerTreeGroup ):
            index = iface.layerTreeView().model().node2index( node )
            iface.layerTreeView().setRowHidden( index.row(), index.parent(), bHide )
            node.setCustomProperty( 'nodeHidden', 'true' if bHide else 'false' )
            iface.layerTreeView().setCurrentIndex( iface.layerTreeView().model().node2index( QgsProject.instance().layerTreeRoot() ) )

loadList2Combo = GuiUtils.loadList2Combo
clearCombo = GuiUtils.clearCombo
showHideLayerInLegend = GuiUtils.showHideLayerInLegend