/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.kontrole.executory;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.joox.Match;
import org.w3c.dom.Element;
import pl.gov.gugik.gesut.dak.biz.kontrole.walidacje.WalidacjaZakresWartosciHelper;
import pl.gov.gugik.gesut.dak.biz.kontrole.walidacje.WalidacjaZbiorWartosciHelper;
import pl.gov.gugik.gesut.dak.biz.kontrole.walidacje.dto.ZakresWartosciDTO;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;
import pl.gov.gugik.gesut.dak.biz.utils.kontrole.ObiektHelper;
import pl.gov.gugik.gesut.dak.model.kontrole.BladKontroli;
import pl.gov.gugik.gesut.dak.model.kontrole.WynikKontroli;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.Atrybut;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.AtrybutyDoRaportu;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.Warunek;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.WarunkiWejsciowe;

public abstract class KontrolaExecutor {
    private static final Logger log = Logger.getLogger(KontrolaExecutor.class);
    private String grupaKontroliId;
    private String grupaKontroli;
    private String kontrolaId;
    private String nazwaKontroli;
    private String komunikat;
    private List<String> klasy = new ArrayList<String>();
    private Atrybut atrybut;
    private AtrybutyDoRaportu atrybutyDoRaportu;
    private String nazwaAtrybutu;
    private Integer krytycznosc;
    private WarunkiWejsciowe warunkiWejsciowe;

    public WynikKontroli wykonaj(Match feature, String nazwaKontrolowanegoPliku) {
        WynikKontroli wynikKontroli = new WynikKontroli();
        wynikKontroli.setWykonana(true);
        wynikKontroli.setPozytywny(true);
        try {
            if (this.czyWykonywacKontroleDlaKlasyObiektu(feature)) {
                wynikKontroli = this.kontroluj(feature, nazwaKontrolowanegoPliku);
                if (!wynikKontroli.isPozytywny() && wynikKontroli.getBladKontroli() != null) {
                    this.uzupelnijAtrybutyWBledzieKontroli(feature, wynikKontroli.getBladKontroli());
                }
                wynikKontroli.setWykonana(true);
                wynikKontroli.setSpelnioneWarunkiWejsciowe(true);
                return wynikKontroli;
            }
        }
        catch (Exception ex) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(ex);
            wynikKontroli.setBladKrytyczny(true);
            wynikKontroli.setPozytywny(false);
            wynikKontroli.setWykonana(false);
        }
        return wynikKontroli;
    }

    public abstract WynikKontroli kontroluj(Match var1, String var2);

    public BladKontroli generujBladKontroli(Match feature, String nazwaKontrolowanegoPliku) {
        BladKontroli bladKontroli = new BladKontroli();
        bladKontroli.setNazwaPliku(nazwaKontrolowanegoPliku);
        bladKontroli.setGrupaKontroli(this.getGrupaKontroli());
        bladKontroli.setIdKont(this.getKontrolaId());
        bladKontroli.setNazwaKontroli(this.getNazwaKontroli());
        bladKontroli.setKomunikat(this.getKomunikat());
        bladKontroli.setKlasa(feature.tag());
        bladKontroli.setIdLokalne(ObiektHelper.pobierzIdLokalny(feature));
        bladKontroli.setGmlId(ObiektHelper.pobierzGmlId(feature));
        bladKontroli.setAttr1Naz(ObiektHelper.zwrocNazweAtrybutu(this.atrybut));
        return bladKontroli;
    }

    private void uzupelnijAtrybutyWBledzieKontroli(Match feature, BladKontroli blad) {
        this.wyczyscAtrybutyBleduKontroli(blad);
        if (this.atrybutyDoRaportu == null) {
            return;
        }
        int attrNum = 0;
        for (Atrybut attr : this.atrybutyDoRaportu.getAtrybuty()) {
            String wartosc = ObiektHelper.pobierzWartoscAtrybutuAtrybutuDoRaportu(feature, attr);
            switch (++attrNum) {
                case 1: {
                    blad.setAttr1Naz(ObiektHelper.pobierzNazweDoRaportu(attr));
                    blad.setAttr1Wart(wartosc);
                    break;
                }
                case 2: {
                    blad.setAttr2Naz(ObiektHelper.pobierzNazweDoRaportu(attr));
                    blad.setAttr2Wart(wartosc);
                    break;
                }
                case 3: {
                    blad.setAttr3Naz(ObiektHelper.pobierzNazweDoRaportu(attr));
                    blad.setAttr3Wart(wartosc);
                }
            }
        }
    }

    private void wyczyscAtrybutyBleduKontroli(BladKontroli blad) {
        blad.setAttr1Naz(null);
        blad.setAttr1Wart(null);
        blad.setAttr2Naz(null);
        blad.setAttr2Wart(null);
        blad.setAttr3Naz(null);
        blad.setAttr3Wart(null);
    }

    private boolean czyWykonywacKontroleDlaKlasyObiektu(Match feature) {
        return this.klasy.stream().anyMatch(k -> k.equalsIgnoreCase(feature.tag()) && (this.warunkiWejsciowe == null || this.czyObiektSpelniaWarunkiWejsciowe(feature)));
    }

    private boolean czyObiektSpelniaWarunkiWejsciowe(Match feature) {
        return this.warunkiWejsciowe.getWarunek().stream().allMatch(w -> this.czyObiektSpelniaWarunek(feature, (Warunek)w));
    }

    private boolean czyObiektSpelniaWarunek(Match feature, Warunek warunek) {
        Match match = ObiektHelper.pobierzWartoscAtrybutu(feature, warunek.getAtrybut());
        String wartoscAtrybutu = null;
        if (match.isNotEmpty()) {
            for (Element el : match.get()) {
                wartoscAtrybutu = el.getTextContent();
                if (!this.czyObiektSpelniaWarunek(warunek, match, wartoscAtrybutu)) continue;
                return true;
            }
        } else if (this.czyObiektSpelniaWarunek(warunek, match, wartoscAtrybutu)) {
            return true;
        }
        return false;
    }

    private boolean czyObiektSpelniaWarunek(Warunek warunek, Match match, String wartoscAtrybutu) {
        ZakresWartosciDTO zakres;
        return warunek.getZakresWartosci() != null ? WalidacjaZakresWartosciHelper.sprawdzCzyWZakresie(wartoscAtrybutu, zakres = WalidacjaZakresWartosciHelper.utworzDTO(warunek.getZakresWartosci())) : warunek.getZbiorWartosci() != null && WalidacjaZbiorWartosciHelper.sprawdzCzyWZakresie(wartoscAtrybutu, warunek.getZbiorWartosci().getWartosc(), match);
    }

    public String getGrupaKontroliId() {
        return this.grupaKontroliId;
    }

    public void setGrupaKontroliId(String grupaKontroliId) {
        this.grupaKontroliId = grupaKontroliId;
    }

    public String getGrupaKontroli() {
        return this.grupaKontroli;
    }

    public void setGrupaKontroli(String grupaKontroli) {
        this.grupaKontroli = grupaKontroli;
    }

    public String getKontrolaId() {
        return this.kontrolaId;
    }

    public void setKontrolaId(String kontrolaId) {
        this.kontrolaId = kontrolaId;
    }

    public String getNazwaKontroli() {
        return this.nazwaKontroli;
    }

    public void setNazwaKontroli(String nazwaKontroli) {
        this.nazwaKontroli = nazwaKontroli;
    }

    public String getKomunikat() {
        return this.komunikat;
    }

    public void setKomunikat(String komunikat) {
        this.komunikat = komunikat;
    }

    public List<String> getKlasy() {
        return this.klasy;
    }

    public void setKlasy(List<String> klasy) {
        this.klasy = klasy;
    }

    public Atrybut getAtrybut() {
        return this.atrybut;
    }

    public void setAtrybut(Atrybut atrybut) {
        this.atrybut = atrybut;
    }

    public AtrybutyDoRaportu getAtrybutyDoRaportu() {
        return this.atrybutyDoRaportu;
    }

    public void setAtrybutyDoRaportu(AtrybutyDoRaportu atrybutyDoRaportu) {
        this.atrybutyDoRaportu = atrybutyDoRaportu;
    }

    public String getNazwaAtrybutu() {
        return this.nazwaAtrybutu;
    }

    public void setNazwaAtrybutu(String nazwaAtrybutu) {
        this.nazwaAtrybutu = nazwaAtrybutu;
    }

    public Integer getKrytycznosc() {
        return this.krytycznosc;
    }

    public void setKrytycznosc(Integer krytycznosc) {
        this.krytycznosc = krytycznosc;
    }

    public WarunkiWejsciowe getWarunkiWejsciowe() {
        return this.warunkiWejsciowe;
    }

    public void setWarunkiWejsciowe(WarunkiWejsciowe warunkiWejsciowe) {
        this.warunkiWejsciowe = warunkiWejsciowe;
    }
}

