/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.kontrole.walidacje;

import java.time.LocalDateTime;
import pl.gov.gugik.gesut.dak.biz.kontrole.walidacje.dto.ZakresWartosciDTO;
import pl.gov.gugik.gesut.dak.biz.utils.kontrole.ObiektHelper;
import pl.gov.gugik.gesut.dak.enumy.TypDanychEnum;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.ZakresWartosci;

public class WalidacjaZakresWartosciHelper {
    public static boolean sprawdzCzyWZakresie(String wartoscAtrybutu, ZakresWartosciDTO zakres) {
        return WalidacjaZakresWartosciHelper.sprawdzCzyWartoscOdWZakresie(wartoscAtrybutu, zakres) && WalidacjaZakresWartosciHelper.sprawdzCzyWartoscDoWZakresie(wartoscAtrybutu, zakres);
    }

    private static boolean sprawdzCzyWartoscOdWZakresie(String wartoscAtrybutu, ZakresWartosciDTO zakres) {
        if (zakres.getWartoscOd() == null) {
            return true;
        }
        TypDanychEnum typ = TypDanychEnum.valueOf(zakres.getWartoscOdTyp().toUpperCase());
        switch (typ) {
            case INTEGER: {
                return WalidacjaZakresWartosciHelper.sprawdzWartoscOdInteger(wartoscAtrybutu, zakres);
            }
            case DOUBLE: {
                return WalidacjaZakresWartosciHelper.sprawdzWartoscOdDouble(wartoscAtrybutu, zakres);
            }
            case DATE: {
                return WalidacjaZakresWartosciHelper.sprawdzWartoscOdDate(wartoscAtrybutu, zakres);
            }
        }
        return false;
    }

    private static boolean sprawdzWartoscOdInteger(String wartoscAtrybutu, ZakresWartosciDTO zakres) {
        Integer wartosc = Integer.parseInt(wartoscAtrybutu);
        Integer wartoscGranicznca = Integer.parseInt(zakres.getWartoscOd());
        if (zakres.isWartoscOdWlacznie()) {
            return wartoscGranicznca <= wartosc;
        }
        return wartoscGranicznca < wartosc;
    }

    private static boolean sprawdzWartoscOdDouble(String wartoscAtrybutu, ZakresWartosciDTO zakres) {
        Double wartosc = Double.parseDouble(wartoscAtrybutu);
        Double wartoscGranicznca = Double.parseDouble(zakres.getWartoscOd());
        if (zakres.isWartoscOdWlacznie()) {
            return wartoscGranicznca <= wartosc;
        }
        return wartoscGranicznca < wartosc;
    }

    private static boolean sprawdzWartoscOdDate(String wartoscAtrybutu, ZakresWartosciDTO zakres) {
        LocalDateTime wartosc = (LocalDateTime)ObiektHelper.rzutujNaTyp(wartoscAtrybutu, TypDanychEnum.DATE);
        LocalDateTime wartoscGranicznca = (LocalDateTime)ObiektHelper.rzutujNaTyp(zakres.getWartoscOd(), TypDanychEnum.DATE);
        if (zakres.isWartoscOdWlacznie()) {
            return !wartoscGranicznca.isAfter(wartosc);
        }
        return wartoscGranicznca.isBefore(wartosc);
    }

    private static boolean sprawdzCzyWartoscDoWZakresie(String wartoscAtrybutu, ZakresWartosciDTO zakres) {
        if (zakres.getWartoscDo() == null) {
            return true;
        }
        TypDanychEnum typ = TypDanychEnum.valueOf(zakres.getWartoscDoTyp().toUpperCase());
        switch (typ) {
            case INTEGER: {
                return WalidacjaZakresWartosciHelper.sprawdzWartoscDoInteger(wartoscAtrybutu, zakres);
            }
            case DOUBLE: {
                return WalidacjaZakresWartosciHelper.sprawdzWartoscDoDouble(wartoscAtrybutu, zakres);
            }
            case DATE: {
                return WalidacjaZakresWartosciHelper.sprawdzWartoscDoDate(wartoscAtrybutu, zakres);
            }
        }
        return false;
    }

    private static boolean sprawdzWartoscDoInteger(String wartoscAtrybutu, ZakresWartosciDTO zakres) {
        Integer wartosc = Integer.parseInt(wartoscAtrybutu);
        Integer wartoscGranicznca = Integer.parseInt(zakres.getWartoscDo());
        if (zakres.isWartoscDoWlacznie()) {
            return wartoscGranicznca >= wartosc;
        }
        return wartoscGranicznca > wartosc;
    }

    private static boolean sprawdzWartoscDoDouble(String wartoscAtrybutu, ZakresWartosciDTO zakres) {
        Double wartosc = Double.parseDouble(wartoscAtrybutu);
        Double wartoscGranicznca = Double.parseDouble(zakres.getWartoscDo());
        if (zakres.isWartoscDoWlacznie()) {
            return wartoscGranicznca >= wartosc;
        }
        return wartoscGranicznca > wartosc;
    }

    private static boolean sprawdzWartoscDoDate(String wartoscAtrybutu, ZakresWartosciDTO zakres) {
        LocalDateTime wartosc = (LocalDateTime)ObiektHelper.rzutujNaTyp(wartoscAtrybutu, TypDanychEnum.DATE);
        LocalDateTime wartoscGranicznca = (LocalDateTime)ObiektHelper.rzutujNaTyp(zakres.getWartoscDo(), TypDanychEnum.DATE);
        if (zakres.isWartoscDoWlacznie()) {
            return !wartoscGranicznca.isBefore(wartosc);
        }
        return wartoscGranicznca.isAfter(wartosc);
    }

    public static ZakresWartosciDTO utworzDTO(ZakresWartosci zakres) {
        ZakresWartosciDTO zakresWartosciDTO = new ZakresWartosciDTO();
        if (zakres.getWartoscOd() != null) {
            zakresWartosciDTO.setWartoscOd(zakres.getWartoscOd().getWartosc().getValue());
            zakresWartosciDTO.setWartoscOdWlacznie(ObiektHelper.parsujBoolean(zakres.getWartoscOd().getWlacznie()));
            zakresWartosciDTO.setWartoscOdTyp(zakres.getWartoscOd().getWartosc().getTyp());
        }
        if (zakres.getWartoscDo() != null) {
            zakresWartosciDTO.setWartoscDo(zakres.getWartoscDo().getWartosc().getValue());
            zakresWartosciDTO.setWartoscDoWlacznie(ObiektHelper.parsujBoolean(zakres.getWartoscDo().getWlacznie()));
            zakresWartosciDTO.setWartoscDoTyp(zakres.getWartoscDo().getWartosc().getTyp());
        }
        return zakresWartosciDTO;
    }
}

