/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.kontrole;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import pl.gov.gugik.gesut.dak.biz.conf.Konfiguracja;
import pl.gov.gugik.gesut.dak.biz.kontrole.executory.KontrolaExecutor;
import pl.gov.gugik.gesut.dak.biz.kontrole.fabryki.KontrolaFactory;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BladParsowaniaSzablonuWeryfikacjiException;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BrakSzablonuWeryfikacjiException;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.GrupaKontroliAtrybutowych;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.SzablonKontroli;

public class KontrolaService {
    private static final Logger log = Logger.getLogger(KontrolaService.class);
    private static final String BUNDLE_BLAD_PARSOWANIA_PLIKU_SZABLONU_KONTROLI = "kontrole.bledy.bladParsowaniaPlikuSzablonuKontroli";
    private KontrolaFactory kontrolaFactory = new KontrolaFactory();
    private String wersjaSzablonuKontroli;
    private ResourceBundle bundle;

    public KontrolaService() {
        Konfiguracja.getInstancja();
        this.bundle = Konfiguracja.getBundle();
    }

    public List<KontrolaExecutor> budujListeKontroli(String sciezkaDoPlikuKontroli) throws BrakSzablonuWeryfikacjiException, BladParsowaniaSzablonuWeryfikacjiException {
        ArrayList<KontrolaExecutor> ret = new ArrayList<KontrolaExecutor>();
        SzablonKontroli szablonKontroli = this.parsujPlikKontroli(sciezkaDoPlikuKontroli);
        this.wersjaSzablonuKontroli = szablonKontroli.getVersion();
        this.przetworzGrupyKlas(szablonKontroli);
        szablonKontroli.getKomponent().getMechanizmKontroliAtrybutowych().getGrupaKontroliAtrybutowych().forEach(grupaKontroliAtrybutowych -> ret.addAll(this.kontrolaFactory.budujListeKontroli((GrupaKontroliAtrybutowych)grupaKontroliAtrybutowych)));
        return ret;
    }

    private void przetworzGrupyKlas(SzablonKontroli szablonKontroli) {
        szablonKontroli.getKomponent().getGrupyKlas().getGrupaDefinicja().forEach(gr -> {
            String nazwaGrupy = gr.getNazwa();
            ArrayList nazwyKlas = new ArrayList();
            gr.getKlasy().getKlasa().forEach(klasa -> nazwyKlas.add(klasa));
            this.kontrolaFactory.getGrupyKlas().put(nazwaGrupy, nazwyKlas);
        });
    }

    private SzablonKontroli parsujPlikKontroli(String sciezkaDoPlikuKontroli) throws BrakSzablonuWeryfikacjiException, BladParsowaniaSzablonuWeryfikacjiException {
        File plik = new File(sciezkaDoPlikuKontroli);
        if (!plik.exists() && !plik.isDirectory()) {
            throw new BrakSzablonuWeryfikacjiException(sciezkaDoPlikuKontroli);
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SzablonKontroli.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (SzablonKontroli)jaxbUnmarshaller.unmarshal(plik);
        }
        catch (JAXBException e) {
            log.error((Object)e);
            throw new BladParsowaniaSzablonuWeryfikacjiException(this.bundle.getString(BUNDLE_BLAD_PARSOWANIA_PLIKU_SZABLONU_KONTROLI));
        }
    }

    public String getWersjaSzablonuKontroli() {
        return this.wersjaSzablonuKontroli;
    }

    public void setWersjaSzablonuKontroli(String wersjaSzablonuKontroli) {
        this.wersjaSzablonuKontroli = wersjaSzablonuKontroli;
    }
}

