/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.kontrole;

import java.io.FileNotFoundException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import pl.gov.gugik.gesut.dak.biz.kontrole.KontrolaTask;
import pl.gov.gugik.gesut.dak.biz.kontrole.executory.KontrolaExecutor;
import pl.gov.gugik.gesut.dak.biz.utils.KomunikatyUtils;
import pl.gov.gugik.gesut.dak.biz.utils.parser.DomStaxParser;
import pl.gov.gugik.gesut.dak.biz.utils.parser.procesory.WykonajKontroleTagProcesor;
import pl.gov.gugik.gesut.dak.biz.utils.parser.procesory.ZliczObiektyTagProcesor;
import pl.gov.gugik.gesut.dak.model.kontrole.ParametryKontroliPliku;

public class KontroleAtrybutoweService {
    private KontrolaTask<Void> kontrolaTask;
    private DomStaxParser domStaxParser;
    private ParametryKontroliPliku parametryKontroliPliku;
    private List<KontrolaExecutor> listaKontroli;

    public void wykonajKontrole(ParametryKontroliPliku parametryKontroli, List<KontrolaExecutor> listaKontroli) {
        this.domStaxParser = new DomStaxParser();
        this.parametryKontroliPliku = parametryKontroli;
        this.listaKontroli = listaKontroli;
        this.zliczObiekty();
        this.uruchomListeKontroli();
    }

    private void zliczObiekty() {
        ZliczObiektyTagProcesor zliczObiektyTagProcesor = new ZliczObiektyTagProcesor();
        this.domStaxParser.dodajProcesor(zliczObiektyTagProcesor);
        zliczObiektyTagProcesor.setLiczbaObiektow(0);
        zliczObiektyTagProcesor.setKontrolaTask(this.kontrolaTask);
    }

    private void uruchomListeKontroli() {
        WykonajKontroleTagProcesor wykonajKontroleTagProcesor = new WykonajKontroleTagProcesor();
        wykonajKontroleTagProcesor.setKontrolaTask(this.kontrolaTask);
        wykonajKontroleTagProcesor.setListaKontroli(this.listaKontroli);
        wykonajKontroleTagProcesor.setBledyWeryfikacjiService(this.kontrolaTask.getBledyWeryfikacjiService());
        this.domStaxParser.dodajProcesor(wykonajKontroleTagProcesor);
        this.parsuj(this.domStaxParser, this.parametryKontroliPliku);
    }

    private void parsuj(DomStaxParser domStaxParser, ParametryKontroliPliku parametryKontroli) {
        try {
            domStaxParser.parsuj(parametryKontroli.sciezkaPlikuDoKontroliProperty().getValue());
        }
        catch (FileNotFoundException e) {
            KomunikatyUtils.budujAlertBledu("Plik nie zosta\u0142 znaleziony: " + parametryKontroli.sciezkaPlikuDoKontroliProperty().getValue()).showAndWait();
        }
        catch (XMLStreamException | TransformerException e) {
            KomunikatyUtils.budujAlertBledu("B\u0142\u0105d parsowania pliku XML").showAndWait();
        }
    }

    public void setKontrolaTask(KontrolaTask kontrolaTask) {
        this.kontrolaTask = kontrolaTask;
    }
}

