/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.kontrole;

import java.io.File;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;
import pl.gov.gugik.gesut.dak.Aplikacja;
import pl.gov.gugik.gesut.dak.biz.conf.Konfiguracja;
import pl.gov.gugik.gesut.dak.enumy.RodzajPlikuEnum;
import pl.gov.gugik.gesut.dak.model.kontrole.OgolneParametryKontroli;

public class ParametryKontroliService {
    private static final Logger log = Logger.getLogger(ParametryKontroliService.class);

    public static OgolneParametryKontroli inicjujParametryKontroli() {
        OgolneParametryKontroli ogolneParametryKontroli = new OgolneParametryKontroli();
        ogolneParametryKontroli.sciezkaDoSzablonuKontroliProperty().setValue(ParametryKontroliService.pobierzWartoscZPreferencji(RodzajPlikuEnum.SZABLON_KONTROLI));
        if (ogolneParametryKontroli.getSciezkaDoSzablonuKontroli() == null) {
            String sciezkaSzablonu = new File("").getAbsolutePath() + Konfiguracja.getInstancja().pobierzString("szablonKontroli");
            ogolneParametryKontroli.setSciezkaDoSzablonuKontroli(sciezkaSzablonu);
        }
        ogolneParametryKontroli.sciezkaDoSchematuAplikacyjnegoProperty().setValue(ParametryKontroliService.pobierzWartoscZPreferencji(RodzajPlikuEnum.SCHEMAT_APLIKACYJNY));
        if (ogolneParametryKontroli.getSciezkaDoSchematuAplikacyjnego() == null) {
            String sciezkaSchematu = new File("").getAbsolutePath() + Konfiguracja.getInstancja().pobierzString("schematAplikacji");
            ogolneParametryKontroli.setSciezkaDoSchematuAplikacyjnego(sciezkaSchematu);
        }
        ogolneParametryKontroli.sciezkaDoOstatniegoFolderuPlikowDoKontroliProperty().setValue(ParametryKontroliService.pobierzWartoscZPreferencji(RodzajPlikuEnum.FOLDER_PLIOW_DO_KONTROLI));
        String sciezkaRaportow = ParametryKontroliService.pobierzWartoscZPreferencji(RodzajPlikuEnum.FOLDER_DO_RAPORTU);
        if (sciezkaRaportow != null && new File(sciezkaRaportow).exists()) {
            ogolneParametryKontroli.sciezkaDoOstatniegoFolderuRaportowProperty().setValue(sciezkaRaportow);
            ogolneParametryKontroli.sciezkaWybranegoFolderuRaportowProperty().setValue(sciezkaRaportow);
        }
        ogolneParametryKontroli.setCzyRaportCSV(true);
        ogolneParametryKontroli.setCzyRaportPDF(true);
        ogolneParametryKontroli.setCzyKontroleAtrybutowe(false);
        return ogolneParametryKontroli;
    }

    private static String pobierzWartoscZPreferencji(RodzajPlikuEnum rodzajPliku) {
        Preferences preferencje = Preferences.userNodeForPackage(Aplikacja.class);
        String sciezka = preferencje.get(rodzajPliku.getWartosc(), null);
        return sciezka;
    }
}

