/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.kontrole;

import java.util.List;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import org.apache.log4j.Logger;
import pl.gov.gugik.gesut.dak.biz.conf.Konfiguracja;
import pl.gov.gugik.gesut.dak.biz.kontrole.KontrolaTask;
import pl.gov.gugik.gesut.dak.biz.kontrole.executory.KontrolaExecutor;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.KontrolaService;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BladParsowaniaSzablonuWeryfikacjiException;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BrakSzablonuWeryfikacjiException;
import pl.gov.gugik.gesut.dak.model.PlikWynikowy;
import pl.gov.gugik.gesut.dak.model.kontrole.OgolneParametryKontroli;

public class WykonajKontroleService<Void>
extends Service<Void> {
    private static final Logger log = Logger.getLogger(WykonajKontroleService.class);
    private static final String BUNDLE_NIE_WSKAZANO_PLIKU_SZABLONU_WERYFIKACJI = "kontrole.bledy.nieWskazanoPlikuSzablonuWeryfikacji";
    private static final String BUNDLE_BLAD_PARSOWANIA_PLIKU_SZABLONU_KONTROLI = "kontrole.bledy.bladParsowaniaPlikuSzablonuKontroli";
    private OgolneParametryKontroli ogolneParametryKontroli;
    private PlikWynikowy plikWynikowy;
    private KontrolaService kontrolaService = new KontrolaService();
    private Throwable lastException = null;
    private String lastMessage = null;

    protected Task<Void> createTask() {
        List<KontrolaExecutor> listaKontroli = null;
        if (this.ogolneParametryKontroli.czyKontroleAtrybutoweProperty().get()) {
            try {
                listaKontroli = this.kontrolaService.budujListeKontroli(this.ogolneParametryKontroli.getSciezkaDoSzablonuKontroli());
            }
            catch (BrakSzablonuWeryfikacjiException e) {
                log.error((Object)e);
                this.lastException = e;
                this.lastMessage = Konfiguracja.getBundle().getString(BUNDLE_NIE_WSKAZANO_PLIKU_SZABLONU_WERYFIKACJI);
                return new KontrolaTask();
            }
            catch (BladParsowaniaSzablonuWeryfikacjiException e) {
                this.lastException = e;
                this.lastMessage = Konfiguracja.getBundle().getString(BUNDLE_BLAD_PARSOWANIA_PLIKU_SZABLONU_KONTROLI);
                return new KontrolaTask();
            }
        }
        KontrolaTask kontrolaTask = new KontrolaTask();
        kontrolaTask.exceptionProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && newValue instanceof Throwable) {
                this.lastException = (Throwable)newValue;
            }
        });
        kontrolaTask.setOgolneParametryKontroli(this.ogolneParametryKontroli);
        kontrolaTask.setPlikWynikowy(this.plikWynikowy);
        kontrolaTask.setListaKontroli(listaKontroli);
        kontrolaTask.setWersjaSzablonuKontroli(this.kontrolaService.getWersjaSzablonuKontroli());
        return kontrolaTask;
    }

    public void setOgolneParametryKontroli(OgolneParametryKontroli ogolneParametryKontroli) {
        this.ogolneParametryKontroli = ogolneParametryKontroli;
    }

    public void setPlikWynikowy(PlikWynikowy plikWynikowy) {
        this.plikWynikowy = plikWynikowy;
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }
}

