/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.log4j.Logger;
import pl.gov.gugik.gesut.dak.biz.conf.Konfiguracja;
import pl.gov.gugik.gesut.dak.biz.service.handlery.KonfiguracjaHandler;
import pl.gov.gugik.gesut.dak.biz.utils.DateUtils;

public class ObslugaWyjatkowService {
    private static final Logger log = Logger.getLogger(ObslugaWyjatkowService.class);
    private static ObslugaWyjatkowService instancja;
    private String sciezkaLogu;
    private PrintWriter printWriter;
    private KonfiguracjaHandler konfiguracjaHandler;

    private ObslugaWyjatkowService() {
        File katalogLogu = new File(Konfiguracja.getInstancja().pobierzString("katalogLogow"));
        if (!katalogLogu.exists()) {
            katalogLogu.mkdirs();
        }
        this.sciezkaLogu = katalogLogu.getAbsolutePath() + File.separator + "kgesut-dak-" + DateUtils.formatujDate(new Date(), "yyyy_MM_dd_HH_mm_ss") + ".err";
        this.konfiguracjaHandler = new KonfiguracjaHandler();
    }

    public static ObslugaWyjatkowService pobierzInstancje() {
        if (instancja == null) {
            instancja = new ObslugaWyjatkowService();
        }
        return instancja;
    }

    private void otworzPlikLogu() throws FileNotFoundException {
        this.printWriter = new PrintWriter(new File(this.sciezkaLogu));
    }

    public void dodajWyjatek(Throwable e) {
        if (this.printWriter == null) {
            try {
                this.otworzPlikLogu();
            }
            catch (FileNotFoundException e1) {
                log.error((Object)e);
            }
        }
        e.printStackTrace(this.printWriter);
        e.printStackTrace();
        this.printWriter.flush();
        if (this.konfiguracjaHandler.czyDebug()) {
            log.error((Object)e);
        }
    }
}

