/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.pliki;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import pl.gov.gugik.gesut.dak.biz.conf.Konfiguracja;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;

public class PlikiTymczasoweService {
    private static final String PODFOLDER_TYMCZASOWY = "daktmp";
    private static final String TMP_FILE_PREFIX = "dak_";
    private static PlikiTymczasoweService _instancja;
    private List<File> listaPlikowTymczasowych = new ArrayList<File>();
    private File podfolderTymczasowyFile;

    private PlikiTymczasoweService() {
        String prefix = System.getProperty("java.io.tmpdir");
        if (Konfiguracja.getInstancja().pobierzBool("czyLokalnyKatalogTMP").booleanValue()) {
            prefix = new File(".").getAbsolutePath();
        }
        String katalog = prefix + File.separator + PODFOLDER_TYMCZASOWY;
        this.podfolderTymczasowyFile = new File(katalog);
        if (!this.podfolderTymczasowyFile.exists()) {
            this.podfolderTymczasowyFile.mkdirs();
            this.podfolderTymczasowyFile.deleteOnExit();
        } else {
            this.wyczyscZawartoscKataloguTymczasowego();
        }
    }

    private void wyczyscZawartoscKataloguTymczasowego() {
        File[] pliki;
        for (File plik : pliki = this.podfolderTymczasowyFile.listFiles()) {
            if (plik.isFile()) {
                plik.delete();
                continue;
            }
            if (!plik.isDirectory()) continue;
            try {
                FileUtils.deleteDirectory((File)plik);
            }
            catch (IOException e) {
                ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
            }
        }
    }

    public static PlikiTymczasoweService pobierzInstancje() {
        if (_instancja == null) {
            _instancja = new PlikiTymczasoweService();
        }
        return _instancja;
    }

    public void zarejestrujPlikTymczasowy(File plikTymczasowy) {
        this.listaPlikowTymczasowych.add(plikTymczasowy);
    }

    public void usunPlikiTymczasowe() {
        System.gc();
        this.listaPlikowTymczasowych.forEach(plik -> {
            if (plik.exists()) {
                plik.delete();
            }
        });
    }

    public void utworzIZarejestrujKatalogTymczasowySQLite() {
        System.setProperty("org.sqlite.tmpdir", this.podfolderTymczasowyFile.getAbsolutePath());
    }

    public File tworzPlikTymczasowy(String suffix) throws IOException {
        File plikTymczasowy = File.createTempFile(TMP_FILE_PREFIX, suffix, this.podfolderTymczasowyFile);
        plikTymczasowy.deleteOnExit();
        this.listaPlikowTymczasowych.add(plikTymczasowy);
        return plikTymczasowy;
    }

    public String pobierzKatalogTymczasowy() {
        return this.podfolderTymczasowyFile.getAbsolutePath();
    }
}

