/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.utils;

import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.stage.Window;
import pl.gov.gugik.gesut.dak.biz.conf.Konfiguracja;
import pl.gov.gugik.gesut.dak.kontrolery.komponenty.AlertDialog;
import pl.gov.gugik.gesut.dak.model.kontrole.OgolneParametryKontroli;
import pl.gov.gugik.gesut.dak.model.kontrole.ParametryKontroliPliku;

public class KomunikatyUtils {
    private static final String APP_ICON = "img/sygnet.png";
    private static final String BUNDLE_BLAD_APLIKACJI = "bladAplikacji";
    private static final String BUNDLE_INFORMACJA_O_BLEDZIE = "informacjaOBledzie";
    private static final String BUNDLE_INFORMACJA = "informacja";
    private static final String BUNDLE_WYNIK_WERYFIKACJI = "kontrola.wynikWeryfikacji";
    private static final String BUNDLE_PROSZE_WPROWADZIC_POPRAWNE_DANE_WEJSCIOWE = "kontrole.bledy.proszeWprowadzicPoprawneDaneWejsciowe";
    private static final String BUNDLE_NIEPOPRAWNE_DANE_WEJSCIOWE = "kontrole.bledy.niepoprawneDaneWejsciowe";

    private KomunikatyUtils() {
    }

    public static AlertDialog budujAlertBledu(String header, String content) {
        return KomunikatyUtils.budujAlert(AlertDialog.Type.ERROR, header, Konfiguracja.getBundle().getString(BUNDLE_BLAD_APLIKACJI), content);
    }

    public static AlertDialog budujAlertBledu(String header) {
        return KomunikatyUtils.budujAlert(AlertDialog.Type.ERROR, header, Konfiguracja.getBundle().getString(BUNDLE_BLAD_APLIKACJI), null);
    }

    public static AlertDialog budujAlertBleduWalidacji(String header, String content) {
        return KomunikatyUtils.budujAlert(AlertDialog.Type.ERROR, header, Konfiguracja.getBundle().getString(BUNDLE_INFORMACJA_O_BLEDZIE), content);
    }

    public static AlertDialog budujAlertBleduWalidacji(String header) {
        return KomunikatyUtils.budujAlert(AlertDialog.Type.ERROR, header, Konfiguracja.getBundle().getString(BUNDLE_INFORMACJA_O_BLEDZIE), null);
    }

    public static AlertDialog budujAlertInfo(String header, String content) {
        return KomunikatyUtils.budujAlert(AlertDialog.Type.INFO, header, Konfiguracja.getBundle().getString(BUNDLE_INFORMACJA), content);
    }

    public static AlertDialog budujAlert(AlertDialog.Type typ, String header, String title, String content) {
        AlertDialog alert = new AlertDialog(typ, title, header, content, APP_ICON);
        return alert;
    }

    public static void wyswietlKomunikatBledowWalidacji(String komunikatyBledow, Window okno) {
        AlertDialog alert = new AlertDialog(AlertDialog.Type.ERROR, Konfiguracja.getBundle().getString(BUNDLE_NIEPOPRAWNE_DANE_WEJSCIOWE), Konfiguracja.getBundle().getString(BUNDLE_PROSZE_WPROWADZIC_POPRAWNE_DANE_WEJSCIOWE), komunikatyBledow, APP_ICON);
        alert.showAndWait();
    }

    public static String zwrocPosortowanaListePlikow(List<ParametryKontroliPliku> plikiDoKontroli) {
        return plikiDoKontroli.stream().map(ParametryKontroliPliku::getNazwaPliku).sorted(String::compareToIgnoreCase).collect(Collectors.joining("\n"));
    }

    public static void budujIWyswietlAlertBleduWalidacji(String header, String content) {
        AlertDialog alert = KomunikatyUtils.budujAlertBleduWalidacji(header, content);
        alert.showAndWait();
    }

    public static void bubudujIWyswietlAlertInfo(String header, String content) {
        AlertDialog alert = KomunikatyUtils.budujAlertInfo(header, content);
        alert.showAndWait();
    }

    public static void wyswietlPodsumowanieKontroli(OgolneParametryKontroli parametryKontroli, String tytul) {
        String wyniki = parametryKontroli.getWynikiKontroli().entrySet().stream().sorted((o1, o2) -> ((String)o1.getKey()).compareToIgnoreCase((String)o2.getKey())).map(p -> (String)p.getKey() + " - " + (String)p.getValue()).collect(Collectors.joining("\n"));
        Platform.runLater(() -> KomunikatyUtils.wyswietOknoInformacyjne(tytul, Konfiguracja.getBundle().getString(BUNDLE_WYNIK_WERYFIKACJI), wyniki));
    }

    public static void wyswietOknoInformacyjne(String tytul, String nagolowek, String tresc) {
        AlertDialog alert = new AlertDialog(AlertDialog.Type.INFO, tytul, nagolowek, tresc, APP_ICON);
        alert.showAndWait();
    }
}

