/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.utils.kontrole;

import com.google.common.base.Strings;
import java.time.LocalDateTime;
import org.apache.log4j.Logger;
import org.joox.Match;
import pl.gov.gugik.gesut.dak.biz.utils.DateUtils;
import pl.gov.gugik.gesut.dak.enumy.TypDanychEnum;
import pl.gov.gugik.gesut.dak.enumy.WartosciSpecjalneEnum;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.Atrybut;

public class ObiektHelper {
    private static final Logger log = Logger.getLogger(ObiektHelper.class);
    public static final String SYSDATE = "SYSDATE";
    public static final String TRUE = "true";
    public static final String ATTR_NIL = "nil";
    public static final String ATTR_NIL_REASON = "nilReason";
    public static final String ATTR_SRS_NAME = "srsName";
    public static final String ANY = "any";
    public static final String NULL = "null";

    private ObiektHelper() {
    }

    public static String pobierzIdLokalny(Match feature) {
        return feature.child("idIIP").child("BT_Identyfikator").child("lokalnyId").text();
    }

    public static String pobierzGmlId(Match feature) {
        return feature.attr("id");
    }

    public static String pobierzNazweDoRaportu(Atrybut atrybut) {
        if (atrybut != null && atrybut.getNazwaDoRaportu() != null) {
            return atrybut.getNazwaDoRaportu();
        }
        if (atrybut.getPodrzedny() != null && atrybut.getPodrzedny().getAtrybut() != null) {
            return ObiektHelper.pobierzNazweDoRaportu(atrybut.getPodrzedny().getAtrybut());
        }
        return null;
    }

    public static Match pobierzWartoscAtrybutu(Match feature, Atrybut atrybut) {
        Match match = feature;
        Atrybut atrybutTymczasowy = atrybut;
        if (atrybutTymczasowy.getNazwaAtrybutu() != null) {
            match = feature.children(atrybutTymczasowy.getNazwaAtrybutu());
        }
        if (atrybutTymczasowy.getPodrzedny() != null) {
            match = match.children(atrybutTymczasowy.getPodrzedny().getNazwaAtrybutu());
            atrybutTymczasowy = atrybutTymczasowy.getPodrzedny().getAtrybut();
            match = match.find(atrybutTymczasowy.getNazwaAtrybutu());
        }
        return match;
    }

    public static String pobierzWartoscAtrybutuAtrybutuDoRaportu(Match feature, Atrybut atrybut) {
        String nazwaAtrybutu;
        Match obiekt;
        Match obiektAtrybutu = ObiektHelper.pobierzWartoscAtrybutu(feature, atrybut);
        if (obiektAtrybutu.isNotEmpty()) {
            String wartosc = obiektAtrybutu.text();
            if (Strings.isNullOrEmpty((String)wartosc) && obiektAtrybutu.get(0).getTagName().equalsIgnoreCase("ges:adresPRG")) {
                return obiektAtrybutu.get(0).getAttribute("xlink:href");
            }
            return obiektAtrybutu.text();
        }
        if (ObiektHelper.zwrocNazweAtrybutu(atrybut).contains("_nilReason")) {
            String nazwaAtrybutu2 = ObiektHelper.zwrocNazweAtrybutu(atrybut).split("_")[0];
            Match obiektZNil = feature.find(nazwaAtrybutu2);
            return obiektZNil.attr(ATTR_NIL_REASON);
        }
        if (ObiektHelper.zwrocNazweAtrybutu(atrybut).contains("_srsName") && (obiekt = feature.find(nazwaAtrybutu = ObiektHelper.zwrocNazweAtrybutu(atrybut).split("_")[0])).isNotEmpty()) {
            Match geometria = obiekt.child();
            return geometria.attr(ATTR_SRS_NAME);
        }
        return null;
    }

    public static Object rzutujNaTyp(String wartosc, TypDanychEnum typDanych) {
        if (Strings.isNullOrEmpty((String)wartosc)) {
            return null;
        }
        switch (typDanych) {
            case STRING: {
                return wartosc;
            }
            case INTEGER: {
                return Integer.parseInt(wartosc);
            }
            case DATE: {
                if (SYSDATE.equalsIgnoreCase(wartosc)) {
                    return LocalDateTime.now();
                }
                return DateUtils.parsujDateLDT(wartosc);
            }
            case DOUBLE: {
                return Double.parseDouble(wartosc);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(wartosc);
            }
        }
        return null;
    }

    public static Object rzutujNaTyp(String wartosc, String typ) {
        TypDanychEnum typDanych;
        try {
            typDanych = TypDanychEnum.valueOf(typ.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Blad rzutowania wartosci: " + wartosc + ", typ: " + typ), (Throwable)e);
            return null;
        }
        return ObiektHelper.rzutujNaTyp(wartosc, typDanych);
    }

    public static Boolean czySpelnioneWartosciSpecjalne(String wartoscAtrybutu, String wartoscZeZbioru, Match obiektAtrybutu) {
        WartosciSpecjalneEnum wartoscSpecjalna;
        try {
            wartoscSpecjalna = WartosciSpecjalneEnum.valueOf(wartoscZeZbioru.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        switch (wartoscSpecjalna) {
            case ANY: {
                return wartoscAtrybutu != null && !wartoscAtrybutu.isEmpty();
            }
            case NULL: {
                return wartoscAtrybutu == null;
            }
        }
        return null;
    }

    public static Boolean parsujBoolean(String bool) {
        if ("TAK".equalsIgnoreCase(bool)) {
            return true;
        }
        if ("NIE".equalsIgnoreCase(bool)) {
            return false;
        }
        return null;
    }

    public static String pobierzNazweAtrybutu(Atrybut atrybut) {
        if (atrybut == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Atrybut atrybutTymczasowy = atrybut;
        if (atrybutTymczasowy.getNazwaAtrybutu() != null) {
            stringBuilder.append(atrybutTymczasowy.getNazwaAtrybutu());
        }
        while (atrybutTymczasowy.getPodrzedny() != null) {
            stringBuilder.append(atrybutTymczasowy.getPodrzedny().getNazwaAtrybutu());
            atrybutTymczasowy = atrybutTymczasowy.getPodrzedny().getAtrybut();
        }
        if (atrybutTymczasowy.getNazwaAtrybutu() != null && !stringBuilder.toString().equals(atrybutTymczasowy.getNazwaAtrybutu())) {
            stringBuilder.append(":");
            stringBuilder.append(atrybutTymczasowy.getNazwaAtrybutu());
        }
        return stringBuilder.toString();
    }

    public static String zwrocNazweAtrybutu(Atrybut atrybut) {
        if (atrybut == null) {
            return null;
        }
        if (atrybut.getNazwaAtrybutu() == null) {
            return ObiektHelper.zwrocNazweAtrybutu(atrybut.getPodrzedny().getAtrybut());
        }
        return atrybut.getNazwaAtrybutu();
    }

    public static boolean czyElementNil(Match obiektAtrybutu) {
        String wartoscEl = obiektAtrybutu.attr(ATTR_NIL);
        return !Strings.isNullOrEmpty((String)wartoscEl) && TRUE.equals(wartoscEl);
    }

    public static boolean czyWypelnionyNilElementNadrzedny(Match obiekt, Atrybut atrybut) {
        String nazwaAtrybutuNadrzednego;
        Match obiektNadrzedny;
        return atrybut.getNazwaAtrybutu() == null && atrybut.getPodrzedny() != null && (obiektNadrzedny = obiekt.find(nazwaAtrybutuNadrzednego = atrybut.getPodrzedny().getNazwaAtrybutu())) != null && obiektNadrzedny.attr(ATTR_NIL) != null;
    }
}

