/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.utils.walidacja;

import com.sun.org.apache.xerces.internal.dom.DOMInputImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;

class SciezkaWzglednaResourceResolver
implements LSResourceResolver {
    private String sciezkaCacheXsd;
    private Map<String, File> mapaCache = new HashMap<String, File>();
    private boolean czyWszystkiePliki = true;
    private String brakujacyPlik = null;

    public SciezkaWzglednaResourceResolver() {
        this.sciezkaCacheXsd = this.budujSciezkeXSD();
    }

    private String budujSciezkeXSD() {
        StringBuffer sb = new StringBuffer(new File(".").getAbsolutePath());
        sb.append(File.separator);
        sb.append("konfiguracja");
        sb.append(File.separator);
        sb.append("xsd");
        return sb.toString();
    }

    private URI wygenerujURIDlaSystemID(URI baseURI, String systemId) throws URISyntaxException {
        if (systemId == null) {
            return baseURI;
        }
        if (systemId.startsWith("http") || systemId.startsWith("https")) {
            return new URI(systemId);
        }
        URI related = baseURI.resolve(systemId);
        return related;
    }

    private String budujKatalogCacheDlaURI(URI uri) {
        return this.sciezkaCacheXsd + File.separator + uri.getHost() + uri.getPath();
    }

    public File serwujPlikZCache(URI uri) throws IOException {
        if (uri.getScheme().equalsIgnoreCase("file")) {
            return new File(uri);
        }
        if (uri.getScheme().equalsIgnoreCase("http") || uri.getScheme().equalsIgnoreCase("https")) {
            File plikCache = new File(this.budujKatalogCacheDlaURI(uri));
            if (!plikCache.exists()) {
                if (!plikCache.getParentFile().exists()) {
                    plikCache.getParentFile().mkdirs();
                }
                URL url = uri.toURL();
                ReadableByteChannel rbc = Channels.newChannel(url.openStream());
                this.otworzPlikCache(plikCache, rbc);
            }
            this.mapaCache.put(uri.toString(), plikCache);
            return plikCache;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void otworzPlikCache(File plikCache, ReadableByteChannel rbc) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(plikCache);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
    }

    private LSInput budujInputDlaPliku(File plik, String publicId, String systemId, String baseURI) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(plik);
        return new DOMInputImpl(publicId, systemId, baseURI, fis, null);
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        try {
            URI uri = new URI(baseURI);
            URI plikDoPrzetworzenia = this.wygenerujURIDlaSystemID(uri, systemId);
            File plik = this.mapaCache.containsKey(plikDoPrzetworzenia.toString()) ? this.mapaCache.get(plikDoPrzetworzenia) : this.serwujPlikZCache(plikDoPrzetworzenia);
            if (plik == null || !plik.exists()) {
                this.czyWszystkiePliki = false;
                if (plik != null) {
                    this.brakujacyPlik = plik.getName();
                }
                return null;
            }
            return this.budujInputDlaPliku(plik, publicId, systemId, baseURI);
        }
        catch (IOException | URISyntaxException e) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
            this.czyWszystkiePliki = false;
            return null;
        }
    }

    public boolean isCzyWszystkiePliki() {
        return this.czyWszystkiePliki;
    }

    public String pobierzNazweBrakujacegoPliku() {
        return this.brakujacyPlik;
    }
}

