/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;
import pl.gov.gugik.gesut.dak.dao.BladKontroliTableHelper;
import pl.gov.gugik.gesut.dak.dao.BladWeryfikacjiTable;
import pl.gov.gugik.gesut.dak.dao.ResultSetIterator;
import pl.gov.gugik.gesut.dak.dao.wyjatki.BladSQLException;
import pl.gov.gugik.gesut.dak.model.kontrole.BladKontroli;

public class BledyKontroliTable
implements BladWeryfikacjiTable<BladKontroli> {
    private static final Logger log = Logger.getLogger(BledyKontroliTable.class);
    private Connection connection;
    private Statement statement;
    private List<String> kolumnyBledowKontroliBezRowId = BladKontroliTableHelper.getColumnsWithoutRowId();

    public BledyKontroliTable(Connection conn, Statement stmt) {
        this.connection = conn;
        this.statement = stmt;
    }

    public List<String> pobierzGrupyKontroliDlaPliku(String plik) throws BladSQLException {
        try {
            String selectQuery = "select DISTINCT grupa_kontroli from blad_kontroli WHERE nazwa_pliku=?";
            PreparedStatement preparedStatement = this.connection.prepareStatement(selectQuery);
            preparedStatement.setString(1, plik);
            ResultSet resultSet = this.statement.executeQuery(selectQuery);
            ArrayList<String> listaGrup = new ArrayList<String>();
            while (resultSet.next()) {
                listaGrup.add(resultSet.getString(1));
            }
            return listaGrup;
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas pobierania z  bazy danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas pobierania z bazy danych", e);
        }
    }

    public int pobierzLiczbeBledowKontroli(String plik, String idKontroli) throws BladSQLException {
        String selectQuery = "select COUNT(*) from blad_kontroli where nazwa_pliku=?";
        if (idKontroli != null) {
            selectQuery = selectQuery + "and id_kont=?";
        }
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(selectQuery);
            preparedStatement.setString(1, plik);
            if (idKontroli != null) {
                preparedStatement.setString(2, idKontroli);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            int liczba = 0;
            while (resultSet.next()) {
                liczba = resultSet.getInt(1);
            }
            resultSet.close();
            return liczba;
        }
        catch (SQLException e) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
            return 0;
        }
    }

    public ResultSetIterator<BladKontroli> pobierzIteratorBledowKontroli(String plik, String idKontroli, boolean max10) throws BladSQLException {
        String selectQuery = "select rowid, * from blad_kontroli where nazwa_pliku=?";
        if (idKontroli != null) {
            selectQuery = selectQuery + "and id_kont=?";
        }
        if (max10) {
            selectQuery = selectQuery + " LIMIT 10";
        }
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(selectQuery);
            preparedStatement.setString(1, plik);
            if (idKontroli != null) {
                preparedStatement.setString(2, idKontroli);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            return new ResultSetIterator<BladKontroli>(resultSet){

                @Override
                protected BladKontroli konwertujNaObiekt() {
                    BladKontroli blad = null;
                    try {
                        blad = BladKontroli.builder().rowId(this.resultSet.getString("rowid")).nazwaPliku(this.resultSet.getString("nazwa_pliku")).grupaKontroli(this.resultSet.getString("grupa_kontroli")).idKont(this.resultSet.getString("id_kont")).nazwaKontroli(this.resultSet.getString("nazwa_kontroli")).komunikat(this.resultSet.getString("komunikat")).klasa(this.resultSet.getString("klasa")).idLokalne(this.resultSet.getString("id_lok")).gmlId(this.resultSet.getString("gml_id")).attr1Naz(this.resultSet.getString("atr1_naz")).attr1Wart(this.resultSet.getString("atr1_wart")).attr2Naz(this.resultSet.getString("atr2_naz")).attr2Wart(this.resultSet.getString("atr2_wart")).attr3Naz(this.resultSet.getString("atr3_naz")).attr3Wart(this.resultSet.getString("atr3_wart")).build();
                    }
                    catch (SQLException e) {
                        ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(e);
                        return null;
                    }
                    return blad;
                }
            };
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas pobierania z  bazy danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas pobierania z bazy danych", e);
        }
    }

    @Override
    public List<BladKontroli> findAll() throws BladSQLException {
        try {
            String selectQuery = "select rowid, * from blad_kontroli";
            ResultSet resultSet = this.statement.executeQuery(selectQuery);
            return BledyKontroliTable.parseResult(resultSet);
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas pobierania z  bazy danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas pobierania z bazy danych", e);
        }
    }

    @Override
    public void save(BladKontroli blad) throws BladSQLException {
        if (blad == null) {
            return;
        }
        try {
            PreparedStatement statement = this.przygotujStatement();
            this.setValues(statement, blad);
            statement.executeBatch();
            this.connection.commit();
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas zapisu w bazie danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas zapisu w bazie danych", e);
        }
    }

    @Override
    public void save(List<BladKontroli> bledy) throws BladSQLException {
        try {
            PreparedStatement preparedStatement = this.przygotujStatement();
            for (BladKontroli bladKontroli : bledy) {
                this.setValues(preparedStatement, bladKontroli);
            }
            preparedStatement.executeBatch();
            this.connection.commit();
        }
        catch (SQLException e) {
            log.error((Object)"Blad podczas zapisu w bazie danych: ", (Throwable)e);
            throw new BladSQLException("Blad podczas zapisu w bazie danych", e);
        }
    }

    private PreparedStatement przygotujStatement() throws SQLException {
        String insertQuery = "insert into blad_kontroli ( " + this.kolumnyBledowKontroliBezRowId.stream().collect(Collectors.joining(", ")) + ") VALUES (" + this.kolumnyBledowKontroliBezRowId.stream().map(c -> "?").collect(Collectors.joining(", ")) + ")";
        return this.connection.prepareStatement(insertQuery);
    }

    private static List<BladKontroli> parseResult(ResultSet resultSet) throws SQLException {
        ArrayList<BladKontroli> bledy = new ArrayList<BladKontroli>();
        while (resultSet.next()) {
            BladKontroli blad = BladKontroli.builder().rowId(resultSet.getString("rowid")).nazwaPliku(resultSet.getString("nazwa_pliku")).grupaKontroli(resultSet.getString("grupa_kontroli")).idKont(resultSet.getString("id_kont")).nazwaKontroli(resultSet.getString("nazwa_kontroli")).komunikat(resultSet.getString("komunikat")).klasa(resultSet.getString("klasa")).idLokalne(resultSet.getString("id_lok")).gmlId(resultSet.getString("gml_id")).attr1Naz(resultSet.getString("atr1_naz")).attr1Wart(resultSet.getString("atr1_wart")).attr2Naz(resultSet.getString("atr2_naz")).attr2Wart(resultSet.getString("atr2_wart")).attr3Naz(resultSet.getString("atr3_naz")).attr3Wart(resultSet.getString("atr3_wart")).build();
            bledy.add(blad);
        }
        return bledy;
    }

    private void setValues(PreparedStatement preparedStatement, BladKontroli blad) throws SQLException {
        preparedStatement.setString(this.getIdx("nazwa_pliku"), blad.getNazwaPliku());
        preparedStatement.setString(this.getIdx("grupa_kontroli"), blad.getGrupaKontroli());
        preparedStatement.setString(this.getIdx("id_kont"), blad.getIdKont());
        preparedStatement.setString(this.getIdx("nazwa_kontroli"), blad.getNazwaKontroli());
        preparedStatement.setString(this.getIdx("komunikat"), blad.getKomunikat());
        preparedStatement.setString(this.getIdx("klasa"), blad.getKlasa());
        preparedStatement.setString(this.getIdx("id_lok"), blad.getIdLokalne());
        preparedStatement.setString(this.getIdx("gml_id"), blad.getGmlId());
        preparedStatement.setString(this.getIdx("atr1_naz"), blad.getAttr1Naz());
        preparedStatement.setString(this.getIdx("atr1_wart"), blad.getAttr1Wart());
        preparedStatement.setString(this.getIdx("atr2_naz"), blad.getAttr2Naz());
        preparedStatement.setString(this.getIdx("atr2_wart"), blad.getAttr2Wart());
        preparedStatement.setString(this.getIdx("atr3_naz"), blad.getAttr3Naz());
        preparedStatement.setString(this.getIdx("atr3_wart"), blad.getAttr3Wart());
        preparedStatement.addBatch();
    }

    private int getIdx(String columnName) {
        return this.getKolumnyBledowKontroliBezRowId().indexOf(columnName) + 1;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public List<String> getKolumnyBledowKontroliBezRowId() {
        return this.kolumnyBledowKontroliBezRowId;
    }
}

