/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.kontrolery;

import java.text.MessageFormat;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.BladParsowaniaXMLException;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.WykonajKontroleService;
import pl.gov.gugik.gesut.dak.biz.service.log.ObslugaWyjatkowService;
import pl.gov.gugik.gesut.dak.biz.utils.KomunikatyUtils;
import pl.gov.gugik.gesut.dak.biz.utils.WalidatorWejsciowyUtils;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BladWalidatoraXsd;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BrakPlikuXsdException;
import pl.gov.gugik.gesut.dak.enumy.RodzajPlikuEnum;
import pl.gov.gugik.gesut.dak.kontrolery.BazowyController;

public class KontroleContoller
extends BazowyController {
    private static final String BUNDLE_ZAKTUALIZOWANO_SCIEZKE = "zaktualizowanoSciezke";
    private static final String BUNDLE_INFORMACJA = "informacja";
    private static final String BUNDLE_BLEDY_BRAK_PLIKU_XSD = "kontrole.bledy.brakPlikuXsd";
    private static final String BUNDLE_BLEDY_NIEPOPRAWNY_PLIK_GML = "kontrola.bledy.niepoprawnyPlikGML";
    private static final String BUNDLE_OBECNIE_WERYFIKOWANY_PLIK = "kontrola.obecnieWeryfikowanyPlik";
    private static final String BUNDLE_BLAD_APLIKACJI = "blad_aplikacji";
    private WykonajKontroleService<Void> wykonajKontroleService;
    @FXML
    private Button wykonajKontroleButton;
    @FXML
    private Button wybierzKontrolowanyPlikButton;
    @FXML
    private Button przerwijKontroleButton;
    @FXML
    private TextArea logowanieArea;
    @FXML
    private RadioButton walidacjaXSD;
    @FXML
    private RadioButton kontroleAtrybutowe;
    @FXML
    private TextArea komunikatPlikowText;
    @FXML
    private CheckBox czyRaportPDF;
    @FXML
    private CheckBox czyRaportCSV;
    @FXML
    private TextField sciezkaDoRaportu;
    @FXML
    private TextField sciezkaDoSchematuAplikacyjnego;
    @FXML
    private TextField sciezkaDoSzablonuKontroli;
    @FXML
    private TitledPane ustawieniaOcjonalnePanel;
    @FXML
    private Button wyswietlWyborFolderuRaportuButton;
    @FXML
    private ProgressBar pasekPostepu;
    @FXML
    private Label licznik;
    @FXML
    private Label numerWeryfikowanegoPliku;
    @FXML
    private HBox licznikBox;
    ToggleGroup wyborTypuKontroli;

    @Override
    public void inicjujKontroler() {
        this.wyborTypuKontroli = new ToggleGroup();
        this.walidacjaXSD.setToggleGroup(this.wyborTypuKontroli);
        this.kontroleAtrybutowe.setToggleGroup(this.wyborTypuKontroli);
        this.wyborTypuKontroli.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> ov, Toggle old_toggle, Toggle new_toggle) {
                if (KontroleContoller.this.walidacjaXSD.isSelected()) {
                    KontroleContoller.this.aplikacja.getParametryKontroli().czyWalidacjaProperty().set(true);
                    KontroleContoller.this.aplikacja.getParametryKontroli().czyKontroleAtrybutoweProperty().set(false);
                } else if (KontroleContoller.this.kontroleAtrybutowe.isSelected()) {
                    KontroleContoller.this.aplikacja.getParametryKontroli().czyWalidacjaProperty().set(false);
                    KontroleContoller.this.aplikacja.getParametryKontroli().czyKontroleAtrybutoweProperty().set(true);
                } else {
                    KontroleContoller.this.aplikacja.getParametryKontroli().czyWalidacjaProperty().set(false);
                    KontroleContoller.this.aplikacja.getParametryKontroli().czyKontroleAtrybutoweProperty().set(false);
                }
            }
        });
        if (this.aplikacja.getParametryKontroli().czyKontroleAtrybutoweProperty().get()) {
            this.kontroleAtrybutowe.setSelected(true);
        } else {
            this.walidacjaXSD.setSelected(true);
        }
        this.czyRaportPDF.selectedProperty().bindBidirectional((Property)this.aplikacja.getParametryKontroli().czyRaportPDFProperty());
        this.czyRaportCSV.selectedProperty().bindBidirectional((Property)this.aplikacja.getParametryKontroli().czyRaportCSVProperty());
        this.komunikatPlikowText.setWrapText(true);
        this.licznikBox.setVisible(false);
        this.komunikatPlikowText.textProperty().bindBidirectional((Property)this.aplikacja.getParametryKontroli().komunikatPlikuDoKontroliProperty());
        this.sciezkaDoRaportu.textProperty().bindBidirectional((Property)this.aplikacja.getParametryKontroli().sciezkaWybranegoFolderuRaportowProperty());
        this.sciezkaDoSchematuAplikacyjnego.textProperty().bindBidirectional((Property)this.aplikacja.getParametryKontroli().sciezkaDoSchematuAplikacyjnegoProperty());
        this.sciezkaDoSzablonuKontroli.textProperty().bindBidirectional((Property)this.aplikacja.getParametryKontroli().sciezkaDoSzablonuKontroliProperty());
        this.aplikacja.getParametryKontroli().komunikatPlikuDoKontroliProperty().addListener((ov, staraWartosc, nowaWartosc) -> this.obsluzDodaniePlikow());
        this.aplikacja.getParametryKontroli().czyKontrolaWTrakcieProperty().addListener((ov, staraWartosc, nowaWartosc) -> this.zablokujDoKontroli((Boolean)nowaWartosc));
        this.aplikacja.getParametryKontroli().liczbaSkontrolowanychObiektowProperty().addListener((ov, staraWartosc, nowaWartosc) -> this.aktualizujPasekPostepu((Number)nowaWartosc));
        this.aplikacja.getParametryKontroli().blokadaOknaProperty().addListener((ov, staraWartosc, nowaWartosc) -> this.blokadaOknaKontroli((Boolean)nowaWartosc));
        this.aplikacja.getParametryKontroli().czyKontrolaWTrakcieProperty().addListener((ov, staraWartosc, nowaWartosc) -> this.aktualizujWidocznoscLicznikaObiektow((Boolean)nowaWartosc));
        this.aplikacja.getParametryKontroli().liczbaObiektowPlikuProperty().addListener((ov, staraWartosc, nowaWartosc) -> this.aktualizujLiczbeObiektow((Number)nowaWartosc));
        this.sciezkaDoSchematuAplikacyjnego.textProperty().addListener((ov, staraWartosc, nowaWartosc) -> this.wyswietlInfoOZmianieSciezek());
        this.sciezkaDoSzablonuKontroli.textProperty().addListener((ov, staraWartosc, nowaWartosc) -> this.wyswietlInfoOZmianieSciezek());
        this.aplikacja.getParametryKontroli().liczbaSkontrolowanychPlikowProperty().addListener((ov, staraWartosc, nowaWartosc) -> this.aktualizujLiczbePlikow((Number)nowaWartosc));
    }

    public void aktualizujPasekPostepu(Number liczbaObiektow) {
        this.licznik.setText(liczbaObiektow.intValue() + "/" + this.aplikacja.getParametryKontroli().liczbaObiektowPlikuProperty().intValue());
    }

    public void aktualizujLiczbePlikow(Number numerPliku) {
        Platform.runLater(() -> {
            String komunikat = this.bundle.getString(BUNDLE_OBECNIE_WERYFIKOWANY_PLIK);
            komunikat = MessageFormat.format(komunikat, String.valueOf(numerPliku.intValue()), String.valueOf(this.aplikacja.getParametryKontroli().getPlikiDoKontroli().size()));
            this.numerWeryfikowanegoPliku.setText(komunikat);
        });
    }

    public void aktualizujLiczbeObiektow(Number liczbaObiektow) {
        Platform.runLater(() -> this.aktualizujPasekPostepu(0));
    }

    public void blokadaOknaKontroli(Boolean bool) {
        this.zablokujDoKontroli(bool);
        if (bool.booleanValue()) {
            this.przerwijKontroleButton.setDisable(true);
        }
    }

    private void aktualizujWidocznoscLicznikaObiektow(Boolean czyKontrolaWTrakcie) {
        if (this.aplikacja.getParametryKontroli().czyKontroleAtrybutoweProperty().get()) {
            this.licznikBox.setVisible(czyKontrolaWTrakcie.booleanValue());
            this.numerWeryfikowanegoPliku.setVisible(czyKontrolaWTrakcie.booleanValue());
        }
    }

    private void obsluzDodaniePlikow() {
        this.aplikacja.getParametryKontroli().setLiczbaObiektowPliku(0);
        this.aktualizujPasekPostepu(0);
        this.logowanieArea.textProperty().unbind();
        this.logowanieArea.clear();
    }

    private void obsluzWyjatekWalidacji(Throwable ex) {
        String msg = this.wykonajKontroleService.getLastMessage();
        if (ex instanceof BrakPlikuXsdException) {
            KomunikatyUtils.budujAlertBleduWalidacji(this.bundle.getString(BUNDLE_BLEDY_BRAK_PLIKU_XSD), ex.getMessage()).showAndWait();
        } else if (ex instanceof BladWalidatoraXsd || ex instanceof BladParsowaniaXMLException) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(ex);
            KomunikatyUtils.budujAlertBleduWalidacji(this.bundle.getString(BUNDLE_BLEDY_NIEPOPRAWNY_PLIK_GML), ex.getMessage()).showAndWait();
        } else if (ex instanceof Error) {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(ex);
        } else if (msg != null) {
            KomunikatyUtils.budujAlertBleduWalidacji(msg).showAndWait();
        } else {
            ObslugaWyjatkowService.pobierzInstancje().dodajWyjatek(ex);
            KomunikatyUtils.budujAlertBleduWalidacji(this.bundle.getString(BUNDLE_BLAD_APLIKACJI)).showAndWait();
        }
    }

    public void wykonajKontrole() {
        this.ustawieniaOcjonalnePanel.setExpanded(false);
        if (!this.aplikacja.getParametryKontroli().isCzyRaportPDF() && !this.aplikacja.getParametryKontroli().isCzyRaportCSV()) {
            this.aplikacja.getParametryKontroli().setCzyRaportPDF(true);
            this.aplikacja.getParametryKontroli().setCzyRaportCSV(true);
        }
        if (this.czyPrawidloweParametryWejsciowe()) {
            this.aplikacja.getParametryKontroli().czyWykonanoKontroleProperty().setValue(Boolean.valueOf(false));
            this.aplikacja.getParametryKontroli().czyKontrolaWTrakcieProperty().setValue(Boolean.valueOf(true));
            this.aplikacja.getParametryKontroli().getWynikiKontroli().clear();
            this.numerWeryfikowanegoPliku.setVisible(true);
            this.wykonajKontroleService = new WykonajKontroleService();
            this.wykonajKontroleService.stateProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue == Worker.State.FAILED) {
                    this.obsluzWyjatekWalidacji(this.wykonajKontroleService.getLastException());
                }
            });
            this.pasekPostepu.progressProperty().bind((ObservableValue)this.wykonajKontroleService.progressProperty());
            this.wykonajKontroleService.setOgolneParametryKontroli(this.aplikacja.getParametryKontroli());
            this.wykonajKontroleService.setPlikWynikowy(this.aplikacja.getPlikWynikowy());
            this.wykonajKontroleService.setOnSucceeded(e -> this.ustawZakonczenieKontroli(true));
            this.wykonajKontroleService.setOnFailed(e -> this.ustawZakonczenieKontroli(true));
            this.wykonajKontroleService.messageProperty().addListener((observable, oldValue, newValue) -> {
                this.logowanieArea.setText(newValue);
                this.logowanieArea.appendText("");
            });
            this.wykonajKontroleService.restart();
        }
    }

    private boolean czyPrawidloweParametryWejsciowe() {
        return WalidatorWejsciowyUtils.walidujDaneWejsiowe(this.aplikacja.getParametryKontroli(), this.okno);
    }

    public void ustawZakonczenieKontroli(Boolean czyPomyslnie) {
        this.aplikacja.getParametryKontroli().czyKontrolaWTrakcieProperty().setValue(Boolean.valueOf(false));
        if (czyPomyslnie.booleanValue()) {
            this.aplikacja.getParametryKontroli().czyWykonanoKontroleProperty().setValue(Boolean.valueOf(true));
            this.numerWeryfikowanegoPliku.setVisible(false);
        }
    }

    public void zablokujDoKontroli(Boolean czyWTrakcieKontroli) {
        if (czyWTrakcieKontroli.booleanValue()) {
            this.przerwijKontroleButton.setDisable(false);
            this.wykonajKontroleButton.setDisable(true);
            this.wykonajKontroleButton.setDisable(true);
            this.walidacjaXSD.setDisable(true);
            this.kontroleAtrybutowe.setDisable(true);
            this.wybierzKontrolowanyPlikButton.setDisable(true);
            this.przerwijKontroleButton.setDisable(false);
            this.wyswietlWyborFolderuRaportuButton.setDisable(true);
            this.ustawieniaOcjonalnePanel.setDisable(true);
            this.czyRaportPDF.setDisable(true);
            this.czyRaportCSV.setDisable(true);
            this.sciezkaDoRaportu.setDisable(true);
            this.komunikatPlikowText.setDisable(true);
        } else {
            this.przerwijKontroleButton.setDisable(true);
            this.wykonajKontroleButton.setDisable(false);
            this.wybierzKontrolowanyPlikButton.setDisable(false);
            this.wyswietlWyborFolderuRaportuButton.setDisable(false);
            this.ustawieniaOcjonalnePanel.setDisable(false);
            this.czyRaportPDF.setDisable(false);
            this.czyRaportCSV.setDisable(false);
            this.sciezkaDoRaportu.setDisable(false);
            this.komunikatPlikowText.setDisable(false);
            this.walidacjaXSD.setDisable(false);
            this.kontroleAtrybutowe.setDisable(false);
        }
    }

    public void przerwijKontrole() {
        this.przerwijKontroleButton.setDisable(true);
        this.wykonajKontroleService.cancel();
    }

    public void wyswietlWyborFolderuRaportu() {
        this.pobierzSciezkeFolderu(RodzajPlikuEnum.FOLDER_DO_RAPORTU, this.aplikacja.getParametryKontroli().sciezkaDoOstatniegoFolderuRaportowProperty().getValue());
    }

    public void wyswietlInfoOZmianieSciezek() {
        KomunikatyUtils.bubudujIWyswietlAlertInfo(this.bundle.getString(BUNDLE_INFORMACJA), this.bundle.getString(BUNDLE_ZAKTUALIZOWANO_SCIEZKE));
    }
}

