/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.CursorManager;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.extension.svg.FlowExtTextNode;
import org.apache.batik.extension.svg.MarginInfo;
import org.apache.batik.extension.svg.RegionInfo;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventListener;

public class BatikFlowTextElementBridge
extends SVGTextElementBridge
implements BatikExtConstants {
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute PREFORMATTED = GVTAttributedCharacterIterator.TextAttribute.PREFORMATTED;
    protected static final GVTAttributedCharacterIterator.TextAttribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    protected static final GVTAttributedCharacterIterator.TextAttribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    protected static final GVTAttributedCharacterIterator.TextAttribute LETTER_SPACING = GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute WORD_SPACING = GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute KERNING = GVTAttributedCharacterIterator.TextAttribute.KERNING;

    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "flowText";
    }

    public Bridge getInstance() {
        return new BatikFlowTextElementBridge();
    }

    public boolean isComposite() {
        return false;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new FlowExtTextNode();
    }

    protected Point2D getLocation(BridgeContext ctx, Element e) {
        return new Point2D.Float(0.0f, 0.0f);
    }

    protected void addContextToChild(BridgeContext ctx, Element e) {
        String ln;
        if (this.getNamespaceURI().equals(e.getNamespaceURI()) && ((ln = e.getLocalName()).equals("flowPara") || ln.equals("flowRegionBreak") || ln.equals("flowLine") || ln.equals("flowSpan") || ln.equals("a") || ln.equals("tref"))) {
            ((SVGOMElement)e).setSVGContext((SVGContext)new BatikFlowContentBridge(ctx, this, e));
        }
        Node child = this.getFirstChild(e);
        while (child != null) {
            if (child.getNodeType() == 1) {
                this.addContextToChild(ctx, (Element)child);
            }
            child = this.getNextSibling(child);
        }
    }

    protected AttributedString buildAttributedString(BridgeContext ctx, Element element) {
        List rgns = this.getRegions(ctx, element);
        AttributedString ret = this.getFlowDiv(ctx, element);
        if (ret == null) {
            return ret;
        }
        ret.addAttribute(FLOW_REGIONS, rgns, 0, 1);
        return ret;
    }

    protected void addGlyphPositionAttributes(AttributedString as, Element element, BridgeContext ctx) {
        if (element.getNodeType() != 1) {
            return;
        }
        String eNS = element.getNamespaceURI();
        if (!eNS.equals(this.getNamespaceURI()) && !eNS.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addGlyphPositionAttributes(as, element, ctx);
            return;
        }
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            String ln;
            if (n.getNodeType() != 1) continue;
            String nNS = n.getNamespaceURI();
            if (!this.getNamespaceURI().equals(nNS) && !"http://www.w3.org/2000/svg".equals(nNS) || !(ln = (e = (Element)n).getLocalName()).equals("flowDiv")) continue;
            super.addGlyphPositionAttributes(as, e, ctx);
            return;
        }
    }

    protected void addChildGlyphPositionAttributes(AttributedString as, Element element, BridgeContext ctx) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            String ln;
            if (child.getNodeType() != 1) continue;
            String cNS = child.getNamespaceURI();
            if (!this.getNamespaceURI().equals(cNS) && !"http://www.w3.org/2000/svg".equals(cNS) || !(ln = child.getLocalName()).equals("flowPara") && !ln.equals("flowRegionBreak") && !ln.equals("flowLine") && !ln.equals("flowSpan") && !ln.equals("a") && !ln.equals("tref")) continue;
            this.addGlyphPositionAttributes(as, (Element)child, ctx);
        }
    }

    protected void addPaintAttributes(AttributedString as, Element element, TextNode node, TextPaintInfo parentPI, BridgeContext ctx) {
        if (element.getNodeType() != 1) {
            return;
        }
        String eNS = element.getNamespaceURI();
        if (!eNS.equals(this.getNamespaceURI()) && !eNS.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addPaintAttributes(as, element, node, parentPI, ctx);
            return;
        }
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            String ln;
            if (n.getNodeType() != 1 || !this.getNamespaceURI().equals(n.getNamespaceURI()) || !(ln = (e = (Element)n).getLocalName()).equals("flowDiv")) continue;
            super.addPaintAttributes(as, e, node, parentPI, ctx);
            return;
        }
    }

    protected void addChildPaintAttributes(AttributedString as, Element element, TextNode node, TextPaintInfo parentPI, BridgeContext ctx) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            String ln;
            if (child.getNodeType() != 1) continue;
            String cNS = child.getNamespaceURI();
            if (!this.getNamespaceURI().equals(cNS) && !"http://www.w3.org/2000/svg".equals(cNS) || !(ln = child.getLocalName()).equals("flowPara") && !ln.equals("flowRegionBreak") && !ln.equals("flowLine") && !ln.equals("flowSpan") && !ln.equals("a") && !ln.equals("tref")) continue;
            Element childElement = (Element)child;
            TextPaintInfo pi = this.getTextPaintInfo(childElement, (GraphicsNode)node, parentPI, ctx);
            this.addPaintAttributes(as, childElement, node, pi, ctx);
        }
    }

    protected AttributedString getFlowDiv(BridgeContext ctx, Element element) {
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !this.getNamespaceURI().equals(n.getNamespaceURI())) continue;
            Element e = (Element)n;
            String ln = n.getLocalName();
            if (!ln.equals("flowDiv")) continue;
            return this.gatherFlowPara(ctx, e);
        }
        return null;
    }

    protected AttributedString gatherFlowPara(BridgeContext ctx, Element div) {
        TextPaintInfo divTPI = new TextPaintInfo();
        divTPI.visible = true;
        divTPI.fillPaint = Color.black;
        this.elemTPI.put(div, divTPI);
        SVGTextElementBridge.AttributedStringBuffer asb = new SVGTextElementBridge.AttributedStringBuffer();
        ArrayList<Integer> paraEnds = new ArrayList<Integer>();
        ArrayList<Element> paraElems = new ArrayList<Element>();
        ArrayList lnLocs = new ArrayList();
        for (Node n = div.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !this.getNamespaceURI().equals(n.getNamespaceURI())) continue;
            Element e = (Element)n;
            String ln = e.getLocalName();
            if (ln.equals("flowPara")) {
                this.fillAttributedStringBuffer(ctx, e, true, null, null, asb, lnLocs);
                paraElems.add(e);
                paraEnds.add(new Integer(asb.length()));
                continue;
            }
            if (!ln.equals("flowRegionBreak")) continue;
            this.fillAttributedStringBuffer(ctx, e, true, null, null, asb, lnLocs);
            paraElems.add(e);
            paraEnds.add(new Integer(asb.length()));
        }
        divTPI.startChar = 0;
        divTPI.endChar = asb.length() - 1;
        AttributedString ret = asb.toAttributedString();
        int prevLN = 0;
        Iterator lnIter = lnLocs.iterator();
        while (lnIter.hasNext()) {
            int nextLN = (Integer)lnIter.next();
            if (nextLN == prevLN) continue;
            ret.addAttribute(FLOW_LINE_BREAK, new Object(), prevLN, nextLN);
            prevLN = nextLN;
        }
        int start = 0;
        LinkedList<MarginInfo> emptyPara = null;
        for (int i = 0; i < paraElems.size(); ++i) {
            Element elem = (Element)paraElems.get(i);
            int end = (Integer)paraEnds.get(i);
            if (start == end) {
                if (emptyPara == null) {
                    emptyPara = new LinkedList<MarginInfo>();
                }
                emptyPara.add(this.makeMarginInfo(elem));
            } else {
                ret.addAttribute(FLOW_PARAGRAPH, this.makeMarginInfo(elem), start, end);
                if (emptyPara != null) {
                    ret.addAttribute(FLOW_EMPTY_PARAGRAPH, emptyPara, start, end);
                    emptyPara = null;
                }
            }
            start = end;
        }
        return ret;
    }

    protected List getRegions(BridgeContext ctx, Element element) {
        LinkedList ret = new LinkedList();
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            String ln;
            if (n.getNodeType() != 1 || !this.getNamespaceURI().equals(n.getNamespaceURI()) || !"flowRegion".equals(ln = (e = (Element)n).getLocalName())) continue;
            float verticalAlignment = 0.0f;
            String verticalAlignmentAttribute = e.getAttribute("vertical-align");
            if (verticalAlignmentAttribute != null && verticalAlignmentAttribute.length() > 0) {
                if ("top".equals(verticalAlignmentAttribute)) {
                    verticalAlignment = 0.0f;
                } else if ("middle".equals(verticalAlignmentAttribute)) {
                    verticalAlignment = 0.5f;
                } else if ("bottom".equals(verticalAlignmentAttribute)) {
                    verticalAlignment = 1.0f;
                }
            }
            this.gatherRegionInfo(ctx, e, verticalAlignment, ret);
        }
        return ret;
    }

    protected void gatherRegionInfo(BridgeContext ctx, Element rgn, float verticalAlign, List regions) {
        for (Node n = rgn.getFirstChild(); n != null; n = n.getNextSibling()) {
            UnitProcessor.Context uctx;
            RegionInfo ri;
            if (n.getNodeType() != 1 || !this.getNamespaceURI().equals(n.getNamespaceURI())) continue;
            Element e = (Element)n;
            String ln = n.getLocalName();
            if (!ln.equals("rect") || (ri = this.buildRegion(uctx = UnitProcessor.createContext((BridgeContext)ctx, (Element)e), e, verticalAlign)) == null) continue;
            regions.add(ri);
        }
    }

    protected RegionInfo buildRegion(UnitProcessor.Context uctx, Element e, float verticalAlignment) {
        String s = e.getAttribute("x");
        float x = 0.0f;
        if (s.length() != 0) {
            x = UnitProcessor.svgHorizontalCoordinateToUserSpace((String)s, (String)"x", (UnitProcessor.Context)uctx);
        }
        s = e.getAttribute("y");
        float y = 0.0f;
        if (s.length() != 0) {
            y = UnitProcessor.svgVerticalCoordinateToUserSpace((String)s, (String)"y", (UnitProcessor.Context)uctx);
        }
        if ((s = e.getAttribute("width")).length() == 0) {
            throw new BridgeException(this.ctx, e, "attribute.missing", new Object[]{"width", s});
        }
        float w = UnitProcessor.svgHorizontalLengthToUserSpace((String)s, (String)"width", (UnitProcessor.Context)uctx);
        if (w == 0.0f) {
            return null;
        }
        s = e.getAttribute("height");
        if (s.length() == 0) {
            throw new BridgeException(this.ctx, e, "attribute.missing", new Object[]{"height", s});
        }
        float h = UnitProcessor.svgVerticalLengthToUserSpace((String)s, (String)"height", (UnitProcessor.Context)uctx);
        if (h == 0.0f) {
            return null;
        }
        return new RegionInfo(x, y, w, h, verticalAlignment);
    }

    protected void fillAttributedStringBuffer(BridgeContext ctx, Element element, boolean top, Integer bidiLevel, Map initialAttributes, SVGTextElementBridge.AttributedStringBuffer asb, List lnLocs) {
        if (!SVGUtilities.matchUserAgent((Element)element, (UserAgent)ctx.getUserAgent()) || !CSSUtilities.convertDisplay((Element)element)) {
            return;
        }
        String s = XMLSupport.getXMLSpace((Element)element);
        boolean preserve = s.equals("preserve");
        Element nodeElement = element;
        int elementStartChar = asb.length();
        if (top) {
            this.endLimit = 0;
        }
        if (preserve) {
            this.endLimit = asb.length();
        }
        HashMap map = initialAttributes == null ? new HashMap() : new HashMap(initialAttributes);
        initialAttributes = this.getAttributeMap(ctx, element, null, bidiLevel, map);
        Object o = map.get(TextAttribute.BIDI_EMBEDDING);
        Integer subBidiLevel = bidiLevel;
        if (o != null) {
            subBidiLevel = (Integer)o;
        }
        block4: for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            boolean prevEndsWithSpace = preserve ? false : (asb.length() == 0 ? true : asb.getLastChar() == 32);
            switch (n.getNodeType()) {
                case 1: {
                    if (!this.getNamespaceURI().equals(n.getNamespaceURI()) && !"http://www.w3.org/2000/svg".equals(n.getNamespaceURI())) continue block4;
                    nodeElement = (Element)n;
                    String ln = n.getLocalName();
                    if (ln.equals("flowLine")) {
                        int before = asb.length();
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, subBidiLevel, initialAttributes, asb, lnLocs);
                        lnLocs.add(new Integer(asb.length()));
                        if (asb.length() == before) continue block4;
                        initialAttributes = null;
                        continue block4;
                    }
                    if (ln.equals("flowSpan") || ln.equals("altGlyph")) {
                        int before = asb.length();
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, subBidiLevel, initialAttributes, asb, lnLocs);
                        if (asb.length() == before) continue block4;
                        initialAttributes = null;
                        continue block4;
                    }
                    if (ln.equals("a")) {
                        if (ctx.isInteractive()) {
                            NodeEventTarget target = (NodeEventTarget)nodeElement;
                            UserAgent ua = ctx.getUserAgent();
                            SVGAElementBridge.CursorHolder ch = new SVGAElementBridge.CursorHolder(CursorManager.DEFAULT_CURSOR);
                            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", (EventListener)new SVGAElementBridge.AnchorListener(ua, ch), false, null);
                            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", (EventListener)new SVGAElementBridge.CursorMouseOverListener(ua, ch), false, null);
                            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", (EventListener)new SVGAElementBridge.CursorMouseOutListener(ua, ch), false, null);
                        }
                        int before = asb.length();
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, subBidiLevel, initialAttributes, asb, lnLocs);
                        if (asb.length() == before) continue block4;
                        initialAttributes = null;
                        continue block4;
                    }
                    if (!ln.equals("tref")) continue block4;
                    String uriStr = XLinkSupport.getXLinkHref((Element)((Element)n));
                    Element ref = ctx.getReferencedElement((Element)n, uriStr);
                    s = TextUtilities.getElementContent((Element)ref);
                    if ((s = this.normalizeString(s, preserve, prevEndsWithSpace)).length() == 0) continue block4;
                    int trefStart = asb.length();
                    HashMap m = initialAttributes == null ? new HashMap() : new HashMap(initialAttributes);
                    this.getAttributeMap(ctx, nodeElement, null, bidiLevel, m);
                    asb.append(s, m);
                    int trefEnd = asb.length() - 1;
                    TextPaintInfo tpi = (TextPaintInfo)this.elemTPI.get(nodeElement);
                    tpi.startChar = trefStart;
                    tpi.endChar = trefEnd;
                    initialAttributes = null;
                    continue block4;
                }
                case 3: 
                case 4: {
                    s = n.getNodeValue();
                    s = this.normalizeString(s, preserve, prevEndsWithSpace);
                    if (s.length() == 0) continue block4;
                    asb.append(s, map);
                    if (preserve) {
                        this.endLimit = asb.length();
                    }
                    initialAttributes = null;
                }
            }
        }
        if (top) {
            boolean strippedSome = false;
            while (this.endLimit < asb.length() && asb.getLastChar() == 32) {
                asb.stripLast();
                strippedSome = true;
            }
            if (strippedSome) {
                for (TextPaintInfo tpi : this.elemTPI.values()) {
                    if (tpi.endChar < asb.length()) continue;
                    tpi.endChar = asb.length() - 1;
                    if (tpi.startChar <= tpi.endChar) continue;
                    tpi.startChar = tpi.endChar;
                }
            }
        }
        int elementEndChar = asb.length() - 1;
        TextPaintInfo tpi = (TextPaintInfo)this.elemTPI.get(element);
        tpi.startChar = elementStartChar;
        tpi.endChar = elementEndChar;
    }

    protected Map getAttributeMap(BridgeContext ctx, Element element, TextPath textPath, Integer bidiLevel, Map result) {
        Map initialMap = super.getAttributeMap(ctx, element, textPath, bidiLevel, result);
        String s = element.getAttribute("preformatted");
        if (s.length() != 0 && s.equals("true")) {
            result.put(PREFORMATTED, Boolean.TRUE);
        }
        return initialMap;
    }

    protected void checkMap(Map attrs) {
        if (attrs.containsKey(TEXTPATH)) {
            return;
        }
        if (attrs.containsKey(ANCHOR_TYPE)) {
            return;
        }
        if (attrs.containsKey(LETTER_SPACING)) {
            return;
        }
        if (attrs.containsKey(WORD_SPACING)) {
            return;
        }
        if (attrs.containsKey(KERNING)) {
            return;
        }
    }

    public MarginInfo makeMarginInfo(Element e) {
        float f;
        float top = 0.0f;
        float right = 0.0f;
        float bottom = 0.0f;
        float left = 0.0f;
        String s = e.getAttribute("margin");
        try {
            if (s.length() != 0) {
                bottom = left = (f = Float.parseFloat(s));
                right = left;
                top = left;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        s = e.getAttribute("top-margin");
        try {
            if (s.length() != 0) {
                top = f = Float.parseFloat(s);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        s = e.getAttribute("right-margin");
        try {
            if (s.length() != 0) {
                float f2;
                right = f2 = Float.parseFloat(s);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        s = e.getAttribute("bottom-margin");
        try {
            if (s.length() != 0) {
                float f3;
                bottom = f3 = Float.parseFloat(s);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        s = e.getAttribute("left-margin");
        try {
            if (s.length() != 0) {
                float f4;
                left = f4 = Float.parseFloat(s);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        float indent = 0.0f;
        s = e.getAttribute("indent");
        try {
            if (s.length() != 0) {
                float f5;
                indent = f5 = Float.parseFloat(s);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        int justification = 0;
        s = e.getAttribute("justification");
        try {
            if (s.length() != 0) {
                if ("start".equals(s)) {
                    justification = 0;
                } else if ("middle".equals(s)) {
                    justification = 1;
                } else if ("end".equals(s)) {
                    justification = 2;
                } else if ("full".equals(s)) {
                    justification = 3;
                }
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String ln = e.getLocalName();
        boolean rgnBr = ln.equals("flowRegionBreak");
        return new MarginInfo(top, right, bottom, left, indent, justification, rgnBr);
    }

    protected class BatikFlowContentBridge
    extends SVGTextElementBridge.AbstractTextChildTextContent {
        public BatikFlowContentBridge(BridgeContext ctx, SVGTextElementBridge parent, Element e) {
            super((SVGTextElementBridge)BatikFlowTextElementBridge.this, ctx, parent, e);
        }
    }

    public static class LineBreakInfo {
        int breakIdx;
        float lineAdvAdj;
        boolean relative;

        public LineBreakInfo(int breakIdx, float lineAdvAdj, boolean relative) {
            this.breakIdx = breakIdx;
            this.lineAdvAdj = lineAdvAdj;
            this.relative = relative;
        }

        public int getBreakIdx() {
            return this.breakIdx;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public float getLineAdvAdj() {
            return this.lineAdvAdj;
        }
    }
}

