/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.kontrole.executory;

import com.google.common.base.Strings;
import java.time.LocalDateTime;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.joox.Match;
import org.w3c.dom.Element;
import pl.gov.gugik.gesut.dak.biz.kontrole.executory.KontrolaExecutor;
import pl.gov.gugik.gesut.dak.biz.utils.DateUtils;
import pl.gov.gugik.gesut.dak.biz.utils.kontrole.ObiektHelper;
import pl.gov.gugik.gesut.dak.enumy.OperatorEnum;
import pl.gov.gugik.gesut.dak.enumy.TypDanychEnum;
import pl.gov.gugik.gesut.dak.model.kontrole.BladKontroli;
import pl.gov.gugik.gesut.dak.model.kontrole.WynikKontroli;
import pl.gov.gugik.gesut.dak.model.szablonKontroli.kontrole.kontrolaPorownanieAtrybutow.PorownywanyAtrybut;

public class KontrolaPorownanieAtrybutowExecutor
extends KontrolaExecutor {
    private static final Logger log = Logger.getLogger(KontrolaPorownanieAtrybutowExecutor.class);
    private PorownywanyAtrybut porownywanyAtrybut;
    private OperatorEnum operator;
    private TypDanychEnum typ;

    @Override
    public WynikKontroli kontroluj(Match feature, String nazwaKontrolowanegoPliku) {
        WynikKontroli wynikKontroli = new WynikKontroli();
        Match obiektAtrybutu = ObiektHelper.pobierzWartoscAtrybutu(feature, this.getAtrybut());
        Match porownywanyObiekt = ObiektHelper.pobierzWartoscAtrybutu(feature, this.porownywanyAtrybut.getAtrybut());
        wynikKontroli.setPozytywny(true);
        if (!obiektAtrybutu.isEmpty() && !porownywanyObiekt.isEmpty()) {
            for (Element element : obiektAtrybutu.get()) {
                String porowynwanaWartosc;
                String wartoscAtrybutu = element.getTextContent();
                if (this.czySpelniaWarunek(wartoscAtrybutu, porowynwanaWartosc = porownywanyObiekt.text(), this.operator, this.typ)) continue;
                wynikKontroli.setPozytywny(false);
                BladKontroli bladKontroli = this.budujBladKontroli(feature, wartoscAtrybutu, this.porownywanyAtrybut, porowynwanaWartosc, nazwaKontrolowanegoPliku);
                wynikKontroli.setBladKontroli(bladKontroli);
            }
        }
        return wynikKontroli;
    }

    public void ustawDane(String operator, PorownywanyAtrybut porownywanyAtrybut, String typDanych) {
        this.operator = OperatorEnum.zwrocEnum(operator);
        this.porownywanyAtrybut = porownywanyAtrybut;
        this.typ = Stream.of(TypDanychEnum.values()).filter(t -> t.toString().equalsIgnoreCase(typDanych)).findFirst().orElse(null);
    }

    private boolean czySpelniaWarunek(String wartoscAtrybutu, String porownywanaWartosc, OperatorEnum operator, TypDanychEnum typ) {
        if (Strings.isNullOrEmpty((String)wartoscAtrybutu) || Strings.isNullOrEmpty((String)porownywanaWartosc)) {
            return true;
        }
        switch (typ) {
            case DATE: {
                return this.czySpelniaWarunekData(wartoscAtrybutu, porownywanaWartosc, operator);
            }
            case INTEGER: {
                return this.czySpelniaWarunekInteger(wartoscAtrybutu, porownywanaWartosc, operator);
            }
            case DOUBLE: {
                return this.czySpelniaWarunekDouble(wartoscAtrybutu, porownywanaWartosc, operator);
            }
            case BOOLEAN: {
                return this.czySpelniaWarunekBoolean(wartoscAtrybutu, porownywanaWartosc, operator);
            }
            case STRING: {
                return this.czySpelniaWarunekString(wartoscAtrybutu, porownywanaWartosc, operator);
            }
        }
        return false;
    }

    private BladKontroli budujBladKontroli(Match feature, String wartoscAtrybutu, PorownywanyAtrybut porownywanyAtrybut, String porownywanaWartosc, String nazwaKontrolowanegoPliku) {
        BladKontroli bladKontroli = this.generujBladKontroli(feature, nazwaKontrolowanegoPliku);
        bladKontroli.setAttr1Wart(wartoscAtrybutu);
        bladKontroli.setAttr2Naz(ObiektHelper.pobierzNazweAtrybutu(porownywanyAtrybut.getAtrybut()));
        bladKontroli.setAttr2Wart(porownywanaWartosc);
        return bladKontroli;
    }

    private boolean czySpelniaWarunekData(String wartoscAtrybutu, String porownywanyAtrybut, OperatorEnum operator) {
        LocalDateTime wartoscAtrybutuDate = DateUtils.parsujDateLDT(wartoscAtrybutu);
        LocalDateTime wartoscPorownywanaDate = DateUtils.parsujDateLDT(porownywanyAtrybut);
        switch (operator) {
            case MNIEJSZY: {
                return wartoscAtrybutuDate.isBefore(wartoscPorownywanaDate);
            }
            case MNIEJSZY_ROWNY: {
                return !wartoscAtrybutuDate.isAfter(wartoscPorownywanaDate);
            }
            case ROWNY: {
                return wartoscAtrybutuDate.toLocalDate().equals(wartoscPorownywanaDate.toLocalDate());
            }
            case WIEKSZY: {
                return wartoscAtrybutuDate.isAfter(wartoscPorownywanaDate);
            }
            case WIEKSZY_ROWNY: {
                return !wartoscAtrybutuDate.isBefore(wartoscPorownywanaDate);
            }
            case ROZNY: {
                return !wartoscAtrybutuDate.toLocalDate().equals(wartoscPorownywanaDate.toLocalDate());
            }
        }
        return false;
    }

    private boolean czySpelniaWarunekInteger(String wartoscAtrybutu, String porownywanyAtrybut, OperatorEnum operator) {
        Integer wartoscAtrybutuInt = Integer.parseInt(wartoscAtrybutu);
        Integer wartoscPorownywanaInt = Integer.parseInt(porownywanyAtrybut);
        switch (operator) {
            case MNIEJSZY: {
                return wartoscAtrybutuInt < wartoscPorownywanaInt;
            }
            case MNIEJSZY_ROWNY: {
                return wartoscAtrybutuInt <= wartoscPorownywanaInt;
            }
            case ROWNY: {
                return wartoscAtrybutuInt.equals(wartoscPorownywanaInt);
            }
            case WIEKSZY: {
                return wartoscAtrybutuInt > wartoscPorownywanaInt;
            }
            case WIEKSZY_ROWNY: {
                return wartoscAtrybutuInt >= wartoscPorownywanaInt;
            }
            case ROZNY: {
                return !wartoscAtrybutuInt.equals(wartoscPorownywanaInt);
            }
        }
        return false;
    }

    private boolean czySpelniaWarunekDouble(String wartoscAtrybutu, String porownywanyAtrybut, OperatorEnum operator) {
        Double wartoscAtrybutuDouble = Double.parseDouble(wartoscAtrybutu);
        Double wartoscPorownywanaDouble = Double.parseDouble(porownywanyAtrybut);
        switch (operator) {
            case MNIEJSZY: {
                return wartoscAtrybutuDouble < wartoscPorownywanaDouble;
            }
            case MNIEJSZY_ROWNY: {
                return wartoscAtrybutuDouble <= wartoscPorownywanaDouble;
            }
            case ROWNY: {
                return wartoscAtrybutuDouble.equals(wartoscPorownywanaDouble);
            }
            case WIEKSZY: {
                return wartoscAtrybutuDouble > wartoscPorownywanaDouble;
            }
            case WIEKSZY_ROWNY: {
                return wartoscAtrybutuDouble >= wartoscPorownywanaDouble;
            }
            case ROZNY: {
                return !wartoscAtrybutuDouble.equals(wartoscPorownywanaDouble);
            }
        }
        return false;
    }

    private boolean czySpelniaWarunekBoolean(String wartoscAtrybutu, String porownywanyAtrybut, OperatorEnum operator) {
        Boolean wartoscAtrybutuBool = ObiektHelper.parsujBoolean(wartoscAtrybutu);
        Boolean wartoscPorownywanaBool = ObiektHelper.parsujBoolean(porownywanyAtrybut);
        if (operator.equals((Object)OperatorEnum.ROWNY)) {
            return wartoscAtrybutuBool.equals(wartoscAtrybutuBool);
        }
        if (operator.equals((Object)OperatorEnum.ROZNY)) {
            return !wartoscAtrybutuBool.equals(wartoscPorownywanaBool);
        }
        log.error((Object)"NIEOBSLUGIWANY OPERATOR");
        return false;
    }

    private boolean czySpelniaWarunekString(String wartoscAtrybutu, String porownywanyAtrybut, OperatorEnum operator) {
        if (operator.equals((Object)OperatorEnum.ROWNY)) {
            return wartoscAtrybutu.equals(porownywanyAtrybut);
        }
        if (operator.equals((Object)OperatorEnum.ROZNY)) {
            return !wartoscAtrybutu.equals(porownywanyAtrybut);
        }
        log.error((Object)"NIEOBSLUGIWANY OPERATOR");
        return false;
    }
}

