/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.pliki;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import pl.gov.gugik.gesut.dak.biz.conf.Konfiguracja;
import pl.gov.gugik.gesut.dak.enumy.RodzajPlikuEnum;

public class WskazLokalizacjeService {
    private static final String BUNDLE_PLIKI_XSD = "plikiXsd";
    private static final String BUNDLE_PLIKI_XMLI_GML = "plikiXmliGml";
    private static final String BUNDLE_PLIK_DO_KONTROLI = "plikDoKontroli";
    private static final String BUNDLE_SCHEMAT_APLIKACYJNY = "schematAplikacyjny";
    private static final String BUNDLE_FOLDER_DO_RAPORTU = "folderDoRaportu";
    private static final String BUNDLE_FOLDER_PLIKOW_DO_KONTROLI = "folderPlikowDoKontroli";
    private static final String BUNDLE_SZABLON_KONTROLI = "szablonKontroli";

    private static String pobierzTlumaczenieRodzajuPliku(RodzajPlikuEnum rodzajPliku) {
        switch (rodzajPliku) {
            case PLIK_DO_KONTROLI: {
                return Konfiguracja.getBundle().getString(BUNDLE_PLIK_DO_KONTROLI);
            }
            case SCHEMAT_APLIKACYJNY: {
                return Konfiguracja.getBundle().getString(BUNDLE_SCHEMAT_APLIKACYJNY);
            }
            case FOLDER_DO_RAPORTU: {
                return Konfiguracja.getBundle().getString(BUNDLE_FOLDER_DO_RAPORTU);
            }
            case FOLDER_PLIOW_DO_KONTROLI: {
                return Konfiguracja.getBundle().getString(BUNDLE_FOLDER_PLIKOW_DO_KONTROLI);
            }
            case SZABLON_KONTROLI: {
                return Konfiguracja.getBundle().getString(BUNDLE_SZABLON_KONTROLI);
            }
        }
        return rodzajPliku.getWartosc();
    }

    public static String pobierzSciezkePliku(Window okno, RodzajPlikuEnum rodzajPliku, String sciezkaPoczatkowa) {
        File plik;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(WskazLokalizacjeService.pobierzTlumaczenieRodzajuPliku(rodzajPliku));
        WskazLokalizacjeService.dodajFiltrNaRozszerzenia(fileChooser, rodzajPliku);
        if (sciezkaPoczatkowa != null) {
            File plikWejsciowy = new File(sciezkaPoczatkowa);
            String sciezkaFolderu = plikWejsciowy.getAbsoluteFile().getParent();
            File sciezkaFolderuFile = null;
            if (sciezkaFolderu != null) {
                sciezkaFolderuFile = new File(sciezkaFolderu);
            }
            if (sciezkaFolderuFile != null && sciezkaFolderuFile.exists() && sciezkaFolderuFile.canRead()) {
                fileChooser.setInitialDirectory(sciezkaFolderuFile);
            }
        }
        return (plik = fileChooser.showOpenDialog(okno)) != null ? plik.getAbsolutePath() : null;
    }

    public static List<String> pobierzSciezkiPlikowGml(Window okno, String sciezkaPoczatkowa) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(WskazLokalizacjeService.pobierzTlumaczenieRodzajuPliku(RodzajPlikuEnum.PLIK_DO_KONTROLI));
        if (sciezkaPoczatkowa != null && new File(sciezkaPoczatkowa).canRead()) {
            File plikWejsciowy = new File(sciezkaPoczatkowa);
            String sciezkaFolderu = plikWejsciowy.getAbsoluteFile().getAbsolutePath();
            fileChooser.setInitialDirectory(new File(sciezkaFolderu));
        }
        WskazLokalizacjeService.dodajFiltrNaRozszerzenia(fileChooser, RodzajPlikuEnum.PLIK_DO_KONTROLI);
        List pliki = fileChooser.showOpenMultipleDialog(okno);
        return pliki != null ? pliki.stream().map(File::getAbsolutePath).sorted(String::compareToIgnoreCase).collect(Collectors.toList()) : null;
    }

    private static void dodajFiltrNaRozszerzenia(FileChooser fileChooser, RodzajPlikuEnum rodzajPlikuEnum) {
        FileChooser.ExtensionFilter filtr = RodzajPlikuEnum.SCHEMAT_APLIKACYJNY.equals((Object)rodzajPlikuEnum) ? new FileChooser.ExtensionFilter(Konfiguracja.getBundle().getString(BUNDLE_PLIKI_XSD), new String[]{"*.xsd", "*.xsd"}) : new FileChooser.ExtensionFilter(Konfiguracja.getBundle().getString(BUNDLE_PLIKI_XMLI_GML), new String[]{"*.xml", "*.gml"});
        fileChooser.getExtensionFilters().add((Object)filtr);
    }

    public static String pobierzSciezkeFolderu(Window okno, RodzajPlikuEnum rodzajPliku, String sciezkaPoczatkowa) {
        File wybranyFolder;
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(WskazLokalizacjeService.pobierzTlumaczenieRodzajuPliku(rodzajPliku));
        if (sciezkaPoczatkowa != null && new File(sciezkaPoczatkowa).canRead()) {
            File plikWejsciowy = new File(sciezkaPoczatkowa);
            String sciezkaFolderu = plikWejsciowy.getAbsolutePath();
            directoryChooser.setInitialDirectory(new File(sciezkaFolderu));
        }
        return (wybranyFolder = directoryChooser.showDialog(okno)) != null ? wybranyFolder.getAbsolutePath() : null;
    }

    public static boolean czyMoznaZapisacPlikWFolderze(String sciezka) {
        Path path = Paths.get(sciezka, new String[0]);
        return Files.isWritable(path);
    }
}

