/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.service.walidacja;

import java.io.File;
import pl.gov.gugik.gesut.dak.biz.kontrole.KontrolaTask;
import pl.gov.gugik.gesut.dak.biz.kontrole.WynikiKontroliHelper;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.WalidatorXsd;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BladWalidatoraXsd;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BrakPlikuXsdException;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.BrakZaleznegoPlikuXSD;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.WalidacjaXsdPrzerwanaException;
import pl.gov.gugik.gesut.dak.model.kontrole.OgolneParametryKontroli;
import pl.gov.gugik.gesut.dak.model.kontrole.ParametryKontroliPliku;

public class WalidacjaService {
    private KontrolaTask<Void> kontrolaTask;

    public boolean wykonajWalidacje(OgolneParametryKontroli parametryKontroli, ParametryKontroliPliku parametryPliku) throws BladWalidatoraXsd, BrakZaleznegoPlikuXSD, BrakPlikuXsdException {
        File schematAplikacyjny = new File(parametryKontroli.sciezkaDoSchematuAplikacyjnegoProperty().getValue());
        if (!schematAplikacyjny.exists() && !schematAplikacyjny.isDirectory()) {
            throw new BrakPlikuXsdException(parametryKontroli.sciezkaDoSchematuAplikacyjnegoProperty().getValue());
        }
        try {
            this.obsluzAnulowanie();
            WalidatorXsd walidatorXsd = new WalidatorXsd(new File(parametryKontroli.sciezkaDoSchematuAplikacyjnegoProperty().getValue()), this.kontrolaTask);
            boolean wynik = walidatorXsd.sprawdzPlik(new File(parametryPliku.sciezkaPlikuDoKontroliProperty().getValue()), this.kontrolaTask.getBledyWeryfikacjiService());
            this.kontrolaTask.ustawLiczbeObiektowWPliku(walidatorXsd.pobierzLiczbeObiektow());
            WynikiKontroliHelper.dodajWynikKontroliPliku(parametryKontroli, parametryPliku.getNazwaPliku(), wynik);
            Runtime.getRuntime().gc();
            return wynik;
        }
        catch (WalidacjaXsdPrzerwanaException e) {
            WynikiKontroliHelper.anulowanoKontrolePliku(parametryKontroli, parametryPliku.getNazwaPliku());
            return false;
        }
        catch (BladWalidatoraXsd e) {
            throw e;
        }
    }

    private void obsluzAnulowanie() {
        if (this.kontrolaTask.isCancelled()) {
            throw new WalidacjaXsdPrzerwanaException();
        }
    }

    public void setKontrolaTask(KontrolaTask kontrolaTask) {
        this.kontrolaTask = kontrolaTask;
    }
}

