/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.utils.parser.procesory;

import java.util.List;
import org.joox.Match;
import pl.gov.gugik.gesut.dak.biz.kontrole.KontrolaTask;
import pl.gov.gugik.gesut.dak.biz.kontrole.executory.KontrolaExecutor;
import pl.gov.gugik.gesut.dak.biz.service.kontrole.BledyWeryfikacjiService;
import pl.gov.gugik.gesut.dak.biz.utils.KomunikatyUtils;
import pl.gov.gugik.gesut.dak.biz.utils.parser.procesory.TagProcesor;
import pl.gov.gugik.gesut.dak.biz.utils.walidacja.wyjatki.PrzerwanieKontroliAtrybutowejException;
import pl.gov.gugik.gesut.dak.dao.wyjatki.BladSQLException;
import pl.gov.gugik.gesut.dak.model.kontrole.OgolnePodsumowanieKontroli;
import pl.gov.gugik.gesut.dak.model.kontrole.WynikKontroli;

public class WykonajKontroleTagProcesor
extends TagProcesor {
    private List<KontrolaExecutor> listaKontroli;
    private BledyWeryfikacjiService bledyWeryfikacjiService;
    private KontrolaTask<Void> kontrolaTask;

    public WykonajKontroleTagProcesor() {
        this.setTagName("featureMember");
        this.setEvent(1);
        this.setCzyPrzetwarzacWezelDOM(true);
    }

    @Override
    public void przetworz(Match feature, String nazwaKontrolowanegoPliku) {
        if (this.kontrolaTask.isCancelled()) {
            throw new PrzerwanieKontroliAtrybutowejException();
        }
        this.listaKontroli.forEach(kontrolaExecutor -> {
            WynikKontroli wynikKontroli = kontrolaExecutor.wykonaj(feature, nazwaKontrolowanegoPliku);
            this.obsluzWynikKontroli(kontrolaExecutor.getKontrolaId(), wynikKontroli);
        });
    }

    private void obsluzWynikKontroli(String kontrolaId, WynikKontroli wynikKontroli) {
        if (wynikKontroli == null) {
            throw new RuntimeException("Wynik kontroli nie powinien przyjmowa\u0107 warto\u015bci null!");
        }
        OgolnePodsumowanieKontroli ogolnePodsumowanieKontroli = this.kontrolaTask.getLicznikKontroli().get(kontrolaId);
        if (wynikKontroli.isWykonana()) {
            ogolnePodsumowanieKontroli.inkrementujOgolem();
            if (!wynikKontroli.isPozytywny()) {
                ogolnePodsumowanieKontroli.inkrementujBledne();
                try {
                    if (wynikKontroli.getBladKontroli() != null) {
                        this.bledyWeryfikacjiService.zapiszBledyKontroli(wynikKontroli.getBladKontroli());
                    }
                }
                catch (BladSQLException e) {
                    KomunikatyUtils.budujAlertBledu("B\u0142\u0105d generowania wyniku kontroli", e.getMessage()).showAndWait();
                }
            }
        } else if (wynikKontroli.isBladKrytyczny()) {
            ogolnePodsumowanieKontroli.inkrementujBledyKrytyczne();
        } else {
            ogolnePodsumowanieKontroli.inkrementujPominietych();
        }
    }

    public List<KontrolaExecutor> getListaKontroli() {
        return this.listaKontroli;
    }

    public void setListaKontroli(List<KontrolaExecutor> listaKontroli) {
        this.listaKontroli = listaKontroli;
    }

    public KontrolaTask<Void> getKontrolaTask() {
        return this.kontrolaTask;
    }

    public void setKontrolaTask(KontrolaTask<Void> kontrolaTask) {
        this.kontrolaTask = kontrolaTask;
    }

    public BledyWeryfikacjiService getBledyWeryfikacjiService() {
        return this.bledyWeryfikacjiService;
    }

    public void setBledyWeryfikacjiService(BledyWeryfikacjiService bledyWeryfikacjiService) {
        this.bledyWeryfikacjiService = bledyWeryfikacjiService;
    }
}

