/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.gugik.gesut.dak.biz.utils.raporty.pdf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.xml.sax.SAXException;

public class PDFBuilder {
    private static final String SZABLON_RAPORTU = "rap_template.xslt";
    private FopFactory fopFactory;
    private String outputFilename;

    public PDFBuilder(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public void wypelnijSzablon(InputStream data) throws URISyntaxException, IOException, SAXException, TransformerException {
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        URI appUrl = new File(".").toURI();
        FopFactory fopFactory = FopFactory.newInstance((URI)appUrl, (InputStream)PDFBuilder.class.getResourceAsStream("fop.xconf"));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(this.getOutputFilename())));
        Fop fop = fopFactory.newFop("application/pdf", (OutputStream)out);
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslt = new StreamSource(PDFBuilder.class.getResourceAsStream(SZABLON_RAPORTU));
        Transformer transformer = factory.newTransformer(xslt);
        StreamSource src = new StreamSource(data);
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        transformer.transform(src, res);
        ((OutputStream)out).close();
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }
}

